/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVWriter;
import com.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BeanToCsv<T> {
    public boolean write(MappingStrategy<T> mapper, Writer writer, List<?> objects) {
        return this.write(mapper, new CSVWriter(writer), objects);
    }

    public boolean write(MappingStrategy<T> mapper, CSVWriter csv, List<?> objects) {
        if (objects == null || objects.isEmpty()) {
            return false;
        }
        try {
            csv.writeNext(this.processHeader(mapper));
            List<Method> getters = this.findGetters(mapper);
            this.processAndWriteObjects(csv, objects, getters);
            return true;
        }
        catch (Exception e2) {
            throw new RuntimeException("Error writing CSV !", e2);
        }
    }

    private void processAndWriteObjects(CSVWriter csv, List<?> objects, List<Method> getters) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        for (Object obj : objects) {
            String[] line = this.processObject(getters, obj);
            csv.writeNext(line);
        }
    }

    protected String[] processHeader(MappingStrategy<T> mapper) throws IntrospectionException {
        ArrayList<String> values = new ArrayList<String>();
        int i2 = 0;
        PropertyDescriptor prop = mapper.findDescriptor(i2);
        while (prop != null) {
            values.add(prop.getName());
            prop = mapper.findDescriptor(++i2);
        }
        return values.toArray(new String[0]);
    }

    protected String[] processObject(List<Method> getters, Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> values = new ArrayList<String>();
        for (Method getter : getters) {
            Object value = getter.invoke(bean, (Object[])null);
            if (value == null) {
                values.add("null");
                continue;
            }
            values.add(value.toString());
        }
        return values.toArray(new String[0]);
    }

    private List<Method> findGetters(MappingStrategy<T> mapper) throws IntrospectionException {
        int i2 = 0;
        PropertyDescriptor prop = mapper.findDescriptor(i2);
        ArrayList<Method> readers = new ArrayList<Method>();
        while (prop != null) {
            readers.add(prop.getReadMethod());
            prop = mapper.findDescriptor(++i2);
        }
        return readers;
    }
}

