/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ResultSetHelperService
implements ResultSetHelper {
    public static final int CLOBBUFFERSIZE = 2048;
    static final int NVARCHAR = -9;
    static final int NCHAR = -15;
    static final int LONGNVARCHAR = -16;
    static final int NCLOB = 2011;
    static final String DEFAULT_DATE_FORMAT = "dd-MMM-yyyy";
    static final String DEFAULT_TIMESTAMP_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private String dateFormat = "dd-MMM-yyyy";
    private String dateTimeFormat = "dd-MMM-yyyy HH:mm:ss";

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    private static String read(Clob c2) throws SQLException, IOException {
        int n2;
        StringBuilder sb = new StringBuilder((int)c2.length());
        Reader r2 = c2.getCharacterStream();
        char[] cbuf = new char[2048];
        while ((n2 = r2.read(cbuf, 0, cbuf.length)) != -1) {
            sb.append(cbuf, 0, n2);
        }
        return sb.toString();
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i2 = 0; i2 < metadata.getColumnCount(); ++i2) {
            names.add(metadata.getColumnLabel(i2 + 1));
        }
        String[] nameArray = new String[names.size()];
        return names.toArray(nameArray);
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        return this.getColumnValues(rs, false, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        return this.getColumnValues(rs, trim, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        ArrayList<String> values = new ArrayList<String>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i2 = 0; i2 < metadata.getColumnCount(); ++i2) {
            values.add(this.getColumnValue(rs, metadata.getColumnType(i2 + 1), i2 + 1, trim, dateFormatString, timeFormatString));
        }
        String[] valueArray = new String[values.size()];
        return values.toArray(valueArray);
    }

    protected String handleObject(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    protected String handleBigDecimal(BigDecimal decimal) {
        return decimal == null ? "" : decimal.toString();
    }

    protected String handleLong(ResultSet rs, int columnIndex) throws SQLException {
        long lv = rs.getLong(columnIndex);
        return rs.wasNull() ? "" : Long.toString(lv);
    }

    protected String handleInteger(ResultSet rs, int columnIndex) throws SQLException {
        int i2 = rs.getInt(columnIndex);
        return rs.wasNull() ? "" : Integer.toString(i2);
    }

    protected String handleDate(ResultSet rs, int columnIndex, String dateFormatString) throws SQLException {
        Date date = rs.getDate(columnIndex);
        String value = null;
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
            value = dateFormat.format(date);
        }
        return value;
    }

    protected String handleTime(Time time) {
        return time == null ? null : time.toString();
    }

    protected String handleTimestamp(Timestamp timestamp, String timestampFormatString) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(timestampFormatString);
        return timestamp == null ? null : timeFormat.format(timestamp);
    }

    private String getColumnValue(ResultSet rs, int colType, int colIndex, boolean trim, String dateFormatString, String timestampFormatString) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: 
            case 2000: {
                value = this.handleObject(rs.getObject(colIndex));
                break;
            }
            case 16: {
                boolean b2 = rs.getBoolean(colIndex);
                value = Boolean.valueOf(b2).toString();
                break;
            }
            case 2005: 
            case 2011: {
                Clob c2 = rs.getClob(colIndex);
                if (c2 == null) break;
                value = ResultSetHelperService.read(c2);
                break;
            }
            case -5: {
                value = this.handleLong(rs, colIndex);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                value = this.handleBigDecimal(rs.getBigDecimal(colIndex));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = this.handleInteger(rs, colIndex);
                break;
            }
            case 91: {
                value = this.handleDate(rs, colIndex, dateFormatString);
                break;
            }
            case 92: {
                value = this.handleTime(rs.getTime(colIndex));
                break;
            }
            case 93: {
                value = this.handleTimestamp(rs.getTimestamp(colIndex), timestampFormatString);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String columnValue = rs.getString(colIndex);
                if (trim && columnValue != null) {
                    value = columnValue.trim();
                    break;
                }
                value = columnValue;
                break;
            }
            default: {
                value = "";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }
}

