/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import com.opencsv.ResultSetHelperService;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CSVWriter
implements Closeable,
Flushable {
    public static final int INITIAL_STRING_SIZE = 1024;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final String RFC4180_LINE_END = "\r\n";
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    private ResultSetHelper resultService = new ResultSetHelperService();

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines, boolean applyQuotesToAll) {
        for (String[] line : allLines) {
            this.writeNext(line, applyQuotesToAll);
        }
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    protected void writeColumnNames(ResultSet rs) throws SQLException {
        this.writeNext(this.resultService.getColumnNames(rs));
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        return this.writeAll(rs, includeColumnNames, false);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames, boolean trim) throws SQLException, IOException {
        int linesWritten = 0;
        if (includeColumnNames) {
            this.writeColumnNames(rs);
            ++linesWritten;
        }
        while (rs.next()) {
            this.writeNext(this.resultService.getColumnValues(rs, trim));
            ++linesWritten;
        }
        return linesWritten;
    }

    public void writeNext(String[] nextLine, boolean applyQuotesToAll) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(nextLine.length * 2);
        for (int i2 = 0; i2 < nextLine.length; ++i2) {
            String nextElement;
            if (i2 != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i2]) == null) continue;
            Boolean stringContainsSpecialCharacters = this.stringContainsSpecialCharacters(nextElement);
            if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
                sb.append(this.quotechar);
            }
            if (stringContainsSpecialCharacters.booleanValue()) {
                sb.append((CharSequence)this.processLine(nextElement));
            } else {
                sb.append(nextElement);
            }
            if (!applyQuotesToAll && !stringContainsSpecialCharacters.booleanValue() || this.quotechar == '\u0000') continue;
            sb.append(this.quotechar);
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    public void writeNext(String[] nextLine) {
        this.writeNext(nextLine, true);
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1 || line.indexOf(this.separator) != -1 || line.contains(DEFAULT_LINE_END) || line.contains("\r");
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(nextElement.length() * 2);
        for (int j2 = 0; j2 < nextElement.length(); ++j2) {
            char nextChar = nextElement.charAt(j2);
            this.processCharacter(sb, nextChar);
        }
        return sb;
    }

    private void processCharacter(StringBuilder sb, char nextChar) {
        if (this.escapechar != '\u0000' && (nextChar == this.quotechar || nextChar == this.escapechar)) {
            sb.append(this.escapechar).append(nextChar);
        } else {
            sb.append(nextChar);
        }
    }

    @Override
    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    public void flushQuietly() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

