/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import java.text.DecimalFormat;
import org.krysalis.barcode4j.tools.PageInfo;

public class VariableUtil {
    private static final String PAGE_NUMBER = "#page-number#";
    private static final String PAGE_NUMBER_WITH_FORMAT = "#page-number:";
    private static final String FORMATTED_PAGE_NUMBER = "#formatted-page-number#";

    private static String replace(String text, String repl, String with) {
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String getExpandedMessage(PageInfo page, String msg) {
        int endidx;
        int idx;
        String s2 = msg;
        while ((idx = s2.indexOf(PAGE_NUMBER_WITH_FORMAT)) >= 0 && (endidx = s2.indexOf(35, idx + PAGE_NUMBER_WITH_FORMAT.length())) >= 0) {
            String value;
            String fmt = s2.substring(idx + PAGE_NUMBER_WITH_FORMAT.length(), endidx);
            StringBuffer sb = new StringBuffer(s2);
            if (page != null) {
                DecimalFormat nf = new DecimalFormat(fmt);
                value = nf.format(page.getPageNumber());
            } else {
                StringBuffer blanks = new StringBuffer(fmt.length());
                blanks.setLength(fmt.length());
                for (int i2 = 0; i2 < blanks.length(); ++i2) {
                    blanks.setCharAt(i2, '0');
                }
                value = blanks.toString();
            }
            sb.replace(idx, endidx + 1, value);
            s2 = sb.toString();
        }
        if (page != null) {
            s2 = VariableUtil.replace(s2, PAGE_NUMBER, Integer.toString(page.getPageNumber()));
            s2 = VariableUtil.replace(s2, FORMATTED_PAGE_NUMBER, page.getPageNumberString());
        } else {
            s2 = VariableUtil.replace(s2, PAGE_NUMBER, "000");
            s2 = VariableUtil.replace(s2, FORMATTED_PAGE_NUMBER, "000");
        }
        return s2;
    }
}

