/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLDecoder;
import org.krysalis.barcode4j.tools.Base64InputStream;
import org.krysalis.barcode4j.tools.IOUtil;

public class URLUtil {
    private static final String DATA_PROTOCOL = "data:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(String url, String encoding) throws IOException {
        if (url.startsWith(DATA_PROTOCOL)) {
            return URLUtil.parseDataURL(url, encoding);
        }
        URL u2 = new URL(url);
        InputStream in = u2.openStream();
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            IOUtil.copy(in, baout);
            byte[] byArray = baout.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }

    private static byte[] parseDataURL(String url, String encoding) throws IOException {
        int pos;
        int commaPos = url.indexOf(44);
        String header = url.substring(0, commaPos);
        String data = url.substring(commaPos + 1);
        if (header.endsWith(";base64")) {
            Base64InputStream in = new Base64InputStream(new StringReader(data));
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            IOUtil.copy(in, baout);
            IOUtil.closeQuietly(in);
            return baout.toByteArray();
        }
        String urlEncoding = "US-ASCII";
        int charsetpos = header.indexOf(";charset=");
        if (charsetpos > 0 && (pos = (urlEncoding = header.substring(charsetpos + 9)).indexOf(59)) > 0) {
            urlEncoding = urlEncoding.substring(0, pos);
        }
        String unescapedString = URLDecoder.decode(data, urlEncoding);
        byte[] bytes = unescapedString.getBytes(encoding);
        return bytes;
    }
}

