/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import org.krysalis.barcode4j.impl.pdf417.PDF417Constants;

public class PDF417HighLevelEncoder
implements PDF417Constants {
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;

    public static byte[] getBytesForMessage(String msg) {
        String charset = "cp437";
        try {
            return msg.getBytes("cp437");
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedOperationException("Incompatible JVM! The 'cp437' charset is not available!");
        }
    }

    public static String encodeHighLevel(String msg) {
        byte[] bytes = null;
        StringBuffer sb = new StringBuffer(msg.length());
        int len = msg.length();
        int p2 = 0;
        int encodingMode = 0;
        int textSubMode = 0;
        while (p2 < len) {
            int b2;
            int n2 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(msg, p2);
            if (n2 >= 13) {
                sb.append('\u0386');
                encodingMode = 2;
                textSubMode = 0;
                PDF417HighLevelEncoder.encodeNumeric(msg, p2, n2, sb);
                p2 += n2;
                continue;
            }
            int t2 = PDF417HighLevelEncoder.determineConsecutiveTextCount(msg, p2);
            if (t2 >= 5 || n2 == len) {
                if (encodingMode != 0) {
                    sb.append('\u0384');
                    encodingMode = 0;
                    textSubMode = 0;
                }
                textSubMode = PDF417HighLevelEncoder.encodeText(msg, p2, t2, sb, textSubMode);
                p2 += t2;
                continue;
            }
            if (bytes == null) {
                bytes = PDF417HighLevelEncoder.getBytesForMessage(msg);
            }
            if ((b2 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(msg, bytes, p2)) == 0) {
                b2 = 1;
            }
            if (b2 == 1 && encodingMode == 0) {
                PDF417HighLevelEncoder.encodeBinary(msg, bytes, p2, b2, encodingMode, sb);
            } else {
                PDF417HighLevelEncoder.encodeBinary(msg, bytes, p2, b2, encodingMode, sb);
                encodingMode = 1;
                textSubMode = 0;
            }
            p2 += b2;
        }
        return sb.toString();
    }

    public static int encodeText(String msg, int startpos, int count, StringBuffer sb, int initialSubmode) {
        StringBuffer tmp = new StringBuffer(count);
        int submode = initialSubmode;
        int idx = 0;
        block5: while (true) {
            char ch = msg.charAt(startpos + idx);
            switch (submode) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        if (ch != ' ') {
                            tmp.append((char)(ch - 65));
                            break;
                        }
                        tmp.append('\u001a');
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        if (ch != ' ') {
                            tmp.append((char)(ch - 97));
                            break;
                        }
                        tmp.append('\u001a');
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        tmp.append('\u001b');
                        tmp.append((char)(ch - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 2: {
                    char next;
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        tmp.append((char)MIXED[ch]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        submode = 0;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (startpos + idx + 1 < count && PDF417HighLevelEncoder.isPunctuation(next = msg.charAt(startpos + idx + 1))) {
                        submode = 3;
                        tmp.append('\u0019');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(ch)) {
                        tmp.append((char)PUNCTUATION[ch]);
                        break;
                    }
                    submode = 0;
                    tmp.append('\u001d');
                    continue block5;
                }
            }
            if (++idx >= count) break;
        }
        char h2 = '\u0000';
        int len = tmp.length();
        for (int i2 = 0; i2 < len; ++i2) {
            boolean odd;
            boolean bl = odd = i2 % 2 != 0;
            if (odd) {
                h2 = (char)(h2 * 30 + tmp.charAt(i2));
                sb.append(h2);
                continue;
            }
            h2 = tmp.charAt(i2);
        }
        if (len % 2 != 0) {
            sb.append((char)(h2 * 30 + 29));
        }
        return submode;
    }

    public static void encodeBinary(String msg, byte[] bytes, int startpos, int count, int startmode, StringBuffer sb) {
        if (count == 1 && startmode == 0) {
            sb.append('\u0391');
        } else {
            boolean sixpack;
            boolean bl = sixpack = count % 6 == 0;
            if (sixpack) {
                sb.append('\u039c');
            } else {
                sb.append('\u0385');
            }
        }
        char[] chars = new char[5];
        int idx = startpos;
        while (startpos + count - idx >= 6) {
            int i2;
            long t2 = 0L;
            for (i2 = 0; i2 < 6; ++i2) {
                t2 <<= 8;
                t2 += (long)(bytes[idx + i2] & 0xFF);
            }
            for (i2 = 0; i2 < 5; ++i2) {
                chars[i2] = (char)(t2 % 900L);
                t2 /= 900L;
            }
            for (i2 = chars.length - 1; i2 >= 0; --i2) {
                sb.append(chars[i2]);
            }
            idx += 6;
        }
        for (int i3 = idx; i3 < startpos + count; ++i3) {
            int ch = bytes[i3] & 0xFF;
            sb.append((char)ch);
        }
    }

    public static void encodeNumeric(String msg, int startpos, int count, StringBuffer sb) {
        int len;
        StringBuffer tmp = new StringBuffer(count / 3 + 1);
        BigInteger num900 = BigInteger.valueOf(900L);
        BigInteger num0 = BigInteger.valueOf(0L);
        for (int idx = 0; idx < count - 1; idx += len) {
            tmp.setLength(0);
            len = Math.min(44, count - idx);
            String part = "1" + msg.substring(startpos + idx, startpos + idx + len);
            BigInteger bigint = new BigInteger(part);
            do {
                BigInteger c2 = bigint.mod(num900);
                tmp.append((char)c2.intValue());
            } while (!(bigint = bigint.divide(num900)).equals(num0));
            for (int i2 = tmp.length() - 1; i2 >= 0; --i2) {
                sb.append(tmp.charAt(i2));
            }
        }
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isAlphaUpper(char ch) {
        return ch == ' ' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAlphaLower(char ch) {
        return ch == ' ' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isMixed(char ch) {
        return MIXED[ch] != -1;
    }

    private static boolean isPunctuation(char ch) {
        return PUNCTUATION[ch] != -1;
    }

    private static boolean isText(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '~';
    }

    public static int determineConsecutiveDigitCount(String msg, int startpos) {
        int count = 0;
        int idx = startpos;
        int len = msg.length();
        if (idx < len) {
            char ch = msg.charAt(idx);
            while (PDF417HighLevelEncoder.isDigit(ch) && idx < len) {
                ++count;
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
        }
        return count;
    }

    public static int determineConsecutiveTextCount(String msg, int startpos) {
        int len = msg.length();
        int idx = startpos;
        while (idx < len) {
            int numericCount;
            char ch = msg.charAt(idx);
            for (numericCount = 0; numericCount < 13 && PDF417HighLevelEncoder.isDigit(ch) && idx < len; ++numericCount) {
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
            if (numericCount >= 13) {
                return idx - startpos - numericCount;
            }
            if (numericCount > 0) continue;
            ch = msg.charAt(idx);
            if (!PDF417HighLevelEncoder.isText(ch)) break;
            ++idx;
        }
        return idx - startpos;
    }

    public static int determineConsecutiveBinaryCount(String msg, byte[] bytes, int startpos) {
        int idx;
        int len = msg.length();
        for (idx = startpos; idx < len; ++idx) {
            int i2;
            char ch = msg.charAt(idx);
            int numericCount = 0;
            int textCount = 0;
            while (numericCount < 13 && PDF417HighLevelEncoder.isDigit(ch) && (i2 = idx + ++numericCount) < len) {
                ch = msg.charAt(i2);
            }
            if (numericCount >= 13) {
                return idx - startpos;
            }
            while (textCount < 5 && PDF417HighLevelEncoder.isText(ch) && (i2 = idx + ++textCount) < len) {
                ch = msg.charAt(i2);
            }
            if (textCount >= 5) {
                return idx - startpos;
            }
            ch = msg.charAt(idx);
            if (bytes[idx] != 63 || ch == '?') continue;
            throw new IllegalArgumentException("Non-encodable character detected: " + ch + " (Unicode: " + ch + ")");
        }
        return idx - startpos;
    }

    static {
        byte b2;
        int i2;
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        Arrays.fill(MIXED, (byte)-1);
        for (i2 = 0; i2 < TEXT_MIXED_RAW.length; i2 = (int)((byte)(i2 + 1))) {
            b2 = TEXT_MIXED_RAW[i2];
            if (b2 <= 0) continue;
            PDF417HighLevelEncoder.MIXED[b2] = i2;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (i2 = 0; i2 < TEXT_PUNCTUATION_RAW.length; i2 = (int)((byte)(i2 + 1))) {
            b2 = TEXT_PUNCTUATION_RAW[i2];
            if (b2 <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[b2] = i2;
        }
    }
}

