/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import org.krysalis.barcode4j.impl.datamatrix.DataMatrixReedSolomonFactors;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;

public class DataMatrixErrorCorrection
implements DataMatrixReedSolomonFactors {
    private static final int MODULO_VALUE = 301;
    private static final int[] LOG = new int[256];
    private static final int[] ALOG = new int[255];

    public static String encodeECC200(String codewords, DataMatrixSymbolInfo symbolInfo) {
        if (codewords.length() != symbolInfo.dataCapacity) {
            throw new IllegalArgumentException("The number of codewords does not match the selected symbol");
        }
        StringBuffer sb = new StringBuffer(symbolInfo.dataCapacity + symbolInfo.errorCodewords);
        sb.append(codewords);
        int blockCount = symbolInfo.getInterleavedBlockCount();
        if (blockCount == 1) {
            String ecc = DataMatrixErrorCorrection.createECCBlock(codewords, symbolInfo.errorCodewords);
            sb.append(ecc);
        } else {
            sb.setLength(sb.capacity());
            int[] dataSizes = new int[blockCount];
            int[] errorSizes = new int[blockCount];
            int[] startPos = new int[blockCount];
            for (int i2 = 0; i2 < blockCount; ++i2) {
                dataSizes[i2] = symbolInfo.getDataLengthForInterleavedBlock(i2 + 1);
                errorSizes[i2] = symbolInfo.getErrorLengthForInterleavedBlock(i2 + 1);
                startPos[i2] = 0;
                if (i2 <= 0) continue;
                startPos[i2] = startPos[i2 - 1] + dataSizes[i2];
            }
            for (int block = 0; block < blockCount; ++block) {
                StringBuffer temp = new StringBuffer(dataSizes[block]);
                for (int d2 = block; d2 < symbolInfo.dataCapacity; d2 += blockCount) {
                    temp.append(codewords.charAt(d2));
                }
                String ecc = DataMatrixErrorCorrection.createECCBlock(temp.toString(), errorSizes[block]);
                int pos = 0;
                for (int e2 = block; e2 < errorSizes[block] * blockCount; e2 += blockCount) {
                    sb.setCharAt(symbolInfo.dataCapacity + e2, ecc.charAt(pos++));
                }
            }
        }
        return sb.toString();
    }

    private static String createECCBlock(String codewords, int numECWords) {
        return DataMatrixErrorCorrection.createECCBlock(codewords, 0, codewords.length(), numECWords);
    }

    private static String createECCBlock(String codewords, int start, int len, int numECWords) {
        int i2;
        int table = -1;
        for (int i3 = 0; i3 < FACTOR_SETS.length; ++i3) {
            if (FACTOR_SETS[i3] != numECWords) continue;
            table = i3;
            break;
        }
        if (table < 0) {
            throw new IllegalArgumentException("Illegal number of error correction codewords specified: " + numECWords);
        }
        int[] poly = DataMatrixReedSolomonFactors.FACTORS[table];
        char[] ecc = new char[numECWords];
        for (i2 = 0; i2 < numECWords; ++i2) {
            ecc[i2] = '\u0000';
        }
        for (i2 = start; i2 < start + len; ++i2) {
            int m2 = ecc[numECWords - 1] ^ codewords.charAt(i2);
            for (int k2 = numECWords - 1; k2 > 0; --k2) {
                ecc[k2] = m2 != 0 && poly[k2] != 0 ? (char)(ecc[k2 - 1] ^ ALOG[(LOG[m2] + LOG[poly[k2]]) % 255]) : ecc[k2 - 1];
            }
            ecc[0] = m2 != 0 && poly[0] != 0 ? (char)ALOG[(LOG[m2] + LOG[poly[0]]) % 255] : (char)'\u0000';
        }
        char[] eccReversed = new char[numECWords];
        for (int i4 = 0; i4 < numECWords; ++i4) {
            eccReversed[i4] = ecc[numECWords - i4 - 1];
        }
        return String.valueOf(eccReversed);
    }

    static {
        int p2 = 1;
        for (int i2 = 0; i2 < 255; ++i2) {
            DataMatrixErrorCorrection.ALOG[i2] = p2;
            DataMatrixErrorCorrection.LOG[p2] = i2;
            if ((p2 <<= 1) < 256) continue;
            p2 ^= 0x12D;
        }
    }
}

