/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code39;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class Code39LogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', '*'};
    private static final char STARTSTOP = '*';
    private static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;
    private boolean displayChecksum = false;
    private boolean extendedCharSet = false;

    public Code39LogicImpl(ChecksumMode mode, boolean displayStartStop, boolean displayChecksum, boolean extendedCharSet) {
        this.checksumMode = mode;
        this.displayStartStop = displayStartStop;
        this.displayChecksum = displayChecksum;
        this.extendedCharSet = extendedCharSet;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    private static void invalidCharacter(char c2) {
        if (c2 != '*') {
            throw new IllegalArgumentException("Invalid character: " + c2);
        }
        throw new IllegalArgumentException("You may not include '*' as part of the message. This start/stop character is automatically added before and after the message.");
    }

    StringBuffer prepareMessage(String msg) {
        if (this.extendedCharSet) {
            return Code39LogicImpl.escapeExtended(msg, null);
        }
        if (msg.startsWith("*") && msg.endsWith("*")) {
            return new StringBuffer(msg.substring(1, msg.length() - 1));
        }
        return new StringBuffer(msg);
    }

    public static StringBuffer escapeExtended(String msg, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer(msg.length());
        }
        int c2 = msg.length();
        for (int i2 = 0; i2 < c2; ++i2) {
            char ch = msg.charAt(i2);
            if (ch == '\u0000') {
                sb.append("%U");
                continue;
            }
            if (ch >= '\u0001' && ch <= '\u001a') {
                sb.append('$').append((char)(65 + ch - 1));
                continue;
            }
            if (ch >= '\u001b' && ch <= '\u001f') {
                sb.append('%').append((char)(65 + ch - 27));
                continue;
            }
            if (ch == ' ') {
                sb.append(ch);
                continue;
            }
            if (ch >= '!' && ch <= '/') {
                sb.append('/').append((char)(65 + ch - 33));
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == ':') {
                sb.append("/Z");
                continue;
            }
            if (ch >= ';' && ch <= '?') {
                sb.append('%').append((char)(70 + ch - 59));
                continue;
            }
            if (ch == '@') {
                sb.append("%V");
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                sb.append(ch);
                continue;
            }
            if (ch >= '[' && ch <= '_') {
                sb.append('%').append((char)(75 + ch - 91));
                continue;
            }
            if (ch == '`') {
                sb.append("%W");
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                sb.append('+').append((char)(65 + ch - 97));
                continue;
            }
            if (ch >= '{' && ch <= '\u007f') {
                sb.append('%').append((char)(80 + ch - 123));
                continue;
            }
            throw new IllegalArgumentException("Character 0x" + Integer.toHexString(ch) + " is not supported by Extended Code 39!");
        }
        return sb;
    }

    public static char calcChecksum(String msg) {
        int checksum = 0;
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            int chidx = Code39LogicImpl.getCharIndex(msg.charAt(i2));
            if (chidx >= 0) {
                checksum += chidx;
                continue;
            }
            Code39LogicImpl.invalidCharacter(msg.charAt(i2));
        }
        return CHARACTERS[checksum % 43];
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = Code39LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private static int getCharIndex(char ch) {
        char effch = ch >= 'a' && ch <= 'z' ? Character.toUpperCase(ch) : ch;
        for (int i2 = 0; i2 < CHARACTERS.length; ++i2) {
            if (effch != CHARACTERS[i2]) continue;
            return i2;
        }
        return -1;
    }

    private static boolean isValidChar(char ch) {
        if (ch == '*') {
            return false;
        }
        return Code39LogicImpl.getCharIndex(ch) >= 0;
    }

    private int widthAt(char ch, int index) {
        int chidx = Code39LogicImpl.getCharIndex(ch);
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        Code39LogicImpl.invalidCharacter(ch);
        return 0;
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c2) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c2).toString());
        for (int i2 = 0; i2 < 9; i2 = (int)((byte)(i2 + 1))) {
            int width = this.widthAt(c2, i2);
            boolean black = i2 % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler logic) {
        logic.addBar(false, -1);
    }

    private String handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                sb.append(Code39LogicImpl.calcChecksum(sb.toString()));
                return sb.toString();
            }
            String msg = sb.toString();
            sb.append(Code39LogicImpl.calcChecksum(msg));
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Code39LogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + Code39LogicImpl.calcChecksum(sb.toString()));
            }
            if (this.displayChecksum) {
                return sb.toString();
            }
            return sb.substring(0, sb.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return sb.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return sb.toString();
        }
        throw new IllegalStateException("Unknown checksum mode");
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String displayMsg;
        StringBuffer sb = this.prepareMessage(msg);
        String formattedMsg = this.handleChecksum(sb);
        if (this.extendedCharSet) {
            displayMsg = msg;
        } else {
            displayMsg = formattedMsg;
            if (this.displayStartStop) {
                displayMsg = '*' + displayMsg + '*';
            }
        }
        logic.startBarcode(sb.toString(), displayMsg);
        logic.startBarGroup(BarGroup.START_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            this.addIntercharacterGap(logic);
            char ch = sb.charAt(i2);
            if (!Code39LogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
        }
        this.addIntercharacterGap(logic);
        logic.startBarGroup(BarGroup.STOP_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        logic.endBarcode();
    }
}

