/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.jgroups;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.jgroups.JGroupsRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.broadcast.BroadcastTransportManager;
import org.jgroups.JChannel;

public class JGroupsTransportManager
extends BroadcastTransportManager {
    protected String configFile = "";

    public JGroupsTransportManager() {
    }

    public JGroupsTransportManager(RemoteCommandManager rcm) {
        super(rcm);
    }

    protected JGroupsRemoteConnection createConnection(boolean isLocalConnectionBeingCreated) throws RemoteCommandManagerException {
        try {
            JChannel channel = this.configFile != null && !this.configFile.isEmpty() ? new JChannel(this.configFile) : new JChannel();
            channel.connect(this.rcm.getChannel());
            channel.setDiscardOwnMessages(true);
            return new JGroupsRemoteConnection(this.rcm, channel, isLocalConnectionBeingCreated);
        }
        catch (Exception ex) {
            throw RemoteCommandManagerException.errorCreatingJGroupsConnection(this.configFile, ex);
        }
    }

    @Override
    public void createConnections() {
        this.createLocalConnection();
        this.createExternalConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalConnection() {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            if (this.connectionsToExternalServices.isEmpty()) {
                try {
                    this.connectionsToExternalServices.put(this.rcm.getServiceId().getId(), this.localConnection);
                }
                catch (RemoteCommandManagerException rcmException) {
                    this.rcm.handleException(rcmException);
                }
            }
        }
    }

    @Override
    public synchronized void createLocalConnection() {
        if (this.localConnection == null) {
            try {
                this.localConnection = this.createConnection(true);
            }
            catch (RemoteCommandManagerException rcmException) {
                this.rcm.handleException(rcmException);
            }
        }
    }

    @Override
    public Map<String, RemoteConnection> getConnectionsToExternalServicesForCommandPropagation() {
        if (this.getConnectionsToExternalServices().isEmpty() && !this.rcm.isStopped()) {
            this.createExternalConnection();
        }
        return super.getConnectionsToExternalServicesForCommandPropagation();
    }

    @Override
    public void removeLocalConnection() {
    }

    public String getConfigFile() {
        return this.configFile;
    }

    @Deprecated
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfig(String config) {
        this.configFile = config;
    }
}

