/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOType
implements Type,
Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private QName qName;
    private boolean open;
    private boolean isAbstract;
    protected boolean isDataType;
    private List baseTypes;
    private List declaredProperties;
    private transient Map declaredPropertiesMap;
    private List aliasNames;
    private boolean xsd;
    private boolean xsdList;
    private String xsdLocalName;
    private QName xsdType;
    protected transient XMLDescriptor xmlDescriptor;
    private Map propertyValues;
    private SDOProperty changeSummaryProperty;
    private List allProperties;
    private SDOProperty[] allPropertiesArr;
    private List subTypes;
    private boolean finalized;
    private Class javaClass;
    private String javaClassName;
    private String javaImplClassName;
    protected Class javaImplClass;
    private List<SDOProperty> nonFinalizedReferencingProps;
    private List nonFinalizedMappingURIs;
    private Object pseudoDefault;
    protected HelperContext aHelperContext;
    private List appInfoElements;
    private Map appInfoMap;
    private static final String ANY_MAPPING_ATTRIBUTE_NAME = "openContentProperties";
    private static final String ANY_MAPPING_GET_METHOD_NAME = "_getOpenContentPropertiesWithXMLRoots";
    private static final String ANY_MAPPING_SET_METHOD_NAME = "_setOpenContentPropertiesWithXMLRoots";
    private static final String SDO_REF_MAPPING_ATTRIBUTE_NAME = "sdoRef";

    public SDOType(HelperContext helperContext) {
        this((SDOTypeHelper)helperContext.getTypeHelper());
    }

    public SDOType(SDOTypeHelper sdoTypeHelper) {
        this(sdoTypeHelper, new XMLDescriptor());
        this.xmlDescriptor.setLazilyInitialized(true);
    }

    protected SDOType(SDOTypeHelper sdoTypeHelper, XMLDescriptor xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
        if (sdoTypeHelper != null) {
            this.aHelperContext = sdoTypeHelper.getHelperContext();
            if (xmlDescriptor != null) {
                this.xmlDescriptor.setNamespaceResolver(sdoTypeHelper.getNamespaceResolver());
            }
        }
    }

    public SDOType(String uri, String type_name) {
        this(uri, type_name, (SDOTypeHelper)HelperProvider.getDefaultContext().getTypeHelper());
    }

    public SDOType(String uri, String name, SDOTypeHelper sdoTypeHelper) {
        this(sdoTypeHelper);
        if (uri != null) {
            uri = uri.intern();
        }
        if (name != null) {
            name = name.intern();
        }
        this.qName = new QName(uri, name);
    }

    protected SDOType(String uri, String name, SDOTypeHelper sdoTypeHelper, XMLDescriptor xmlDescriptor) {
        this(sdoTypeHelper, xmlDescriptor);
        if (uri != null) {
            uri = uri.intern();
        }
        if (name != null) {
            name = name.intern();
        }
        this.qName = new QName(uri, name);
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getName() {
        return this.qName.getLocalPart();
    }

    public String getURI() {
        String uri = this.qName.getNamespaceURI();
        if ("".equals(uri)) {
            return null;
        }
        return uri;
    }

    public Class getInstanceClass() {
        if (this.javaClass == null && this.javaClassName != null) {
            try {
                SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                Class<?> clazz = loader.getParent().loadClass(this.javaClassName);
                this.javaClass = this.isValidInstanceClass(clazz) ? clazz : this.getClass();
            }
            catch (ClassNotFoundException e2) {
                this.javaClass = this.getClass();
            }
            catch (SecurityException e3) {
                throw SDOException.classNotFound(e3, this.getURI(), this.getName());
            }
        }
        if (this.javaClass == this.getClass()) {
            return null;
        }
        return this.javaClass;
    }

    private boolean isValidInstanceClass(Class clazz) {
        if (this.isDataType) {
            return true;
        }
        if (!clazz.isInterface()) {
            return false;
        }
        return !this.isStrictTypeCheckingEnabled() || this.hasClassGetterForEachProperty(clazz);
    }

    private boolean hasClassGetterForEachProperty(Class clazz) {
        for (Object object : this.getDeclaredProperties()) {
            SDOProperty sdoProperty = (SDOProperty)object;
            SDOType sdoPropertyType = sdoProperty.getType();
            if (sdoPropertyType.isChangeSummaryType()) continue;
            String javaType = SDOUtil.getJavaTypeForProperty(sdoProperty);
            try {
                String getMethodName = SDOUtil.getMethodName(sdoProperty.getName(), javaType);
                PrivilegedAccessHelper.getPublicMethod(clazz, getMethodName, EMPTY_CLASS_ARRAY, false);
            }
            catch (NoSuchMethodException e2) {
                if (sdoPropertyType == SDOConstants.SDO_BOOLEAN || sdoPropertyType == SDOConstants.SDO_BOOLEANOBJECT) {
                    try {
                        String booleanGetterMethodName = SDOUtil.getBooleanGetMethodName(sdoProperty.getName(), javaType);
                        PrivilegedAccessHelper.getPublicMethod(clazz, booleanGetterMethodName, EMPTY_CLASS_ARRAY, false);
                        continue;
                    }
                    catch (NoSuchMethodException e22) {
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean isStrictTypeCheckingEnabled() {
        HelperContext helperContext = this.getHelperContext();
        if (helperContext instanceof SDOHelperContext) {
            return ((SDOHelperContext)helperContext).isStrictTypeCheckingEnabled();
        }
        return true;
    }

    public boolean isInstance(Object object) {
        Type doType;
        if (!this.isDataType() && object instanceof DataObject && (doType = ((DataObject)object).getType()) != null) {
            return doType.equals(this);
        }
        Class instanceClass = this.getInstanceClass();
        if (instanceClass != null) {
            return instanceClass.isInstance(object);
        }
        return false;
    }

    public List getProperties() {
        if (this.allProperties == null) {
            this.allProperties = new ArrayList();
        }
        return this.allProperties;
    }

    public SDOProperty getProperty(String propertyName) {
        SDOProperty queriedProperty = (SDOProperty)this.getDeclaredPropertiesMap().get(propertyName);
        if (queriedProperty == null && this.isSubType()) {
            int i2 = 0;
            while (i2 < this.getBaseTypes().size()) {
                queriedProperty = ((SDOType)this.getBaseTypes().get(i2)).getProperty(propertyName);
                if (queriedProperty != null) break;
                ++i2;
            }
        }
        return queriedProperty;
    }

    public boolean isDataType() {
        return this.isDataType;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isSequenced() {
        return this.xmlDescriptor.isSequencedObject();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List getBaseTypes() {
        if (this.baseTypes == null) {
            this.baseTypes = new ArrayList();
        }
        return this.baseTypes;
    }

    public boolean isSubType() {
        return this.baseTypes != null && !this.baseTypes.isEmpty();
    }

    public List getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = new ArrayList();
        }
        return this.declaredProperties;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = new ArrayList();
        }
        return this.aliasNames;
    }

    public void addAliasName(String name) {
        this.getAliasNames().add(name);
        QName qname = new QName(this.getURI(), name);
        ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypesHashMap().put(qname, this);
    }

    public void setAliasNames(List names) {
        int i2 = 0;
        while (i2 < names.size()) {
            this.addAliasName((String)names.get(i2));
            ++i2;
        }
    }

    public void setOpen(boolean bOpen) {
        if (this.isDataType() && bOpen) {
            throw SDOException.typeCannotBeOpenAndDataType(this.getURI(), this.getName());
        }
        if (this.open != bOpen) {
            this.open = bOpen;
            if (this.open) {
                if (this.isSubType()) {
                    Type baseType = (Type)this.getBaseTypes().get(0);
                    if (!baseType.isOpen()) {
                        this.addOpenMappings();
                    }
                } else {
                    this.addOpenMappings();
                }
                if (this.isBaseType()) {
                    int i2 = 0;
                    while (i2 < this.getSubTypes().size()) {
                        SDOType nextSubType = (SDOType)this.getSubTypes().get(i2);
                        nextSubType.setOpen(bOpen);
                        ++i2;
                    }
                }
            }
        }
    }

    private void addOpenMappings() {
        XMLAnyCollectionMapping anyMapping = new XMLAnyCollectionMapping();
        anyMapping.setAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
        anyMapping.setGetMethodName(ANY_MAPPING_GET_METHOD_NAME);
        anyMapping.setSetMethodName(ANY_MAPPING_SET_METHOD_NAME);
        anyMapping.setUseXMLRoot(true);
        this.getXmlDescriptor().addMapping(anyMapping);
        XMLAnyAttributeMapping anyAttrMapping = new XMLAnyAttributeMapping();
        anyAttrMapping.setAttributeName("openContentPropertiesAttributes");
        anyAttrMapping.setGetMethodName("_getOpenContentPropertiesAttributesMap");
        anyAttrMapping.setSetMethodName("_setOpenContentPropertiesAttributesMap");
        this.getXmlDescriptor().addMapping(anyAttrMapping);
    }

    public void setAbstract(boolean makeAbstract) {
        this.isAbstract = makeAbstract;
    }

    public void setSequenced(boolean sequenced) {
        this.xmlDescriptor.setSequencedObject(sequenced);
    }

    public void setMixed(boolean isMixed) {
        String textAttribute = "text";
        XMLDirectMapping textMapping = (XMLDirectMapping)this.xmlDescriptor.getMappingForAttributeName(textAttribute);
        if (isMixed) {
            if (textMapping == null) {
                textMapping = new XMLDirectMapping();
                textMapping.setAttributeName(textAttribute);
                textMapping.setXPath("text()");
                this.xmlDescriptor.addMapping(textMapping);
            }
        } else {
            this.xmlDescriptor.removeMappingForAttributeName(textAttribute);
        }
    }

    public void setDataType(boolean datatype) {
        if (datatype && this.isOpen()) {
            throw SDOException.typeCannotBeOpenAndDataType(this.getURI(), this.getName());
        }
        this.isDataType = datatype;
        if (datatype) {
            this.setFinalized(true);
        }
    }

    public void setBaseTypes(List bTypes) {
        if (bTypes != null) {
            int i2 = 0;
            while (i2 < bTypes.size()) {
                this.addBaseType((SDOType)bTypes.get(i2));
                ++i2;
            }
        } else {
            this.baseTypes = null;
        }
    }

    public void addBaseType(SDOType type) {
        if (!this.getBaseTypes().contains(type)) {
            this.getBaseTypes().add(type);
            this.updateSubtypes(type);
            if (!type.isDataType() || type.getQName().getNamespaceURI() != "commonj.sdo" && type.getQName().getNamespaceURI() != "commonj.sdo/java") {
                type.getSubTypes().add(this);
            }
            if (type.isOpen() && this.isOpen()) {
                CoreMapping anyCollectionMapping = this.getXmlDescriptor().getMappingForAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
                this.getXmlDescriptor().getMappings().remove(anyCollectionMapping);
                CoreMapping anyAttrMapping = this.getXmlDescriptor().getMappingForAttributeName("openContentPropertiesAttributes");
                this.getXmlDescriptor().getMappings().remove(anyAttrMapping);
            }
        }
    }

    private void updateSubtypes(Type baseType) {
        this.getProperties().addAll(0, baseType.getProperties());
        if (this.isBaseType()) {
            int i2 = 0;
            while (i2 < this.getSubTypes().size()) {
                SDOType nextSubType = (SDOType)this.getSubTypes().get(i2);
                nextSubType.updateSubtypes(baseType);
                ++i2;
            }
        }
    }

    public void setInstanceClass(Class aClass) {
        this.javaClass = aClass;
        if (this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
    }

    public void setXsd(boolean bXsd) {
        this.xsd = bXsd;
    }

    public boolean isXsd() {
        return this.xsd;
    }

    public void setXsdLocalName(String xsdLocalNameString) {
        this.xsdLocalName = xsdLocalNameString;
    }

    public String getXsdLocalName() {
        return this.xsdLocalName;
    }

    public void addDeclaredProperty(Property property) {
        this.addDeclaredProperty((SDOProperty)property);
    }

    public void addDeclaredProperty(SDOProperty property) {
        int end = this.getDeclaredProperties().size();
        this.addDeclaredProperty(property, end);
    }

    public void addDeclaredProperty(Property property, int index) {
        this.addDeclaredProperty((SDOProperty)property, index);
    }

    public void addDeclaredProperty(SDOProperty property, int index) {
        if (!this.getDeclaredPropertiesMap().containsKey(property.getName())) {
            int currentSize = this.getDeclaredProperties().size();
            int allSize = this.getProperties().size();
            int insertPlace = allSize - currentSize + index;
            if (this.isBaseType()) {
                int i2 = 0;
                while (i2 < this.getSubTypes().size()) {
                    SDOType nextSubType = (SDOType)this.getSubTypes().get(i2);
                    nextSubType.updateIndices(insertPlace, property);
                    ++i2;
                }
            }
            this.getDeclaredProperties().add(index, property);
            this.getProperties().add(insertPlace, property);
            property.setContainingType(this);
            this.getDeclaredPropertiesMap().put(property.getName(), property);
            if (property.hasAliasNames()) {
                int j2 = 0;
                while (j2 < property.getAliasNames().size()) {
                    this.getDeclaredPropertiesMap().put(property.getAliasNames().get(j2), property);
                    ++j2;
                }
            }
            if (property.getType() != null && property.getType().isChangeSummaryType()) {
                this.changeSummaryProperty = property;
            }
        }
    }

    public void removeDeclaredProperties(Property p2) {
        this.getDeclaredProperties().remove(p2);
        this.getDeclaredPropertiesMap().remove(p2.getName());
        this.getProperties().remove(p2);
    }

    public Map getDeclaredPropertiesMap() {
        if (this.declaredPropertiesMap == null) {
            this.declaredPropertiesMap = new HashMap();
        }
        return this.declaredPropertiesMap;
    }

    public void setInstanceClassName(String instanceClassName) {
        this.javaClassName = instanceClassName;
        this.javaClass = null;
    }

    public String getInstanceClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public void setXsdList(boolean anXsdList) {
        this.xsdList = anXsdList;
    }

    public boolean isXsdList() {
        return this.xsdList;
    }

    public void setXmlDescriptor(XMLDescriptor anXMLDescriptor) {
        this.xmlDescriptor = anXMLDescriptor;
    }

    public XMLDescriptor getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void initializeNamespaces(List namespaceResolvers) {
        if (!this.isDataType()) {
            NamespaceResolver nr = new NamespaceResolver();
            if (namespaceResolvers != null) {
                int i2 = 0;
                while (i2 < namespaceResolvers.size()) {
                    NamespaceResolver nextNR = (NamespaceResolver)namespaceResolvers.get(i2);
                    if (nextNR != null) {
                        int j2 = 0;
                        int size = nextNR.getNamespaces().size();
                        while (j2 < size) {
                            Namespace nextNamespace = (Namespace)nextNR.getNamespaces().get(j2);
                            if (!(nextNamespace.getPrefix().equals("xmlns") || nextNamespace.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || nextNamespace.getNamespaceURI().equals("commonj.sdo/java") || nextNamespace.getNamespaceURI().equals("commonj.sdo/xml") || nextNamespace.getNamespaceURI().equals("commonj.sdo"))) {
                                String newPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addNamespace(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                                nr.put(newPrefix, nextNamespace.getNamespaceURI());
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
            this.xmlDescriptor.setNamespaceResolver(nr);
            if (this.getURI() != null) {
                String prefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(this.getURI());
                this.xmlDescriptor.getNamespaceResolver().put(prefix, this.getURI());
            }
            this.xmlDescriptor.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    private void addClassIndicator(XMLDescriptor xdesc, Class pCls, boolean isInheritanceRoot) {
        XMLField field = (XMLField)this.getXmlDescriptor().buildField("@xsi:type");
        field.initialize();
        xdesc.getInheritancePolicy().setClassIndicatorField(field);
        String parentIndicator = this.getName();
        String parentPrefix = xdesc.getNamespaceResolver().resolveNamespaceURI(this.getURI());
        if (parentPrefix != null) {
            parentIndicator = String.valueOf(parentPrefix) + ":" + parentIndicator;
        }
        xdesc.getInheritancePolicy().addClassIndicator(pCls, parentIndicator);
        if (xdesc.getMappingForAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME) == null) {
            String sdoPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            XMLDirectMapping sdoRefMapping = new XMLDirectMapping();
            sdoRefMapping.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            XMLField xmlField = new XMLField("@" + sdoPrefix + ":" + "ref");
            xmlField.getXPathFragment().setNamespaceURI("commonj.sdo");
            xmlField.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            sdoRefMapping.setField(xmlField);
            xdesc.addMapping(sdoRefMapping);
        }
    }

    public void setupInheritance(SDOType parentType) {
        if (parentType == null) {
            this.addClassIndicator(this.getXmlDescriptor(), this.getImplClass(), true);
        } else if (parentType.getURI() != null && !parentType.getURI().equals("commonj.sdo")) {
            XMLDescriptor parentDescriptor;
            NamespaceResolver parentNR;
            if (!parentType.getXmlDescriptor().hasInheritance()) {
                this.addClassIndicator(parentType.getXmlDescriptor(), parentType.getImplClass(), false);
            }
            if ((parentNR = (parentDescriptor = (XMLDescriptor)parentType.getXmlDescriptor().getInheritancePolicy().getRootParentDescriptor()).getNonNullNamespaceResolver()) != null) {
                int i2 = 0;
                while (i2 < parentNR.getNamespaces().size()) {
                    Namespace nextNamespace = (Namespace)parentNR.getNamespaces().get(i2);
                    if (!(nextNamespace.getPrefix().equals("xmlns") || nextNamespace.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || nextNamespace.getNamespaceURI().equals("commonj.sdo/java") || nextNamespace.getNamespaceURI().equals("commonj.sdo/xml") || nextNamespace.getNamespaceURI().equals("commonj.sdo"))) {
                        this.getXmlDescriptor().getNonNullNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                    }
                    ++i2;
                }
            }
            if (this.getInstanceClassName() != null) {
                String indicator = this.getName();
                String prefix = parentDescriptor.getNamespaceResolver().resolveNamespaceURI(this.getURI());
                if (prefix == null && (prefix = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null) {
                    parentDescriptor.getNamespaceResolver().put(prefix, this.getURI());
                }
                if (prefix != null) {
                    indicator = String.valueOf(prefix) + ":" + indicator;
                }
                Class implClass = this.getImplClass();
                parentDescriptor.getInheritancePolicy().addClassIndicator(implClass, indicator);
                parentDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
                Class parentClass = parentType.getImplClass();
                this.getXmlDescriptor().getInheritancePolicy().setParentClass(parentClass);
                this.getXmlDescriptor().getInheritancePolicy().setParentDescriptor(parentType.getXmlDescriptor());
                parentType.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        if (this.isBaseType()) {
            int i3 = 0;
            while (i3 < this.subTypes.size()) {
                SDOType nextSubType = (SDOType)this.subTypes.get(i3);
                if (!nextSubType.isDataType() && nextSubType.isSubType()) {
                    nextSubType.setupInheritance(this);
                }
                ++i3;
            }
        }
    }

    public void preInitialize(String packageName, List namespaceResolvers) {
        String prefix;
        String instanceClassName = this.getInstanceClassName();
        if (instanceClassName == null) {
            if (packageName == null) {
                String uri = this.getURI();
                packageName = uri == null ? String.valueOf(SDOUtil.getDefaultPackageName()) + "." : String.valueOf(SDOUtil.getPackageNameFromURI(uri)) + ".";
            }
            String mangledClassName = SDOUtil.className(this.getName(), false, true, true);
            StringBuffer fullClassName = new StringBuffer(packageName);
            fullClassName.append(mangledClassName);
            this.setInstanceClassName(fullClassName.toString());
        }
        AbstractSessionLog.getLog().log(2, "sdo_type_generation_processing_type", new Object[]{Helper.getShortClassName(this.getClass()), this.getInstanceClassName()});
        this.initializeNamespaces(namespaceResolvers);
        this.getXmlDescriptor().setJavaClassName(this.getImplClassName());
        String schemaContext = this.getName();
        if (this.getXmlDescriptor().getNamespaceResolver() != null && (prefix = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null && !prefix.equals("")) {
            schemaContext = String.valueOf(prefix) + ":" + schemaContext;
        }
        String schemaContextWithSlash = "/" + schemaContext;
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        schemaRef.setSchemaContext(schemaContextWithSlash);
        schemaRef.setType(1);
        this.getXmlDescriptor().setSchemaReference(schemaRef);
    }

    public void postInitialize() {
        SDOProperty idProp;
        String idPropName = (String)this.get(SDOConstants.ID_PROPERTY);
        if (idPropName != null && (idProp = this.getProperty(idPropName)) != null) {
            String targetxpath = idProp.getQualifiedXPath(this.getURI(), true);
            this.getXmlDescriptor().addPrimaryKeyFieldName(targetxpath);
        }
        this.setFinalized(true);
        if (this.nonFinalizedReferencingProps != null) {
            int i2 = 0;
            while (i2 < this.nonFinalizedReferencingProps.size()) {
                SDOProperty nextProp = this.nonFinalizedReferencingProps.get(i2);
                String nextURI = (String)this.getNonFinalizedMappingURIs().get(i2);
                nextProp.buildMapping(nextURI, nextProp.getIndexInType());
                ++i2;
            }
            this.nonFinalizedReferencingProps = null;
            this.nonFinalizedMappingURIs = null;
        }
        if (!(this.isDataType() || this.isSubType() || this.isBaseType())) {
            String sdoPrefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            XMLDirectMapping sdoRefMapping = new XMLDirectMapping();
            sdoRefMapping.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            XMLField xmlField = new XMLField("@" + sdoPrefix + ":" + "ref");
            xmlField.getXPathFragment().setNamespaceURI("commonj.sdo");
            xmlField.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            sdoRefMapping.setField(xmlField);
            this.xmlDescriptor.addMapping(sdoRefMapping);
        }
        if (!this.isDataType()) {
            this.getImplClass();
            if (!this.isAbstract() && !this.isWrapperType()) {
                TypeInstantiationPolicy tip = new TypeInstantiationPolicy(this);
                this.xmlDescriptor.setInstantiationPolicy(tip);
            }
        }
    }

    public void setImplClassName(String implClassName) {
        this.javaImplClassName = implClassName;
        this.javaImplClass = null;
    }

    public String getImplClassName() {
        if (this.javaImplClassName == null && this.javaClassName != null) {
            this.javaImplClassName = String.valueOf(this.javaClassName) + "Impl";
        }
        return this.javaImplClassName;
    }

    public Class getImplClass() {
        if (this.javaImplClass == null && this.getImplClassName() != null) {
            try {
                SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                this.javaImplClass = loader.loadClass(this.getImplClassName(), this);
                this.xmlDescriptor.setJavaClass(this.javaImplClass);
            }
            catch (ClassNotFoundException e2) {
                throw SDOException.classNotFound(e2, this.getURI(), this.getName());
            }
            catch (SecurityException e3) {
                throw SDOException.classNotFound(e3, this.getURI(), this.getName());
            }
        }
        return this.javaImplClass;
    }

    public Object get(Property property) {
        if (this.propertyValues == null) {
            return null;
        }
        return this.propertyValues.get(property);
    }

    public List getInstanceProperties() {
        if (this.propertyValues == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.getPropertyValues().keySet());
    }

    public void setPropertyValues(Map properties) {
        this.propertyValues = properties;
    }

    public Map getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap();
        }
        return this.propertyValues;
    }

    public void setInstanceProperty(Property property, Object value) {
        if (property.equals(SDOConstants.JAVA_CLASS_PROPERTY) && value instanceof String) {
            this.setInstanceClassName((String)value);
        }
        this.getPropertyValues().put(property, value);
    }

    public SDOProperty getChangeSummaryProperty() {
        return this.changeSummaryProperty;
    }

    public SDOProperty[] getPropertiesArray() {
        if (this.allPropertiesArr == null || this.allPropertiesArr.length != this.getProperties().size()) {
            List l2 = this.getProperties();
            int s2 = l2 == null ? 0 : l2.size();
            this.allPropertiesArr = s2 > 0 ? l2.toArray(new SDOProperty[s2]) : new SDOProperty[0];
        }
        return this.allPropertiesArr;
    }

    public void setSubTypes(List subTypesList) {
        this.subTypes = subTypesList;
    }

    public List getSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList();
        }
        return this.subTypes;
    }

    public boolean isBaseType() {
        return this.subTypes != null && !this.subTypes.isEmpty();
    }

    private void updateIndices(int insertPosition, Property property) {
        int declaredSize = this.getDeclaredProperties().size();
        SDOProperty nextProp = null;
        int i2 = 0;
        while (i2 < declaredSize) {
            nextProp = (SDOProperty)this.getDeclaredProperties().get(i2);
            nextProp.incrementIndexInType();
            ++i2;
        }
        this.getProperties().add(insertPosition, property);
        if (this.isBaseType()) {
            int subTypesSize = this.getSubTypes().size();
            SDOType nextSubType = null;
            int i3 = 0;
            while (i3 < subTypesSize) {
                nextSubType = (SDOType)this.getSubTypes().get(i3);
                nextSubType.updateIndices(insertPosition, property);
                ++i3;
            }
        }
    }

    public void setXsdType(QName xsdTypeQName) {
        this.xsdType = xsdTypeQName;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public void setFinalized(boolean bFinalized) {
        this.finalized = bFinalized;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setNonFinalizedReferencingProps(List nonFinalizedReferencingProps) {
        this.nonFinalizedReferencingProps = nonFinalizedReferencingProps;
    }

    public List getNonFinalizedReferencingProps() {
        if (this.nonFinalizedReferencingProps == null) {
            this.nonFinalizedReferencingProps = new ArrayList<SDOProperty>();
        }
        return this.nonFinalizedReferencingProps;
    }

    public void setNonFinalizedMappingURIs(List nonFinalizedMappingURIsList) {
        this.nonFinalizedMappingURIs = nonFinalizedMappingURIsList;
    }

    public List getNonFinalizedMappingURIs() {
        if (this.nonFinalizedMappingURIs == null) {
            this.nonFinalizedMappingURIs = new ArrayList();
        }
        return this.nonFinalizedMappingURIs;
    }

    public void setAppInfoElements(List appInfoElementsList) {
        this.appInfoElements = appInfoElementsList;
    }

    public List getAppInfoElements() {
        return this.appInfoElements;
    }

    public Map getAppInfoMap() {
        if (this.appInfoMap == null) {
            this.appInfoMap = ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).buildAppInfoMap(this.appInfoElements);
        }
        return this.appInfoMap;
    }

    public Object getPseudoDefault() {
        return this.pseudoDefault;
    }

    public void setPseudoDefault(Object anObject) {
        this.pseudoDefault = anObject;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public boolean isChangeSummaryType() {
        return false;
    }

    public boolean isDataObjectType() {
        return false;
    }

    public boolean isTypeType() {
        return false;
    }

    public boolean isOpenSequencedType() {
        return false;
    }

    public boolean isWrapperType() {
        return false;
    }

    public static class TypeInstantiationPolicy
    extends InstantiationPolicy {
        SDOType sdoType;

        public TypeInstantiationPolicy(SDOType type) {
            this.sdoType = type;
        }

        @Override
        public Object buildNewInstance() throws DescriptorException {
            return this.sdoType.getHelperContext().getDataFactory().create((Type)this.sdoType);
        }
    }
}

