/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.slf4j;

import java.security.AccessController;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
extends AbstractSessionLog {
    public static final String ECLIPSELINK_NAMESPACE = "org.eclipse.persistence";
    private static final LoggerCall[] loggerCall = new LoggerCall[LogLevel.length];
    private static final Logger[] categoryLoggers = new Logger[LogCategory.length];
    private final LogLevel[] logLevels;

    static {
        int i2 = 0;
        while (i2 < LogCategory.length) {
            SLF4JLogger.categoryLoggers[i2] = null;
            ++i2;
        }
        LogTrace logTrace = new LogTrace();
        SLF4JLogger.loggerCall[LogLevel.FINEST.getId()] = logTrace;
        SLF4JLogger.loggerCall[LogLevel.ALL.getId()] = logTrace;
        LogDebug logDebug = new LogDebug();
        SLF4JLogger.loggerCall[LogLevel.FINE.getId()] = logDebug;
        SLF4JLogger.loggerCall[LogLevel.FINER.getId()] = logDebug;
        LogInfo logInfo = new LogInfo();
        SLF4JLogger.loggerCall[LogLevel.INFO.getId()] = logInfo;
        SLF4JLogger.loggerCall[LogLevel.CONFIG.getId()] = logInfo;
        SLF4JLogger.loggerCall[LogLevel.WARNING.getId()] = new LogWarn();
        SLF4JLogger.loggerCall[LogLevel.SEVERE.getId()] = new LogError();
        SLF4JLogger.loggerCall[LogLevel.OFF.getId()] = new LogNop();
    }

    private static Logger getLogger(LogCategory category) {
        Logger logger = categoryLoggers[category.getId()];
        if (logger != null) {
            return logger;
        }
        Logger logger2 = LoggerFactory.getLogger((String)category.getNameSpace());
        SLF4JLogger.categoryLoggers[category.getId()] = logger2;
        return logger2;
    }

    public SLF4JLogger() {
        int defaultLevel = LogLevel.toValue(this.level).getId();
        this.logLevels = new LogLevel[LogCategory.length];
        LogCategory[] logCategoryArray = LogCategory.values();
        int n2 = logCategoryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            LogCategory category = logCategoryArray[n3];
            byte i2 = category.getId();
            switch (category) {
                case ALL: {
                    this.logLevels[i2] = LogLevel.toValue(defaultLevel);
                    break;
                }
                default: {
                    String property = "eclipselink.logging.level." + category.getName();
                    String logLevelStr = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(property)) : System.getProperty(property);
                    this.logLevels[i2] = LogLevel.toValue(logLevelStr != null ? SLF4JLogger.translateStringToLoggingLevel(logLevelStr) : defaultLevel);
                }
            }
            ++n3;
        }
    }

    @Override
    public int getLevel() {
        return this.logLevels[LogCategory.ALL.getId()].getId();
    }

    @Override
    public int getLevel(String categoryName) {
        LogCategory category = LogCategory.toValue(categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        return this.logLevels[category.getId()].getId();
    }

    @Override
    public void setLevel(int level) {
        super.setLevel(level);
        this.logLevels[LogCategory.ALL.getId()] = LogLevel.toValue(level);
    }

    @Override
    public void setLevel(int level, String categoryName) {
        LogCategory category = LogCategory.toValue(categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        this.logLevels[category.getId()] = LogLevel.toValue(level);
    }

    @Override
    public boolean shouldLog(int level) {
        return this.logLevels[LogCategory.ALL.getId()].shouldLog((byte)level);
    }

    @Override
    public boolean shouldLog(int level, String categoryName) {
        LogCategory category = LogCategory.toValue(categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        return this.logLevels[category.getId()].shouldLog((byte)level);
    }

    @Override
    public void log(SessionLogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        LogCategory category = LogCategory.toValue(logEntry.getNameSpace());
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        byte levelId = (byte)logEntry.getLevel();
        if (this.logLevels[category.getId()].shouldLog(levelId)) {
            LogLevel level = LogLevel.toValue(levelId);
            Logger logger = SLF4JLogger.getLogger(category);
            if (logEntry.hasException()) {
                if (this.shouldLogExceptionStackTrace()) {
                    loggerCall[level.getId()].log(logger, this.formatMessage(logEntry), logEntry.getException());
                } else {
                    loggerCall[level.getId()].log(logger, logEntry.getException().toString());
                }
            } else {
                loggerCall[level.getId()].log(logger, this.formatMessage(logEntry));
            }
        }
    }

    private static final class LogDebug
    implements LoggerCall {
        private LogDebug() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
            logger.debug(msg, t2);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.debug(message);
        }
    }

    private static final class LogError
    implements LoggerCall {
        private LogError() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
            logger.error(msg, t2);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.error(message);
        }
    }

    private static final class LogInfo
    implements LoggerCall {
        private LogInfo() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
            logger.info(msg, t2);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.info(message);
        }
    }

    private static final class LogNop
    implements LoggerCall {
        private LogNop() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
        }

        @Override
        public void log(Logger logger, String message) {
        }
    }

    private static final class LogTrace
    implements LoggerCall {
        private LogTrace() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
            logger.trace(msg, t2);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.trace(message);
        }
    }

    private static final class LogWarn
    implements LoggerCall {
        private LogWarn() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t2) {
            logger.warn(msg, t2);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.warn(message);
        }
    }

    private static interface LoggerCall {
        public void log(Logger var1, String var2, Throwable var3);

        public void log(Logger var1, String var2);
    }
}

