/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.xmladapters;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.FetchGroup;

public class LinkAdapter
extends XmlAdapter<String, Object> {
    private String baseURI = null;
    protected PersistenceContext context;

    public LinkAdapter() {
    }

    public LinkAdapter(String baseURI, PersistenceContext context) {
        this.baseURI = baseURI;
        this.context = context;
    }

    public Object unmarshal(String v2) throws Exception {
        if (v2.equals("")) {
            return null;
        }
        String fixedString = v2.replace("\\/", "/");
        int lastSlash = fixedString.lastIndexOf(47);
        String entityType = fixedString.substring((String.valueOf(this.baseURI) + this.context.getName() + "/entity/").length(), lastSlash);
        String entityId = fixedString.substring(lastSlash + 1);
        ClassDescriptor descriptor = this.context.getDescriptor(entityType);
        Object id = IdHelper.buildId(this.context, descriptor.getAlias(), entityId);
        return this.constructObjectForId(entityType, id);
    }

    protected Object constructObjectForId(String entityType, Object id) {
        FetchGroup fetchGroup = new FetchGroup();
        ClassDescriptor descriptor = this.context.getDescriptor(entityType);
        List<DatabaseMapping> pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        for (DatabaseMapping mapping : pkMappings) {
            fetchGroup.addAttribute(mapping.getAttributeName());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.fetch-group", fetchGroup);
        properties.put("eclipselink.cache-usage", "CheckCacheOnly");
        Object entity = this.context.find(null, entityType, id, properties);
        if (entity == null) {
            return IdHelper.buildObjectShell(this.context, entityType, id);
        }
        return entity;
    }

    public String marshal(Object v2) throws Exception {
        if (v2 == null) {
            return null;
        }
        String href = null;
        String version = this.context.getVersion();
        href = version != null ? String.valueOf(this.baseURI) + version + "/" + this.context.getName() + "/entity/" + v2.getClass().getSimpleName() + "/" + IdHelper.stringifyId((DynamicEntityImpl)v2, ((DynamicEntityImpl)v2).getType().getName(), this.context) : String.valueOf(this.baseURI) + this.context.getName() + "/entity/" + v2.getClass().getSimpleName() + "/" + IdHelper.stringifyId((DynamicEntityImpl)v2, ((DynamicEntityImpl)v2).getType().getName(), this.context);
        return href;
    }
}

