/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.jpa.weaving.CollectionProxyClassWriter;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.util.CollectionProxy;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.list.PageableCollection;

public class CollectionWrapperBuilder {
    private final PersistenceContext context;

    public CollectionWrapperBuilder(PersistenceContext context) {
        this.context = context;
    }

    public void wrapCollections(Object object) {
        if (object instanceof PageableCollection) {
            for (Object o2 : ((PageableCollection)object).getItems()) {
                this.wrapCollectionsForEntity(o2);
            }
        } else {
            this.wrapCollectionsForEntity(object);
        }
    }

    private void wrapCollectionsForEntity(Object entity) {
        if (!PersistenceWeavedRest.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        Field[] fieldArray = entity.getClass().getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (Collection.class.isAssignableFrom(field.getType())) {
                String id = IdHelper.stringifyId(entity, entity.getClass().getSimpleName(), this.context);
                ArrayList<LinkV2> links = new ArrayList<LinkV2>(2);
                String href = HrefHelper.buildEntityFieldHref(this.context, entity.getClass().getSimpleName(), id, field.getName());
                links.add(new LinkV2("self", href));
                links.add(new LinkV2("canonical", href));
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                try {
                    if (!field.getName().startsWith("_") && field.get(entity) != null) {
                        CollectionProxy proxy = this.getRestCollectionProxy((Collection)field.get(entity), entity.getClass().getName(), field.getName());
                        proxy.setLinks(links);
                        field.set(entity, field.getType().cast(proxy));
                    }
                }
                catch (IllegalAccessException e2) {
                    throw JPARSException.exceptionOccurred(e2);
                }
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
            ++n3;
        }
    }

    private CollectionProxy getRestCollectionProxy(Collection toProxy, String entityName, String fieldname) {
        try {
            DynamicClassLoader classLoader = (DynamicClassLoader)this.context.getServerSession().getDatasourcePlatform().getConversionManager().getLoader();
            CollectionProxyClassWriter writer = new CollectionProxyClassWriter(toProxy.getClass().getName(), entityName, fieldname);
            String proxyClassName = writer.getClassName();
            if (classLoader.getClassWriter(proxyClassName) == null) {
                classLoader.addClass(proxyClassName, writer);
            }
            Class<?> referenceAdaptorClass = Class.forName(proxyClassName, true, classLoader);
            Class[] argTypes = new Class[]{Collection.class};
            Constructor<?> referenceAdaptorConstructor = referenceAdaptorClass.getDeclaredConstructor(argTypes);
            Object[] args = new Object[]{toProxy};
            return (CollectionProxy)referenceAdaptorConstructor.newInstance(args);
        }
        catch (Exception e2) {
            throw JPARSException.exceptionOccurred(e2);
        }
    }
}

