/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.core.selflinks;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilderImpl;
import org.eclipse.persistence.jpa.rs.features.ItemLinksBuilder;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryResult;

public class SelfLinksResponseBuilder
extends FeatureResponseBuilderImpl {
    @Override
    public Object buildReadAllQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object> items, UriInfo uriInfo) {
        return this.collectionResponse(context, items, uriInfo);
    }

    @Override
    public Object buildReportQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> items, UriInfo uriInfo) {
        ReportQueryResultCollection response = new ReportQueryResultCollection();
        for (Object[] result : results) {
            ReportQueryResultListItem queryResultListItem = new ReportQueryResultListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(items, result);
            this.generateLinksInElementsList(context, jaxbFields);
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        response.addLink(new LinkV2("self", uriInfo.getRequestUri().toString()));
        return response;
    }

    @Override
    public Object buildSingleResultQueryResponse(PersistenceContext context, Map<String, Object> queryParams, Object result, List<ReportItem> items, UriInfo uriInfo) {
        SingleResultQueryResult response = new SingleResultQueryResult();
        List<JAXBElement> fields = this.createShellJAXBElementList(items, result);
        this.generateLinksInElementsList(context, fields);
        response.setFields(fields);
        response.addLink(new LinkV2("self", uriInfo.getRequestUri().toString()));
        return response;
    }

    @Override
    public Object buildAttributeResponse(PersistenceContext context, Map<String, Object> queryParams, String attribute, Object item, UriInfo uriInfo) {
        if (item instanceof List) {
            return this.collectionResponse(context, (List)item, uriInfo);
        }
        return item;
    }

    @Override
    public Object buildSingleEntityResponse(PersistenceContext context, Map<String, Object> queryParams, Object result, UriInfo uriInfo) {
        if (result instanceof PersistenceWeavedRest) {
            PersistenceWeavedRest entity = (PersistenceWeavedRest)result;
            ClassDescriptor classDescriptor = context.getServerSession().getProject().getDescriptor(result.getClass());
            String entityClassName = classDescriptor.getAlias();
            String entityId = IdHelper.stringifyId(entity, entityClassName, context);
            ItemLinksBuilder itemLinksBuilder = new ItemLinksBuilder().addSelf(uriInfo.getRequestUri().toString()).addCanonical(HrefHelper.buildEntityHref(context, entityClassName, entityId));
            this.generateLinksForRelationships(context, entity);
            entity._persistence_setLinks(itemLinksBuilder.build());
            return entity;
        }
        return result;
    }

    private Object collectionResponse(PersistenceContext context, List<Object> results, UriInfo uriInfo) {
        if (results != null && !results.isEmpty()) {
            ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
            for (Object item : results) {
                if (item instanceof PersistenceWeavedRest) {
                    PersistenceWeavedRest entity = (PersistenceWeavedRest)item;
                    ClassDescriptor classDescriptor = context.getServerSession().getProject().getDescriptor(item.getClass());
                    String entityClassName = classDescriptor.getAlias();
                    String entityId = IdHelper.stringifyId(entity, entityClassName, context);
                    String href = HrefHelper.buildEntityHref(context, entityClassName, entityId);
                    ItemLinksBuilder itemLinksBuilder = new ItemLinksBuilder().addCanonical(href);
                    entity._persistence_setLinks(itemLinksBuilder.build());
                    this.generateLinksForRelationships(context, entity);
                    response.addItem(entity);
                    continue;
                }
                response.addItem(item);
            }
            response.addLink(new LinkV2("self", uriInfo.getRequestUri().toString()));
            return response;
        }
        return results;
    }

    private void generateLinksInElementsList(PersistenceContext context, List<JAXBElement> fields) {
        for (JAXBElement field : fields) {
            if (!(field.getValue() instanceof PersistenceWeavedRest)) continue;
            PersistenceWeavedRest entity = (PersistenceWeavedRest)field.getValue();
            ClassDescriptor classDescriptor = context.getServerSession().getProject().getDescriptor(entity.getClass());
            String entityClassName = classDescriptor.getAlias();
            String entityId = IdHelper.stringifyId(entity, entityClassName, context);
            if (classDescriptor.isAggregateDescriptor()) continue;
            String href = HrefHelper.buildEntityHref(context, entityClassName, entityId);
            ItemLinksBuilder itemLinksBuilder = new ItemLinksBuilder().addSelf(href).addCanonical(href);
            entity._persistence_setLinks(itemLinksBuilder.build());
        }
    }

    private void generateLinksForRelationships(PersistenceContext context, PersistenceWeavedRest entity) {
        ClassDescriptor classDescriptor = context.getServerSession().getProject().getDescriptor(entity.getClass());
        String entityClassName = classDescriptor.getAlias();
        String entityId = IdHelper.stringifyId(entity, entityClassName, context);
        Field[] fieldArray = entity.getClass().getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PersistenceWeavedRest obj;
            Field field = fieldArray[n3];
            if (PersistenceWeavedRest.class.isAssignableFrom(field.getType()) && (obj = (PersistenceWeavedRest)this.callGetterForProperty(entity, field.getName())) != null) {
                String fieldClassName = context.getJAXBDescriptorForClass(field.getType()).getAlias();
                String fieldId = IdHelper.stringifyId(obj, fieldClassName, context);
                ItemLinks links = new ItemLinksBuilder().addSelf(HrefHelper.buildEntityFieldHref(context, entityClassName, entityId, field.getName())).addCanonical(HrefHelper.buildEntityHref(context, fieldClassName, fieldId)).build();
                obj._persistence_setLinks(links);
            }
            ++n3;
        }
    }

    private Object callGetterForProperty(Object bean, String propertyName) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptorArray = props = info.getPropertyDescriptors();
            int n2 = props.length;
            int n3 = 0;
            while (n3 < n2) {
                PropertyDescriptor pd = propertyDescriptorArray[n3];
                if (propertyName.equals(pd.getName())) {
                    return pd.getReadMethod().invoke(bean, new Object[0]);
                }
                ++n3;
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e2) {
            throw JPARSException.exceptionOccurred(e2);
        }
        return null;
    }
}

