/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

public class CoalesceExpressionStateObject
extends AbstractEncapsulatedExpressionStateObject
implements ListHolderStateObject<StateObject> {
    private List<StateObject> items;
    public static final String STATE_OBJECTS_LIST = "stateObjects";

    public CoalesceExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public CoalesceExpressionStateObject(StateObject parent, List<StateObject> items) {
        super(parent);
        this.items = new ArrayList<StateObject>(this.parent(items));
    }

    public CoalesceExpressionStateObject(StateObject parent, StateObject ... items) {
        super(parent);
        this.items = new ArrayList<StateObject>();
        Collections.addAll(this.items, this.parent(items));
    }

    public CoalesceExpressionStateObject(StateObject parent, String ... items) {
        super(parent);
        this.items = new ArrayList<StateObject>();
        this.parseItemInternal(items);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.addAll(this.items);
    }

    @Override
    public <S extends StateObject> S addItem(S item) {
        this.getChangeSupport().addItem(this, this.items, STATE_OBJECTS_LIST, this.parent(item));
        return item;
    }

    @Override
    public void addItems(List<? extends StateObject> items) {
        this.getChangeSupport().addItems(this, this.items, STATE_OBJECTS_LIST, this.parent(items));
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    protected boolean areChildrenEquivalent(CoalesceExpressionStateObject stateObject) {
        int size = this.itemsSize();
        if (size != stateObject.itemsSize()) {
            return false;
        }
        int index = size;
        while (--index >= 0) {
            StateObject child2;
            StateObject child1 = this.getItem(index);
            if (child1.isEquivalent(child2 = stateObject.getItem(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canMoveDown(StateObject item) {
        return this.getChangeSupport().canMoveDown(this.items, item);
    }

    @Override
    public boolean canMoveUp(StateObject item) {
        return this.getChangeSupport().canMoveUp(this.items, item);
    }

    @Override
    public CoalesceExpression getExpression() {
        return (CoalesceExpression)super.getExpression();
    }

    @Override
    public String getIdentifier() {
        return "COALESCE";
    }

    @Override
    public StateObject getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.items = new ArrayList<StateObject>();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return super.isEquivalent(stateObject) && this.areChildrenEquivalent((CoalesceExpressionStateObject)stateObject);
    }

    @Override
    public ListIterable<StateObject> items() {
        return new SnapshotCloneListIterable<StateObject>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }

    @Override
    public StateObject moveDown(StateObject item) {
        this.getChangeSupport().moveDown(this, this.items, STATE_OBJECTS_LIST, item);
        return item;
    }

    @Override
    public StateObject moveUp(StateObject item) {
        this.getChangeSupport().moveUp(this, this.items, STATE_OBJECTS_LIST, item);
        return item;
    }

    public void parseItem(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "scalar_expression");
        this.addItem((StateObject)stateObject);
    }

    protected void parseItemInternal(String ... items) {
        String[] stringArray = items;
        int n2 = items.length;
        int n3 = 0;
        while (n3 < n2) {
            String item = stringArray[n3];
            Object stateObject = this.buildStateObject(item, "scalar_expression");
            this.items.add((StateObject)this.parent(stateObject));
            ++n3;
        }
    }

    public void parseItems(ListIterator<String> items) {
        while (items.hasNext()) {
            Object stateObject = this.buildStateObject(items.next(), "scalar_expression");
            this.addItem((StateObject)this.parent(stateObject));
        }
    }

    public void parseItems(String ... items) {
        String[] stringArray = items;
        int n2 = items.length;
        int n3 = 0;
        while (n3 < n2) {
            String item = stringArray[n3];
            Object stateObject = this.buildStateObject(item, "scalar_expression");
            this.addItem((StateObject)this.parent(stateObject));
            ++n3;
        }
    }

    @Override
    public void removeItem(StateObject item) {
        this.getChangeSupport().removeItem(this, this.items, STATE_OBJECTS_LIST, item);
    }

    @Override
    public void removeItems(Collection<StateObject> items) {
        this.getChangeSupport().removeItems(this, this.items, STATE_OBJECTS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public void setExpression(CoalesceExpression expression) {
        super.setExpression(expression);
    }

    @Override
    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        this.toStringItems(writer, this.items, true);
    }
}

