/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaMethodImpl
implements JavaMethod {
    protected Method jMethod;
    private JavaModelImpl javaModelImpl;
    protected boolean isMetadataComplete;

    public JavaMethodImpl(Method javaMethod, JavaModelImpl javaModelImpl) {
        this(javaMethod, javaModelImpl, false);
    }

    public JavaMethodImpl(Method javaMethod, JavaModelImpl javaModelImpl, Boolean isMetadataComplete) {
        this.jMethod = javaMethod;
        this.javaModelImpl = javaModelImpl;
        if (isMetadataComplete != null) {
            this.isMetadataComplete = isMetadataComplete;
        }
    }

    public Collection getActualTypeArguments() {
        Type[] params;
        ArrayList<JavaClass> argCollection = new ArrayList<JavaClass>();
        Type[] typeArray = params = this.jMethod.getGenericParameterTypes();
        int n2 = params.length;
        int n3 = 0;
        while (n3 < n2) {
            Type type = typeArray[n3];
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                argCollection.add(new JavaClassImpl(pType, pType.getClass(), this.javaModelImpl));
            } else if (type instanceof Class) {
                argCollection.add(this.javaModelImpl.getClass((Class)type));
            }
            ++n3;
        }
        return argCollection;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass arg0) {
        if (arg0 != null && !this.isMetadataComplete) {
            Class annotationClass = ((JavaClassImpl)arg0).getJavaClass();
            Annotation anno = this.javaModelImpl.getAnnotationHelper().getAnnotation(this.getAnnotatedElement(), annotationClass);
            if (anno != null) {
                return new JavaAnnotationImpl(anno);
            }
        }
        return null;
    }

    @Override
    public Collection getAnnotations() {
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        if (!this.isMetadataComplete) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = this.javaModelImpl.getAnnotationHelper().getAnnotations(this.getAnnotatedElement());
            int n2 = annotations.length;
            int n3 = 0;
            while (n3 < n2) {
                Annotation annotation = annotationArray[n3];
                annotationCollection.add(new JavaAnnotationImpl(annotation));
                ++n3;
            }
        }
        return annotationCollection;
    }

    @Override
    public String getName() {
        return this.jMethod.getName();
    }

    @Override
    public JavaClass[] getParameterTypes() {
        Class[] params = PrivilegedAccessHelper.getMethodParameterTypes(this.jMethod);
        JavaClass[] paramArray = new JavaClass[params.length];
        int i2 = 0;
        while (i2 < params.length) {
            paramArray[i2] = this.javaModelImpl.getClass(params[i2]);
            ++i2;
        }
        return paramArray;
    }

    public JavaClass getResolvedType() {
        Class returnType = PrivilegedAccessHelper.getMethodReturnType(this.jMethod);
        return this.javaModelImpl.getClass(returnType);
    }

    @Override
    public JavaClass getReturnType() {
        Type type = this.jMethod.getGenericReturnType();
        Class returnType = PrivilegedAccessHelper.getMethodReturnType(this.jMethod);
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new JavaClassImpl(pType, returnType, this.javaModelImpl);
        }
        return this.javaModelImpl.getClass(returnType);
    }

    public boolean hasActualTypeArguments() {
        Type[] params;
        Type[] typeArray = params = this.jMethod.getGenericParameterTypes();
        int n2 = params.length;
        int n3 = 0;
        while (n3 < n2) {
            Type type = typeArray[n3];
            if (type instanceof ParameterizedType) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public int getModifiers() {
        return this.jMethod.getModifiers();
    }

    @Override
    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jMethod.getDeclaringClass());
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.jMethod;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.jMethod.isSynthetic();
    }

    @Override
    public boolean isBridge() {
        return this.jMethod.isBridge();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    @Override
    public Collection getDeclaredAnnotations() {
        return null;
    }
}

