/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.internal.helper.XMLHelper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;
import org.eclipse.persistence.jaxb.ReflectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationXMLReader
implements Callable<Map<Class<?>, Boolean>> {
    public static final String DEFAULT_PACKAGE_QNAME = "default-package";
    public static final String BEAN_QNAME = "bean";
    public static final String CONSTRAINT_MAPPING_QNAME = "constraint-mapping";
    public static final String CLASS_QNAME = "class";
    public static final String PACKAGE_SEPARATOR = ".";
    private static final String VALIDATION_XML = "META-INF/validation.xml";
    private static final Logger LOGGER = Logger.getLogger(ValidationXMLReader.class.getName());
    private final List<String> constraintsFiles = new ArrayList<String>(2);
    private Map<Class<?>, Boolean> constraintsOnClasses = new HashMap();
    private SAXParser saxParser;
    private final DefaultHandler validationHandler = new DefaultHandler(){
        private boolean constraintsFileElement = false;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ValidationXMLReader.CONSTRAINT_MAPPING_QNAME.equalsIgnoreCase(qName)) {
                this.constraintsFileElement = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.constraintsFileElement) {
                ValidationXMLReader.this.constraintsFiles.add(new String(ch, start, length));
                this.constraintsFileElement = false;
            }
        }
    };

    @Override
    public Map<Class<?>, Boolean> call() throws Exception {
        this.parseValidationXML(VALIDATION_XML, this.validationHandler);
        if (!this.constraintsFiles.isEmpty()) {
            this.parseConstraintFiles();
        }
        return this.constraintsOnClasses;
    }

    public static boolean isValidationXmlPresent() {
        try {
            return ValidationXMLReader.getThreadContextClassLoader().getResource(VALIDATION_XML) != null;
        }
        catch (PrivilegedActionException ignored) {
            LOGGER.log(Level.WARNING, "Loading of META-INF/validation.xml file failed. ", ignored);
            return false;
        }
    }

    private void parseConstraintFiles() {
        for (String file : this.constraintsFiles) {
            final class ConstrainedClassesDetector
            extends DefaultHandler {
                private boolean defaultPackageElement = false;
                private String defaultPackage = "";

                ConstrainedClassesDetector() {
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (ValidationXMLReader.DEFAULT_PACKAGE_QNAME.equalsIgnoreCase(qName)) {
                        this.defaultPackageElement = true;
                    } else if (ValidationXMLReader.BEAN_QNAME.equalsIgnoreCase(qName)) {
                        String className = String.valueOf(this.defaultPackage) + ValidationXMLReader.PACKAGE_SEPARATOR + attributes.getValue(ValidationXMLReader.CLASS_QNAME);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            String msg = "Detected external constraints on class " + className;
                            LOGGER.info(msg);
                        }
                        try {
                            Class<?> clazz = ReflectionUtils.forName(className);
                            ValidationXMLReader.this.constraintsOnClasses.put(clazz, Boolean.TRUE);
                        }
                        catch (ClassNotFoundException e2) {
                            String errMsg = "Loading found class failed. Exception: " + e2.getMessage();
                            LOGGER.warning(errMsg);
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.defaultPackageElement) {
                        this.defaultPackage = new String(ch, start, length);
                        this.defaultPackageElement = false;
                    }
                }
            }
            this.parseValidationXML(file, new ConstrainedClassesDetector());
        }
    }

    private SAXParser getSaxParser() {
        if (this.saxParser == null) {
            try {
                SAXParserFactory factory = XMLHelper.createParserFactory(false);
                this.saxParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException | SAXException e2) {
                String msg = "ValidationXMLReader initialization failed. Exception: " + e2.getMessage();
                LOGGER.severe(msg);
                throw new BeanValidationException(msg, e2);
            }
        }
        return this.saxParser;
    }

    private void parseValidationXML(String constraintsFilePath, DefaultHandler handler) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream validationXml = ValidationXMLReader.getThreadContextClassLoader().getResourceAsStream(constraintsFilePath);){
                if (validationXml != null) {
                    this.getSaxParser().parse(validationXml, handler);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PrivilegedActionException | SAXException ignored) {
            LOGGER.log(Level.WARNING, "Parsing of validation.xml failed.", ignored);
        }
    }

    private static ClassLoader getThreadContextClassLoader() throws PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

