/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Class<?> forName(String clazz) throws ClassNotFoundException {
        try {
            return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(ForNameIODH.PREDICATE_EXCEPTION_ACTION.with(clazz)) : ReflectionUtils.forNameInternal(clazz);
        }
        catch (PrivilegedActionException e2) {
            throw (ClassNotFoundException)e2.getException();
        }
    }

    static Field[] getDeclaredFields(Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Field[])AccessController.doPrivileged(DeclaredFieldsIODH.PREDICATE_ACTION.with(clazz)) : ReflectionUtils.getDeclaredFieldsInternal(clazz);
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Constructor[])AccessController.doPrivileged(DeclaredConstructorsIODH.PREDICATE_ACTION.with(clazz)) : ReflectionUtils.getDeclaredConstructorsInternal(clazz);
    }

    static Method[] getDeclaredMethods(Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Method[])AccessController.doPrivileged(DeclaredMethodsIODH.PREDICATE_ACTION.with(clazz)) : ReflectionUtils.getDeclaredMethodsInternal(clazz);
    }

    static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Method)AccessController.doPrivileged(DeclaredMethodIODH.PREDICATE_EXCEPTION_ACTION.with(clazz).with(name).with(parameterTypes)) : ReflectionUtils.getDeclaredMethodInternal(clazz, name, parameterTypes);
        }
        catch (PrivilegedActionException e2) {
            throw (NoSuchMethodException)e2.getException();
        }
    }

    private static Class<?> forNameInternal(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz);
    }

    private static Field[] getDeclaredFieldsInternal(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    private static Method[] getDeclaredMethodsInternal(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    private static Constructor<?>[] getDeclaredConstructorsInternal(Class<?> clazz) {
        return clazz.getDeclaredConstructors();
    }

    private static Method getDeclaredMethodInternal(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(name, parameterTypes);
    }

    private static final class DeclaredConstructorsIODH {
        private static final Predicate<Constructor<?>[]> PREDICATE_ACTION = new Predicate<Constructor<?>[]>(){
            private Class<?> clazz;

            @Override
            public Predicate<Constructor<?>[]> with(Class<?> with) {
                this.clazz = with;
                return this;
            }

            @Override
            public Constructor<?>[] run() {
                return ReflectionUtils.getDeclaredConstructorsInternal(this.clazz);
            }
        };

        private DeclaredConstructorsIODH() {
        }
    }

    private static final class DeclaredFieldsIODH {
        private static final Predicate<Field[]> PREDICATE_ACTION = new Predicate<Field[]>(){
            private Class<?> clazz;

            @Override
            public Field[] run() {
                return ReflectionUtils.getDeclaredFieldsInternal(this.clazz);
            }

            @Override
            public Predicate<Field[]> with(Class<?> clazz) {
                this.clazz = clazz;
                return this;
            }
        };

        private DeclaredFieldsIODH() {
        }
    }

    private static final class DeclaredMethodIODH {
        private static final PredicateWithException<Method> PREDICATE_EXCEPTION_ACTION = new PredicateWithException<Method>(){
            private Class<?> clazz;
            private String name;
            private Class<?>[] parameterTypes;

            @Override
            public PredicateWithException<Method> with(Class<?> with) {
                this.clazz = with;
                return this;
            }

            @Override
            public PredicateWithException<Method> with(String with) {
                this.name = with;
                return this;
            }

            @Override
            public PredicateWithException<Method> with(Class<?>[] with) {
                this.parameterTypes = with;
                return this;
            }

            @Override
            public Method run() throws NoSuchMethodException {
                return ReflectionUtils.getDeclaredMethodInternal(this.clazz, this.name, this.parameterTypes);
            }
        };

        private DeclaredMethodIODH() {
        }
    }

    private static final class DeclaredMethodsIODH {
        private static final Predicate<Method[]> PREDICATE_ACTION = new Predicate<Method[]>(){
            private Class<?> clazz;

            @Override
            public Predicate<Method[]> with(Class<?> with) {
                this.clazz = with;
                return this;
            }

            @Override
            public Method[] run() {
                return ReflectionUtils.getDeclaredMethodsInternal(this.clazz);
            }
        };

        private DeclaredMethodsIODH() {
        }
    }

    private static final class ForNameIODH {
        private static final PredicateWithException<Class<?>> PREDICATE_EXCEPTION_ACTION = new PredicateWithException<Class<?>>(){
            private String clazz;

            @Override
            public PredicateWithException<Class<?>> with(String with) {
                this.clazz = with;
                return this;
            }

            @Override
            public PredicateWithException<Class<?>> with(Class<?> with) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PredicateWithException<Class<?>> with(Class<?>[] with) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Class<?> run() throws NoSuchMethodException, ClassNotFoundException {
                return ReflectionUtils.forNameInternal(this.clazz);
            }
        };

        private ForNameIODH() {
        }
    }

    private static interface Predicate<T>
    extends PrivilegedAction<T> {
        public Predicate<T> with(Class<?> var1);
    }

    private static interface PredicateWithException<T>
    extends PrivilegedExceptionAction<T> {
        public PredicateWithException<T> with(Class<?> var1);

        public PredicateWithException<T> with(String var1);

        public PredicateWithException<T> with(Class<?>[] var1);
    }
}

