/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.eclipse.persistence.internal.cache.AdvancedProcessor;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.jaxb.ReflectionUtils;
import org.eclipse.persistence.jaxb.ValidationXMLReader;
import org.eclipse.persistence.logging.AbstractSessionLog;

public final class BeanValidationHelper {
    private Future<Map<Class<?>, Boolean>> future;
    private final AdvancedProcessor memoizer = new AdvancedProcessor();
    private final ConstraintsDetectorService<Class<?>, Boolean> cds = new ConstraintsDetectorService();
    private final Set<Class<? extends Annotation>> knownConstraints = new HashSet<Class<? extends Annotation>>();
    private Map<Class<?>, Boolean> constraintsOnClasses = null;

    public BeanValidationHelper() {
        this.knownConstraints.add(Valid.class);
        this.knownConstraints.add(Max.class);
        this.knownConstraints.add(Min.class);
        this.knownConstraints.add(DecimalMax.class);
        this.knownConstraints.add(DecimalMin.class);
        this.knownConstraints.add(Digits.class);
        this.knownConstraints.add(NotNull.class);
        this.knownConstraints.add(Pattern.class);
        this.knownConstraints.add(Size.class);
        this.knownConstraints.add(AssertTrue.class);
        this.knownConstraints.add(AssertFalse.class);
        this.knownConstraints.add(javax.validation.constraints.Future.class);
        this.knownConstraints.add(Past.class);
        this.knownConstraints.add(Max.List.class);
        this.knownConstraints.add(Min.List.class);
        this.knownConstraints.add(DecimalMax.List.class);
        this.knownConstraints.add(DecimalMin.List.class);
        this.knownConstraints.add(Digits.List.class);
        this.knownConstraints.add(NotNull.List.class);
        this.knownConstraints.add(Pattern.List.class);
        this.knownConstraints.add(Size.List.class);
        this.knownConstraints.add(AssertTrue.List.class);
        this.knownConstraints.add(AssertFalse.List.class);
        this.knownConstraints.add(Future.List.class);
        this.knownConstraints.add(Past.List.class);
        if (ValidationXMLReader.isValidationXmlPresent()) {
            this.parseValidationXmlAsync();
        } else {
            this.constraintsOnClasses = new HashMap();
        }
    }

    boolean isConstrained(Class<?> clazz) {
        return this.memoizer.compute(this.cds, clazz);
    }

    public Map<Class<?>, Boolean> getConstraintsMap() {
        if (this.constraintsOnClasses == null) {
            if (this.future == null) {
                this.constraintsOnClasses = this.parseValidationXml();
            } else {
                try {
                    this.constraintsOnClasses = this.future.get();
                }
                catch (InterruptedException | ExecutionException e2) {
                    AbstractSessionLog.getLog().log(6, "moxy", "Error parsing validation.xml the async way", new Object[0], false);
                    AbstractSessionLog.getLog().logThrowable(6, "moxy", e2);
                    this.constraintsOnClasses = this.parseValidationXml();
                }
            }
        }
        return this.constraintsOnClasses;
    }

    private void parseValidationXmlAsync() {
        Executor executor = null;
        try {
            try {
                executor = this.createExecutor();
                this.future = executor.executorService.submit(new ValidationXMLReader());
            }
            catch (Throwable e2) {
                AbstractSessionLog.getLog().log(6, "moxy", "Error creating/submitting async validation.xml parsing task.", new Object[0], false);
                AbstractSessionLog.getLog().logThrowable(6, "moxy", e2);
                this.future = null;
                if (executor != null && executor.shutdownNeeded) {
                    executor.executorService.shutdown();
                }
            }
        }
        finally {
            if (executor != null && executor.shutdownNeeded) {
                executor.executorService.shutdown();
            }
        }
    }

    private Map<Class<?>, Boolean> parseValidationXml() {
        HashMap result;
        ValidationXMLReader reader = new ValidationXMLReader();
        try {
            result = reader.call();
        }
        catch (Exception e2) {
            AbstractSessionLog.getLog().log(6, "moxy", "Error parsing validation.xml synchronously", new Object[0], false);
            AbstractSessionLog.getLog().logThrowable(6, "moxy", e2);
            result = new HashMap();
        }
        return result;
    }

    private Executor createExecutor() {
        try {
            InitialContext jndiCtx = new InitialContext();
            return new Executor((ExecutorService)jndiCtx.lookup("java:comp/env/concurrent/ThreadPool"), false);
        }
        catch (NamingException namingException) {
            return new Executor(Executors.newFixedThreadPool(1), true);
        }
    }

    public class ConstraintsDetectorService<A, V>
    implements ComputableTask<A, V> {
        @Override
        public V compute(A arg) throws InterruptedException {
            Boolean b2 = this.isConstrained0((Class)arg);
            return (V)b2;
        }

        private Boolean isConstrained0(Class<?> clazz) {
            Boolean constrained = BeanValidationHelper.this.getConstraintsMap().get(clazz);
            if (constrained == null) {
                constrained = this.detectConstraints(clazz);
                BeanValidationHelper.this.constraintsOnClasses.put(clazz, constrained);
            }
            return constrained;
        }

        private Boolean detectConstraints(Class<?> clazz) {
            if (this.detectAncestorConstraints(clazz)) {
                return true;
            }
            AccessibleObject[] accessibleObjectArray = ReflectionUtils.getDeclaredFields(clazz);
            int n2 = accessibleObjectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Field f2 = accessibleObjectArray[n3];
                if ((f2.getModifiers() & 8) == 0 && this.detectFirstClassConstraints(f2)) {
                    return true;
                }
                ++n3;
            }
            accessibleObjectArray = ReflectionUtils.getDeclaredMethods(clazz);
            n2 = accessibleObjectArray.length;
            n3 = 0;
            while (n3 < n2) {
                AccessibleObject m2 = accessibleObjectArray[n3];
                if ((((Method)m2).getModifiers() & 8) == 0 && (this.detectFirstClassConstraints(m2) || this.detectParameterConstraints((Executable)m2))) {
                    return true;
                }
                ++n3;
            }
            accessibleObjectArray = ReflectionUtils.getDeclaredConstructors(clazz);
            n2 = accessibleObjectArray.length;
            n3 = 0;
            while (n3 < n2) {
                AccessibleObject c2 = accessibleObjectArray[n3];
                if (!clazz.isEnum() && (this.detectFirstClassConstraints(c2) || this.detectParameterConstraints((Executable)c2))) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        private boolean detectAncestorConstraints(Class<?> clazz) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return false;
            }
            return (Boolean)BeanValidationHelper.this.memoizer.compute(BeanValidationHelper.this.cds, superClass);
        }

        private boolean detectFirstClassConstraints(AccessibleObject accessibleObject) {
            Annotation[] annotationArray = accessibleObject.getDeclaredAnnotations();
            int n2 = annotationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Annotation a2 = annotationArray[n3];
                Class<? extends Annotation> annType = a2.annotationType();
                if (BeanValidationHelper.this.knownConstraints.contains(annType)) {
                    return true;
                }
                Annotation[] annotationArray2 = annType.getAnnotations();
                int n4 = annotationArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Annotation annOnAnnType = annotationArray2[n5];
                    Class<? extends Annotation> annTypeOnAnnType = annOnAnnType.annotationType();
                    if (Constraint.class == annTypeOnAnnType) {
                        BeanValidationHelper.this.knownConstraints.add(annType);
                        return true;
                    }
                    ++n5;
                }
                ++n3;
            }
            return false;
        }

        private boolean detectParameterConstraints(Executable c2) {
            Annotation[][] annotationArray = c2.getParameterAnnotations();
            int n2 = annotationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Annotation[] aa2;
                Annotation[] annotationArray2 = aa2 = annotationArray[n3];
                int n4 = aa2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Annotation a2 = annotationArray2[n5];
                    Class<? extends Annotation> annType = a2.annotationType();
                    if (BeanValidationHelper.this.knownConstraints.contains(annType)) {
                        return true;
                    }
                    Annotation[] annotationArray3 = annType.getAnnotations();
                    int n6 = annotationArray3.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Annotation annOnAnnType = annotationArray3[n7];
                        Class<? extends Annotation> annTypeOnAnnType = annOnAnnType.annotationType();
                        if (Constraint.class == annTypeOnAnnType) {
                            BeanValidationHelper.this.knownConstraints.add(annType);
                            return true;
                        }
                        ++n7;
                    }
                    ++n5;
                }
                ++n3;
            }
            return false;
        }
    }

    private static class Executor {
        ExecutorService executorService;
        boolean shutdownNeeded;

        Executor(ExecutorService executorService, boolean shutdownNeeded) {
            this.executorService = executorService;
            this.shutdownNeeded = shutdownNeeded;
        }
    }
}

