/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderDependencyNode;

public class CommitOrderCalculator {
    protected int currentTime = 0;
    protected Vector nodes = new Vector(1);
    protected Vector orderedDescriptors;
    protected AbstractSession session;

    public CommitOrderCalculator(AbstractSession session) {
        this.session = session;
    }

    protected void addNode(ClassDescriptor d2) {
        this.nodes.addElement(new CommitOrderDependencyNode(this, d2, this.session));
    }

    public void addNodes(Vector descriptors) {
        Enumeration descriptorsEnum = descriptors.elements();
        while (descriptorsEnum.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptorsEnum.nextElement();
            this.addNode(descriptor);
        }
    }

    public void calculateMappingDependencies() {
        Enumeration e2 = this.nodes.elements();
        while (e2.hasMoreElements()) {
            CommitOrderDependencyNode node = (CommitOrderDependencyNode)e2.nextElement();
            node.recordMappingDependencies();
        }
    }

    public void calculateSpecifiedDependencies() {
        Enumeration e2 = this.nodes.elements();
        while (e2.hasMoreElements()) {
            CommitOrderDependencyNode node = (CommitOrderDependencyNode)e2.nextElement();
            node.recordSpecifiedDependencies();
        }
    }

    public void depthFirstSearch() {
        CommitOrderDependencyNode node;
        Enumeration e2 = this.getNodes().elements();
        while (e2.hasMoreElements()) {
            node = (CommitOrderDependencyNode)e2.nextElement();
            node.markNotVisited();
            node.setPredecessor(null);
        }
        this.currentTime = 0;
        e2 = this.getNodes().elements();
        while (e2.hasMoreElements()) {
            node = (CommitOrderDependencyNode)e2.nextElement();
            if (!node.hasNotBeenVisited()) continue;
            node.visit();
        }
    }

    private static int doCompare(Object o1, Object o2) {
        int second;
        int first = ((CommitOrderDependencyNode)o1).getFinishingTime();
        if (first == (second = ((CommitOrderDependencyNode)o2).getFinishingTime())) {
            return new DescriptorCompare().compare(((CommitOrderDependencyNode)o1).getDescriptor(), ((CommitOrderDependencyNode)o2).getDescriptor());
        }
        if (first > second) {
            return 1;
        }
        return -1;
    }

    public int getNextTime() {
        int result = this.currentTime++;
        return result;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getOrderedClasses() {
        NonSynchronizedVector orderedClasses = NonSynchronizedVector.newInstance(this.getOrderedDescriptors().size());
        Enumeration orderedDescriptorsEnum = this.getOrderedDescriptors().elements();
        while (orderedDescriptorsEnum.hasMoreElements()) {
            ((Vector)orderedClasses).addElement(((ClassDescriptor)orderedDescriptorsEnum.nextElement()).getJavaClass());
        }
        return orderedClasses;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public CommitOrderDependencyNode nodeFor(Class c2) {
        Enumeration e2 = this.nodes.elements();
        while (e2.hasMoreElements()) {
            CommitOrderDependencyNode n2 = (CommitOrderDependencyNode)e2.nextElement();
            if (n2.getDescriptor().getJavaClass() != c2) continue;
            return n2;
        }
        return null;
    }

    public CommitOrderDependencyNode nodeFor(ClassDescriptor d2) {
        Enumeration e2 = this.nodes.elements();
        while (e2.hasMoreElements()) {
            CommitOrderDependencyNode n2 = (CommitOrderDependencyNode)e2.nextElement();
            if (n2.getDescriptor() != d2) continue;
            return n2;
        }
        return null;
    }

    public void orderCommits() {
        this.depthFirstSearch();
        Object[] nodeArray = new Object[this.nodes.size()];
        this.nodes.copyInto(nodeArray);
        CommitOrderCalculator.quicksort(nodeArray);
        Vector<ClassDescriptor> result = new Vector<ClassDescriptor>(this.nodes.size());
        int i2 = 0;
        while (i2 < this.nodes.size()) {
            CommitOrderDependencyNode node = (CommitOrderDependencyNode)nodeArray[i2];
            result.addElement(node.getDescriptor());
            ++i2;
        }
        this.orderedDescriptors = result;
    }

    private static void quicksort(Object[] arr) {
        CommitOrderCalculator.quicksort(arr, 0, arr.length - 1);
    }

    private static void quicksort(Object[] arr, int left, int right) {
        if (left >= right) {
            return;
        }
        CommitOrderCalculator.swap(arr, left, (left + right) / 2);
        int last = left;
        int i2 = left + 1;
        while (i2 <= right) {
            if (CommitOrderCalculator.doCompare(arr[i2], arr[left]) < 0) {
                CommitOrderCalculator.swap(arr, ++last, i2);
            }
            ++i2;
        }
        CommitOrderCalculator.swap(arr, left, last);
        CommitOrderCalculator.quicksort(arr, left, last - 1);
        CommitOrderCalculator.quicksort(arr, last + 1, right);
    }

    private static void swap(Object[] arr, int i2, int j2) {
        Object tmp = arr[i2];
        arr[i2] = arr[j2];
        arr[j2] = tmp;
    }
}

