/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public abstract class DatabaseQueryMechanism
implements Cloneable,
Serializable {
    protected DatabaseQuery query;

    public DatabaseQueryMechanism() {
    }

    public DatabaseQueryMechanism(DatabaseQuery query) {
        this.query = query;
    }

    protected void addWriteLockFieldForInsert() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().setupWriteFieldsForInsert(this.getWriteObjectQuery());
        }
    }

    public void buildSelectionCriteria(AbstractSession session) {
    }

    public Object checkCacheForObject(AbstractRecord translationRow, AbstractSession session) {
        if (translationRow == null || translationRow.isEmpty()) {
            return null;
        }
        List queryFields = this.query.getCall() == null ? this.query.getArguments() : this.query.getCall().getParameters();
        ClassDescriptor descriptor = this.getDescriptor();
        List<DatabaseField> primaryKeyFields = descriptor.getPrimaryKeyFields();
        for (DatabaseField primaryKeyField : primaryKeyFields) {
            if (queryFields.contains(primaryKeyField)) continue;
            return null;
        }
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromRow(translationRow, session);
        if (primaryKey == null) {
            return null;
        }
        if (this.query.isObjectBuildingQuery() && ((ObjectBuildingQuery)this.query).requiresDeferredLocks() || descriptor.shouldAcquireCascadedLocks()) {
            return session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(primaryKey, this.getReadObjectQuery().getReferenceClass(), false, descriptor);
        }
        return session.getIdentityMapAccessorInstance().getFromLocalIdentityMap(primaryKey, this.getReadObjectQuery().getReferenceClass(), false, descriptor);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatabaseQueryMechanism clone = (DatabaseQueryMechanism)this.clone();
        clone.setQuery(queryClone);
        return clone;
    }

    public abstract DatabaseCall cursorSelectAllRows() throws DatabaseException;

    public boolean isJPQLCallQueryMechanism() {
        return false;
    }

    public abstract Integer deleteAll() throws DatabaseException;

    public abstract Integer deleteObject() throws DatabaseException;

    public abstract Object execute() throws DatabaseException;

    public abstract Integer executeNoSelect() throws DatabaseException;

    public abstract Vector executeSelect() throws DatabaseException;

    public Object executeWrite() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (commitManager.isCommitCompletedInPostOrIgnore(object)) {
            return object;
        }
        if (commitManager.isCommitInPreModify(object)) {
            this.shallowInsertObjectForWrite(object, writeQuery, commitManager);
            return object;
        }
        try {
            this.getSession().beginTransaction();
            if (writeQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(0, writeQuery));
            }
            writeQuery.executeCommit();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    public void executeDeferredCall(DatasourceCall call) {
    }

    public Object executeWriteWithChangeSet() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
        ClassDescriptor descriptor = this.getDescriptor();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        Object object = writeQuery.getObject();
        if (!objectChangeSet.hasChanges() && !objectChangeSet.hasForcedChanges()) {
            commitManager.markCommitCompleted(object);
            return object;
        }
        if (commitManager.isCommitCompletedInPostOrIgnore(object)) {
            return object;
        }
        try {
            writeQuery.executeCommitWithChangeSet();
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException exception) {
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.query.getDescriptor();
    }

    public AbstractRecord getModifyRow() {
        if (this.query.isModifyQuery()) {
            return ((ModifyQuery)this.query).getModifyRow();
        }
        return null;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    protected ReadObjectQuery getReadObjectQuery() {
        return (ReadObjectQuery)this.query;
    }

    public Expression getSelectionCriteria() {
        return null;
    }

    protected AbstractSession getSession() {
        return this.query.getSession();
    }

    protected AbstractSession getExecutionSession() {
        return this.query.getExecutionSession();
    }

    protected AbstractRecord getTranslationRow() {
        return this.query.getTranslationRow();
    }

    protected WriteObjectQuery getWriteObjectQuery() {
        return (WriteObjectQuery)this.query;
    }

    public abstract void insertObject() throws DatabaseException;

    public void insertObject(boolean reprepare) {
        this.insertObject();
    }

    public void insertObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        boolean isFKUpdate = false;
        if (!writeQuery.isUserDefined() && queryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedInsert();
            return;
        }
        Object object = writeQuery.getObject();
        AbstractSession session = writeQuery.getSession();
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        CommitManager commitManager = session.getCommitManager();
        DescriptorEventManager eventManager = descriptor.getEventManager();
        commitManager.markPreModifyCommitInProgress(object);
        if (changeSet == null && eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(4, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preInsert(writeQuery);
        }
        if (commitManager.isShallowCommitted(object)) {
            isFKUpdate = true;
            this.updateForeignKeyFieldAfterInsert();
        } else {
            AbstractRecord modifyRow = writeQuery.getModifyRow();
            if (modifyRow == null) {
                if (writeQuery.shouldCascadeParts()) {
                    writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session, DatabaseMapping.WriteType.INSERT));
                } else {
                    writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(object, session));
                }
            } else if (writeQuery.shouldCascadeParts()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(modifyRow, object, session, DatabaseMapping.WriteType.INSERT));
            } else {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(modifyRow, object, session));
            }
            modifyRow = this.getModifyRow();
            writeQuery.setTranslationRow(modifyRow);
            if (!descriptor.isAggregateCollectionDescriptor()) {
                writeQuery.setPrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session));
            }
            this.addWriteLockFieldForInsert();
            if (descriptor.hasSerializedObjectPolicy()) {
                descriptor.getSerializedObjectPolicy().putObjectIntoRow(modifyRow, object, session);
            }
            int modifyRowSize = modifyRow.size();
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(12, writeQuery);
                event.setRecord(modifyRow);
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementInsert(writeQuery);
            }
            this.insertObject(modifyRowSize != modifyRow.size());
            this.registerObjectInIdentityMap(object, descriptor, session);
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postInsert(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            if (isFKUpdate) {
                descriptor.getHistoryPolicy().postUpdate(writeQuery, true);
            } else {
                descriptor.getHistoryPolicy().postInsert(writeQuery);
            }
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(5, writeQuery));
        }
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isExpressionQueryMechanism() {
        return false;
    }

    public boolean isQueryByExampleMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    protected void performUserDefinedInsert() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getInsertQuery());
    }

    protected void performUserDefinedUpdate() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getUpdateQuery());
    }

    protected void performUserDefinedWrite(WriteObjectQuery userDefinedWriteQuery) {
        WriteObjectQuery query = this.getWriteObjectQuery();
        userDefinedWriteQuery.checkPrepare(query.getSession(), query.getTranslationRow());
        WriteObjectQuery writeQuery = (WriteObjectQuery)userDefinedWriteQuery.clone();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(query.getObject());
        writeQuery.setObjectChangeSet(query.getObjectChangeSet());
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        writeQuery.setShouldMaintainCache(query.shouldMaintainCache());
        writeQuery.setTranslationRow(query.getTranslationRow());
        writeQuery.setModifyRow(query.getModifyRow());
        writeQuery.setPrimaryKey(query.getPrimaryKey());
        writeQuery.setSession(query.getSession());
        if (writeQuery.getObjectChangeSet() != null) {
            writeQuery.executeCommitWithChangeSet();
        } else {
            writeQuery.executeCommit();
        }
    }

    public void prepare() throws QueryException {
    }

    public abstract void prepareCursorSelectAllRows() throws QueryException;

    public abstract void prepareDeleteAll() throws QueryException;

    public abstract void prepareDeleteObject() throws QueryException;

    public abstract void prepareDoesExist(DatabaseField var1) throws QueryException;

    public abstract void prepareExecuteNoSelect() throws QueryException;

    public abstract void prepareExecute() throws QueryException;

    public abstract void prepareExecuteSelect() throws QueryException;

    public abstract void prepareInsertObject() throws QueryException;

    public abstract void prepareReportQuerySelectAllRows() throws QueryException;

    public abstract void prepareReportQuerySubSelect() throws QueryException;

    public abstract void prepareSelectAllRows() throws QueryException;

    public abstract void prepareSelectOneRow() throws QueryException;

    public abstract void prepareUpdateObject() throws QueryException;

    public abstract void prepareUpdateAll() throws QueryException;

    protected void registerObjectInIdentityMap(Object object, ClassDescriptor descriptor, AbstractSession session) {
        WriteObjectQuery query = this.getWriteObjectQuery();
        if (query.shouldMaintainCache()) {
            if (descriptor.usesOptimisticLocking()) {
                Object optimisticLockValue = descriptor.getOptimisticLockingPolicy().getValueToPutInCache(query.getModifyRow(), session);
                session.getIdentityMapAccessorInstance().putInIdentityMap(object, query.getPrimaryKey(), optimisticLockValue, System.currentTimeMillis(), descriptor);
            } else {
                session.getIdentityMapAccessorInstance().putInIdentityMap(object, query.getPrimaryKey(), null, System.currentTimeMillis(), descriptor);
            }
        }
    }

    public abstract Vector selectAllReportQueryRows() throws DatabaseException;

    public abstract Vector selectAllRows() throws DatabaseException;

    public abstract AbstractRecord selectOneRow() throws DatabaseException;

    public abstract AbstractRecord selectRowForDoesExist(DatabaseField var1) throws DatabaseException;

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    protected void shallowInsertObjectForWrite(Object object, WriteObjectQuery writeQuery, CommitManager commitManager) throws DatabaseException, OptimisticLockException {
        boolean doesExist;
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession();
            boolean bl = doesExist = !uow.isCloneNewObject(object);
            if (doesExist) {
                doesExist = uow.isObjectRegistered(object);
            }
        } else {
            DoesExistQuery existQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            existQuery.setObject(object);
            existQuery.setPrimaryKey(writeQuery.getPrimaryKey());
            existQuery.setDescriptor(this.getDescriptor());
            existQuery.setTranslationRow(this.getTranslationRow());
            doesExist = (Boolean)this.getSession().executeQuery(existQuery);
        }
        if (!doesExist) {
            writeQuery.dontCascadeParts();
            this.insertObjectForWrite();
            commitManager.markShallowCommit(object);
        }
    }

    protected void updateForeignKeyFieldAfterInsert() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        writeQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
        writeQuery.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, this.getSession()));
        this.updateForeignKeyFieldAfterInsert(writeQuery);
    }

    public abstract Integer updateAll() throws DatabaseException;

    public abstract Integer updateObject() throws DatabaseException;

    protected abstract void updateForeignKeyFieldAfterInsert(WriteObjectQuery var1);

    public void updateForeignKeyFieldBeforeDelete() {
    }

    protected void updateObjectAndRowWithReturnRow(Collection returnFields, boolean isFirstCallForInsert) {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        AbstractRecord outputRow = (AbstractRecord)writeQuery.getProperties().get("output");
        if (outputRow == null || outputRow.isEmpty()) {
            return;
        }
        DatabaseRecord row = new DatabaseRecord();
        for (DatabaseField field : returnFields) {
            if (!outputRow.containsKey(field)) continue;
            row.put(field, outputRow.get(field));
        }
        if (row.isEmpty()) {
            return;
        }
        Object object = writeQuery.getObject();
        ObjectChangeSet objectChangeSet = null;
        if (this.getSession().isUnitOfWork() && (objectChangeSet = writeQuery.getObjectChangeSet()) == null && ((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet() != null) {
            objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
        }
        this.getDescriptor().getObjectBuilder().assignReturnRow(object, writeQuery.getSession(), row, objectChangeSet);
        Object primaryKey = null;
        if (isFirstCallForInsert) {
            DatabaseRecord pkToModify = new DatabaseRecord();
            List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
            int i2 = 0;
            while (i2 < primaryKeyFields.size()) {
                DatabaseField field = primaryKeyFields.get(i2);
                if (row.containsKey(field)) {
                    pkToModify.put(field, row.get(field));
                }
                ++i2;
            }
            if (!pkToModify.isEmpty()) {
                primaryKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
                writeQuery.setPrimaryKey(primaryKey);
                this.getModifyRow().putAll((Map)pkToModify);
                this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow(), object, this.getSession());
            }
        }
        if (objectChangeSet != null && primaryKey != null) {
            objectChangeSet.setId(primaryKey);
        }
    }

    protected void updateObjectAndRowWithSequenceNumber() throws DatabaseException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        writeQuery.getDescriptor().getObjectBuilder().assignSequenceNumber(writeQuery);
    }

    public void updateObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedUpdate();
            return;
        }
        Object object = writeQuery.getObject();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager eventManager = descriptor.getEventManager();
        if (writeQuery.getObjectChangeSet() == null && eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(6, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && !this.getSession().isUnitOfWork()) {
            writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, this.getSession(), DatabaseMapping.WriteType.UNDEFINED));
        } else {
            writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForUpdate(writeQuery));
        }
        Boolean shouldModifyVersionField = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).hasOptimisticReadLockObjects()) {
            shouldModifyVersionField = (Boolean)((UnitOfWorkImpl)session).getOptimisticReadLockObjects().get(writeQuery.getObject());
        }
        if (!this.getModifyRow().isEmpty() || shouldModifyVersionField != null || descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getForceUpdate()) {
            int rowCount;
            if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && this.getSession().isUnitOfWork()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, this.getSession(), DatabaseMapping.WriteType.UNDEFINED));
            }
            if (descriptor.usesOptimisticLocking()) {
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                policy.addLockValuesToTranslationRow(writeQuery);
                if (!this.getModifyRow().isEmpty() || shouldModifyVersionField.booleanValue()) {
                    policy.updateRowAndObjectForUpdate(writeQuery, object);
                } else if (!shouldModifyVersionField.booleanValue() && policy instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)policy).writeLockValueIntoRow(writeQuery, object);
                }
            }
            if (descriptor.hasSerializedObjectPolicy()) {
                descriptor.getSerializedObjectPolicy().putObjectIntoRow(this.getModifyRow(), object, session);
            }
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((rowCount = this.updateObject().intValue()) < 1 && session.hasEventManager()) {
                session.getEventManager().noRowsModified(writeQuery, object);
            }
            if (descriptor.usesOptimisticLocking()) {
                descriptor.getOptimisticLockingPolicy().validateUpdate(rowCount, object, writeQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postUpdate(writeQuery);
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }

    public void updateObjectForWriteWithChangeSet() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        Object object = writeQuery.getObject();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            commitManager.markPreModifyCommitInProgress(object);
            this.performUserDefinedUpdate();
            return;
        }
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager eventManager = descriptor.getEventManager();
        if (changeSet.hasChanges() && eventManager.hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(17, writeQuery);
            eventManager.executeEvent(event);
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet();
            if (!uowChangeSet.isChangeSetFromOutsideUOW() && writeQuery.getObjectChangeSet().shouldRecalculateAfterUpdateEvent()) {
                if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    writeQuery.getObjectChangeSet().clear(false);
                }
                if (descriptor.getObjectChangePolicy().calculateChangesForExistingObject(object, uowChangeSet, (UnitOfWorkImpl)session, descriptor, false) == null) {
                    uowChangeSet.getAllChangeSets().remove(writeQuery.getObjectChangeSet());
                }
            }
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForUpdateWithChangeSet(writeQuery));
        Boolean shouldModifyVersionField = changeSet.shouldModifyVersionField();
        if (!this.getModifyRow().isEmpty() || shouldModifyVersionField != null || changeSet.hasCmpPolicyForcedUpdate()) {
            int rowCount;
            OptimisticLockingPolicy lockingPolicy;
            if (writeQuery.isUserDefined() || writeQuery.isCallQuery()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session, DatabaseMapping.WriteType.UNDEFINED));
            }
            if ((lockingPolicy = descriptor.getOptimisticLockingPolicy()) != null) {
                RepeatableWriteUnitOfWork uow;
                lockingPolicy.addLockValuesToTranslationRow(writeQuery);
                boolean existingOptimisticLock = false;
                if (session instanceof RepeatableWriteUnitOfWork && (uow = (RepeatableWriteUnitOfWork)session).getOptimisticReadLockObjects().get(object) != null && uow.getCumulativeUOWChangeSet() != null && uow.getCumulativeUOWChangeSet().getObjectChangeSetForClone(object) != null) {
                    existingOptimisticLock = true;
                }
                if (!existingOptimisticLock) {
                    if (shouldModifyVersionField != null && shouldModifyVersionField.booleanValue() || !this.getModifyRow().isEmpty()) {
                        lockingPolicy.updateRowAndObjectForUpdate(writeQuery, object);
                    } else if (!shouldModifyVersionField.booleanValue() && lockingPolicy instanceof VersionLockingPolicy) {
                        ((VersionLockingPolicy)lockingPolicy).writeLockValueIntoRow(writeQuery, object);
                    }
                }
            }
            if (descriptor.hasSerializedObjectPolicy()) {
                descriptor.getSerializedObjectPolicy().putObjectIntoRow(this.getModifyRow(), object, session);
            }
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((rowCount = this.updateObject().intValue()) < 1 && session.hasEventManager()) {
                session.getEventManager().noRowsModified(writeQuery, object);
            }
            if (lockingPolicy != null) {
                lockingPolicy.validateUpdate(rowCount, object, writeQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postUpdate(writeQuery);
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }

    public void unprepare() {
    }
}

