/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.IntArray;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class BufferedTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List<Object> nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected IntArray calls;

    public BufferedTreeNodeStream(Object object) {
        this(new CommonTreeAdaptor(), object);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object) {
        this(treeAdaptor, object, 100);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object, int n2) {
        this.root = object;
        this.adaptor = treeAdaptor;
        this.nodes = new ArrayList<Object>(n2);
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    public void fillBuffer(Object object) {
        boolean bl = this.adaptor.isNil(object);
        if (!bl) {
            this.nodes.add(object);
        }
        int n2 = this.adaptor.getChildCount(object);
        if (!bl && n2 > 0) {
            this.addNavigationNode(2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.adaptor.getChild(object, i2);
            this.fillBuffer(object2);
        }
        if (!bl && n2 > 0) {
            this.addNavigationNode(3);
        }
    }

    protected int getNodeIndex(Object object) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object object2 = this.nodes.get(i2);
            if (object2 != object) continue;
            return i2;
        }
        return -1;
    }

    protected void addNavigationNode(int n2) {
        Object object = n2 == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(object);
    }

    @Override
    public Object get(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(n2);
    }

    @Override
    public Object LT(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            return this.LB(-n2);
        }
        if (this.p + n2 - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + n2 - 1);
    }

    public Object getCurrentSymbol() {
        return this.LT(1);
    }

    protected Object LB(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (this.p - n2 < 0) {
            return null;
        }
        return this.nodes.get(this.p - n2);
    }

    @Override
    public Object getTreeSource() {
        return this.root;
    }

    @Override
    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    @Override
    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    @Override
    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void setTreeAdaptor(TreeAdaptor treeAdaptor) {
        this.adaptor = treeAdaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    @Override
    public void setUniqueNavigationNodes(boolean bl) {
        this.uniqueNavigationNodes = bl;
    }

    @Override
    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    @Override
    public int LA(int n2) {
        return this.adaptor.getType(this.LT(n2));
    }

    @Override
    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    @Override
    public void release(int n2) {
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public void rewind(int n2) {
        this.seek(n2);
    }

    @Override
    public void rewind() {
        this.seek(this.lastMarker);
    }

    @Override
    public void seek(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = n2;
    }

    public void push(int n2) {
        if (this.calls == null) {
            this.calls = new IntArray();
        }
        this.calls.push(this.p);
        this.seek(n2);
    }

    public int pop() {
        int n2 = this.calls.pop();
        this.seek(n2);
        return n2;
    }

    @Override
    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
        if (this.calls != null) {
            this.calls.clear();
        }
    }

    @Override
    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator<Object> iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    @Override
    public void replaceChildren(Object object, int n2, int n3, Object object2) {
        if (object != null) {
            this.adaptor.replaceChildren(object, n2, n3, object2);
        }
    }

    public String toTokenTypeString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object object = this.nodes.get(i2);
            stringBuilder.append(" ");
            stringBuilder.append(this.adaptor.getType(object));
        }
        return stringBuilder.toString();
    }

    public String toTokenString(int n2, int n3) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < this.nodes.size() && i2 <= n3; ++i2) {
            Object object = this.nodes.get(i2);
            stringBuilder.append(" ");
            stringBuilder.append(this.adaptor.getToken(object));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Object object, Object object2) {
        String string;
        Object object3;
        int n2;
        System.out.println("toString");
        if (object == null || object2 == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (object instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)object).getToken() + ", ");
        } else {
            System.out.println(object);
        }
        if (object2 instanceof CommonTree) {
            System.out.println(((CommonTree)object2).getToken());
        } else {
            System.out.println(object2);
        }
        if (this.tokens != null) {
            int n3 = this.adaptor.getTokenStartIndex(object);
            int n4 = this.adaptor.getTokenStopIndex(object2);
            if (this.adaptor.getType(object2) == 3) {
                n4 = this.adaptor.getTokenStopIndex(object);
            } else if (this.adaptor.getType(object2) == -1) {
                n4 = this.size() - 2;
            }
            return this.tokens.toString(n3, n4);
        }
        for (n2 = 0; n2 < this.nodes.size() && (object3 = this.nodes.get(n2)) != object; ++n2) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        object3 = this.nodes.get(n2);
        while (object3 != object2) {
            string = this.adaptor.getText(object3);
            if (string == null) {
                string = " " + String.valueOf(this.adaptor.getType(object3));
            }
            stringBuilder.append(string);
            object3 = this.nodes.get(++n2);
        }
        string = this.adaptor.getText(object2);
        if (string == null) {
            string = " " + String.valueOf(this.adaptor.getType(object2));
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected class StreamIterator
    implements Iterator<Object> {
        int i = 0;

        protected StreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < BufferedTreeNodeStream.this.nodes.size();
        }

        @Override
        public Object next() {
            int n2;
            if ((n2 = this.i++) < BufferedTreeNodeStream.this.nodes.size()) {
                return BufferedTreeNodeStream.this.nodes.get(n2);
            }
            return BufferedTreeNodeStream.this.eof;
        }

        @Override
        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

