/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.persistence.internal.libraries.antlr.runtime.IntStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.debug.BlankDebugEventListener;
import org.eclipse.persistence.internal.libraries.antlr.runtime.debug.DebugParser;
import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.DoubleKeyMap;

public class Profiler
extends BlankDebugEventListener {
    public static final String DATA_SEP = "\t";
    public static final String newline = System.getProperty("line.separator");
    static boolean dump = false;
    public static final String Version = "3";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public DebugParser parser = null;
    protected int ruleLevel = 0;
    protected Token lastRealTokenTouchedInDecision;
    protected Set<String> uniqueRules = new HashSet<String>();
    protected Stack<String> currentGrammarFileName = new Stack();
    protected Stack<String> currentRuleName = new Stack();
    protected Stack<Integer> currentLine = new Stack();
    protected Stack<Integer> currentPos = new Stack();
    protected DoubleKeyMap<String, Integer, DecisionDescriptor> decisions = new DoubleKeyMap();
    protected List<DecisionEvent> decisionEvents = new ArrayList<DecisionEvent>();
    protected Stack<DecisionEvent> decisionStack = new Stack();
    protected int backtrackDepth;
    ProfileStats stats = new ProfileStats();

    public Profiler() {
    }

    public Profiler(DebugParser debugParser) {
        this.parser = debugParser;
    }

    @Override
    public void enterRule(String string, String string2) {
        ++this.ruleLevel;
        ++this.stats.numRuleInvocations;
        this.uniqueRules.add(string + ":" + string2);
        this.stats.maxRuleInvocationDepth = Math.max(this.stats.maxRuleInvocationDepth, this.ruleLevel);
        this.currentGrammarFileName.push(string);
        this.currentRuleName.push(string2);
    }

    @Override
    public void exitRule(String string, String string2) {
        --this.ruleLevel;
        this.currentGrammarFileName.pop();
        this.currentRuleName.pop();
    }

    public void examineRuleMemoization(IntStream intStream, int n2, int n3, String string) {
        if (dump) {
            System.out.println("examine memo " + string + " at " + intStream.index() + ": " + n3);
        }
        if (n3 == -1) {
            ++this.stats.numMemoizationCacheMisses;
            ++this.stats.numGuessingRuleInvocations;
            ++this.currentDecision().numMemoizationCacheMisses;
        } else {
            ++this.stats.numMemoizationCacheHits;
            ++this.currentDecision().numMemoizationCacheHits;
        }
    }

    public void memoize(IntStream intStream, int n2, int n3, String string) {
        if (dump) {
            System.out.println("memoize " + string);
        }
        ++this.stats.numMemoizationCacheEntries;
    }

    @Override
    public void location(int n2, int n3) {
        this.currentLine.push(n2);
        this.currentPos.push(n3);
    }

    @Override
    public void enterDecision(int n2, boolean bl) {
        String string;
        DecisionDescriptor decisionDescriptor;
        this.lastRealTokenTouchedInDecision = null;
        ++this.stats.numDecisionEvents;
        int n3 = this.parser.getTokenStream().index();
        TokenStream tokenStream = this.parser.getTokenStream();
        if (dump) {
            System.out.println("enterDecision canBacktrack=" + bl + " " + n2 + " backtrack depth " + this.backtrackDepth + " @ " + tokenStream.get(tokenStream.index()) + " rule " + this.locationDescription());
        }
        if ((decisionDescriptor = this.decisions.get(string = this.currentGrammarFileName.peek(), n2)) == null) {
            decisionDescriptor = new DecisionDescriptor();
            this.decisions.put(string, n2, decisionDescriptor);
            decisionDescriptor.decision = n2;
            decisionDescriptor.fileName = this.currentGrammarFileName.peek();
            decisionDescriptor.ruleName = this.currentRuleName.peek();
            decisionDescriptor.line = this.currentLine.peek();
            decisionDescriptor.pos = this.currentPos.peek();
            decisionDescriptor.couldBacktrack = bl;
        }
        ++decisionDescriptor.n;
        DecisionEvent decisionEvent = new DecisionEvent();
        this.decisionStack.push(decisionEvent);
        decisionEvent.decision = decisionDescriptor;
        decisionEvent.startTime = System.currentTimeMillis();
        decisionEvent.startIndex = n3;
    }

    @Override
    public void exitDecision(int n2) {
        int n3;
        DecisionEvent decisionEvent = this.decisionStack.pop();
        decisionEvent.stopTime = System.currentTimeMillis();
        int n4 = this.lastRealTokenTouchedInDecision.getTokenIndex();
        int n5 = this.getNumberOfHiddenTokens(decisionEvent.startIndex, n4);
        decisionEvent.k = n3 = n4 - decisionEvent.startIndex - n5 + 1;
        decisionEvent.decision.maxk = Math.max(decisionEvent.decision.maxk, n3);
        if (dump) {
            System.out.println("exitDecision " + n2 + " in " + decisionEvent.decision.ruleName + " lookahead " + decisionEvent.k + " max token " + this.lastRealTokenTouchedInDecision);
        }
        this.decisionEvents.add(decisionEvent);
    }

    @Override
    public void consumeToken(Token token) {
        if (dump) {
            System.out.println("consume token " + token);
        }
        if (!this.inDecision()) {
            ++this.stats.numTokens;
            return;
        }
        if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
            this.lastRealTokenTouchedInDecision = token;
        }
        DecisionEvent decisionEvent = this.currentDecision();
        int n2 = token.getTokenIndex();
        int n3 = this.getNumberOfHiddenTokens(decisionEvent.startIndex, n2);
        int n4 = n2 - decisionEvent.startIndex - n3 + 1;
        if (dump) {
            System.out.println("consume " + n2 + " " + n4 + " tokens ahead in " + decisionEvent.decision.ruleName + "-" + decisionEvent.decision.decision + " start index " + decisionEvent.startIndex);
        }
    }

    public boolean inDecision() {
        return this.decisionStack.size() > 0;
    }

    @Override
    public void consumeHiddenToken(Token token) {
        if (!this.inDecision()) {
            ++this.stats.numHiddenTokens;
        }
    }

    @Override
    public void LT(int n2, Token token) {
        if (this.inDecision() && n2 > 0) {
            DecisionEvent decisionEvent = this.currentDecision();
            if (dump) {
                System.out.println("LT(" + n2 + ")=" + token + " index " + token.getTokenIndex() + " relative to " + decisionEvent.decision.ruleName + "-" + decisionEvent.decision.decision + " start index " + decisionEvent.startIndex);
            }
            if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
                this.lastRealTokenTouchedInDecision = token;
                if (dump) {
                    System.out.println("set last token " + this.lastRealTokenTouchedInDecision);
                }
            }
        }
    }

    @Override
    public void beginBacktrack(int n2) {
        if (dump) {
            System.out.println("enter backtrack " + n2);
        }
        ++this.backtrackDepth;
        DecisionEvent decisionEvent = this.currentDecision();
        if (decisionEvent.decision.couldBacktrack) {
            ++this.stats.numBacktrackOccurrences;
            ++decisionEvent.decision.numBacktrackOccurrences;
            decisionEvent.backtracks = true;
        }
    }

    @Override
    public void endBacktrack(int n2, boolean bl) {
        if (dump) {
            System.out.println("exit backtrack " + n2 + ": " + bl);
        }
        --this.backtrackDepth;
    }

    @Override
    public void mark(int n2) {
        if (dump) {
            System.out.println("mark " + n2);
        }
    }

    @Override
    public void rewind(int n2) {
        if (dump) {
            System.out.println("rewind " + n2);
        }
    }

    @Override
    public void rewind() {
        if (dump) {
            System.out.println("rewind");
        }
    }

    protected DecisionEvent currentDecision() {
        return this.decisionStack.peek();
    }

    @Override
    public void recognitionException(RecognitionException recognitionException) {
        ++this.stats.numReportedErrors;
    }

    @Override
    public void semanticPredicate(boolean bl, String string) {
        ++this.stats.numSemanticPredicates;
        if (this.inDecision()) {
            DecisionEvent decisionEvent = this.currentDecision();
            decisionEvent.evalSemPred = true;
            ++decisionEvent.decision.numSemPredEvals;
            if (dump) {
                System.out.println("eval " + string + " in " + decisionEvent.decision.ruleName + "-" + decisionEvent.decision.decision);
            }
        }
    }

    @Override
    public void terminate() {
        for (DecisionEvent object : this.decisionEvents) {
            object.decision.avgk += (float)object.k;
            this.stats.avgkPerDecisionEvent += (float)object.k;
            if (!object.backtracks) continue;
            this.stats.avgkPerBacktrackingDecisionEvent += (float)object.k;
        }
        this.stats.averageDecisionPercentBacktracks = 0.0f;
        for (DecisionDescriptor decisionDescriptor : this.decisions.values()) {
            ++this.stats.numDecisionsCovered;
            decisionDescriptor.avgk = (float)((double)decisionDescriptor.avgk / (double)decisionDescriptor.n);
            if (decisionDescriptor.couldBacktrack) {
                ++this.stats.numDecisionsThatPotentiallyBacktrack;
                float f2 = (float)decisionDescriptor.numBacktrackOccurrences / (float)decisionDescriptor.n;
                this.stats.averageDecisionPercentBacktracks += f2;
            }
            if (decisionDescriptor.numBacktrackOccurrences <= 0) continue;
            ++this.stats.numDecisionsThatDoBacktrack;
        }
        this.stats.averageDecisionPercentBacktracks /= (float)this.stats.numDecisionsThatPotentiallyBacktrack;
        this.stats.averageDecisionPercentBacktracks *= 100.0f;
        this.stats.avgkPerDecisionEvent /= (float)this.stats.numDecisionEvents;
        this.stats.avgkPerBacktrackingDecisionEvent = (float)((double)this.stats.avgkPerBacktrackingDecisionEvent / (double)this.stats.numBacktrackOccurrences);
        System.err.println(this.toString());
        System.err.println(this.getDecisionStatsDump());
    }

    public void setParser(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public String toNotifyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Version);
        stringBuilder.append('\t');
        stringBuilder.append(this.parser.getClass().getName());
        return stringBuilder.toString();
    }

    public String toString() {
        return Profiler.toString(this.getReport());
    }

    public ProfileStats getReport() {
        this.stats.Version = Version;
        this.stats.name = this.parser.getClass().getName();
        this.stats.numUniqueRulesInvoked = this.uniqueRules.size();
        return this.stats;
    }

    public DoubleKeyMap<String, Integer, DecisionDescriptor> getDecisionStats() {
        return this.decisions;
    }

    public List<DecisionEvent> getDecisionEvents() {
        return this.decisionEvents;
    }

    public static String toString(ProfileStats profileStats) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ANTLR Runtime Report; Profile Version ");
        stringBuilder.append(profileStats.Version);
        stringBuilder.append(newline);
        stringBuilder.append("parser name ");
        stringBuilder.append(profileStats.name);
        stringBuilder.append(newline);
        stringBuilder.append("Number of rule invocations ");
        stringBuilder.append(profileStats.numRuleInvocations);
        stringBuilder.append(newline);
        stringBuilder.append("Number of unique rules visited ");
        stringBuilder.append(profileStats.numUniqueRulesInvoked);
        stringBuilder.append(newline);
        stringBuilder.append("Number of decision events ");
        stringBuilder.append(profileStats.numDecisionEvents);
        stringBuilder.append(newline);
        stringBuilder.append("Overall average k per decision event ");
        stringBuilder.append(profileStats.avgkPerDecisionEvent);
        stringBuilder.append(newline);
        stringBuilder.append("Number of backtracking occurrences (can be multiple per decision) ");
        stringBuilder.append(profileStats.numBacktrackOccurrences);
        stringBuilder.append(newline);
        stringBuilder.append("Overall average k per decision event that backtracks ");
        stringBuilder.append(profileStats.avgkPerBacktrackingDecisionEvent);
        stringBuilder.append(newline);
        stringBuilder.append("Number of rule invocations while backtracking ");
        stringBuilder.append(profileStats.numGuessingRuleInvocations);
        stringBuilder.append(newline);
        stringBuilder.append("num decisions that potentially backtrack ");
        stringBuilder.append(profileStats.numDecisionsThatPotentiallyBacktrack);
        stringBuilder.append(newline);
        stringBuilder.append("num decisions that do backtrack ");
        stringBuilder.append(profileStats.numDecisionsThatDoBacktrack);
        stringBuilder.append(newline);
        stringBuilder.append("num decisions that potentially backtrack but don't ");
        stringBuilder.append(profileStats.numDecisionsThatPotentiallyBacktrack - profileStats.numDecisionsThatDoBacktrack);
        stringBuilder.append(newline);
        stringBuilder.append("average % of time a potentially backtracking decision backtracks ");
        stringBuilder.append(profileStats.averageDecisionPercentBacktracks);
        stringBuilder.append(newline);
        stringBuilder.append("num unique decisions covered ");
        stringBuilder.append(profileStats.numDecisionsCovered);
        stringBuilder.append(newline);
        stringBuilder.append("max rule invocation nesting depth ");
        stringBuilder.append(profileStats.maxRuleInvocationDepth);
        stringBuilder.append(newline);
        stringBuilder.append("rule memoization cache size ");
        stringBuilder.append(profileStats.numMemoizationCacheEntries);
        stringBuilder.append(newline);
        stringBuilder.append("number of rule memoization cache hits ");
        stringBuilder.append(profileStats.numMemoizationCacheHits);
        stringBuilder.append(newline);
        stringBuilder.append("number of rule memoization cache misses ");
        stringBuilder.append(profileStats.numMemoizationCacheMisses);
        stringBuilder.append(newline);
        stringBuilder.append("number of tokens ");
        stringBuilder.append(profileStats.numTokens);
        stringBuilder.append(newline);
        stringBuilder.append("number of hidden tokens ");
        stringBuilder.append(profileStats.numHiddenTokens);
        stringBuilder.append(newline);
        stringBuilder.append("number of char ");
        stringBuilder.append(profileStats.numCharsMatched);
        stringBuilder.append(newline);
        stringBuilder.append("number of hidden char ");
        stringBuilder.append(profileStats.numHiddenCharsMatched);
        stringBuilder.append(newline);
        stringBuilder.append("number of syntax errors ");
        stringBuilder.append(profileStats.numReportedErrors);
        stringBuilder.append(newline);
        return stringBuilder.toString();
    }

    public String getDecisionStatsDump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("location");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("n");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("avgk");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("maxk");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("synpred");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("sempred");
        stringBuilder.append(DATA_SEP);
        stringBuilder.append("canbacktrack");
        stringBuilder.append("\n");
        for (String string : this.decisions.keySet()) {
            for (int n2 : this.decisions.keySet(string)) {
                DecisionDescriptor decisionDescriptor = this.decisions.get(string, n2);
                stringBuilder.append(decisionDescriptor.decision);
                stringBuilder.append("@");
                stringBuilder.append(this.locationDescription(decisionDescriptor.fileName, decisionDescriptor.ruleName, decisionDescriptor.line, decisionDescriptor.pos));
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(decisionDescriptor.n);
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(String.format("%.2f", Float.valueOf(decisionDescriptor.avgk)));
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(decisionDescriptor.maxk);
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(decisionDescriptor.numBacktrackOccurrences);
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(decisionDescriptor.numSemPredEvals);
                stringBuilder.append(DATA_SEP);
                stringBuilder.append(decisionDescriptor.couldBacktrack ? "1" : "0");
                stringBuilder.append(newline);
            }
        }
        return stringBuilder.toString();
    }

    protected int[] trim(int[] nArray, int n2) {
        if (n2 < nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    protected int[] toArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Integer n2 = list.get(i2);
            nArray[i2] = n2;
        }
        return nArray;
    }

    public int getNumberOfHiddenTokens(int n2, int n3) {
        int n4 = 0;
        TokenStream tokenStream = this.parser.getTokenStream();
        for (int i2 = n2; i2 < tokenStream.size() && i2 <= n3; ++i2) {
            Token token = tokenStream.get(i2);
            if (token.getChannel() == 0) continue;
            ++n4;
        }
        return n4;
    }

    protected String locationDescription() {
        return this.locationDescription(this.currentGrammarFileName.peek(), this.currentRuleName.peek(), this.currentLine.peek(), this.currentPos.peek());
    }

    protected String locationDescription(String string, String string2, int n2, int n3) {
        return string + ":" + n2 + ":" + n3 + "(" + string2 + ")";
    }

    public static class DecisionEvent {
        public DecisionDescriptor decision;
        public int startIndex;
        public int k;
        public boolean backtracks;
        public boolean evalSemPred;
        public long startTime;
        public long stopTime;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
    }

    public static class DecisionDescriptor {
        public int decision;
        public String fileName;
        public String ruleName;
        public int line;
        public int pos;
        public boolean couldBacktrack;
        public int n;
        public float avgk;
        public int maxk;
        public int numBacktrackOccurrences;
        public int numSemPredEvals;
    }

    public static class ProfileStats {
        public String Version;
        public String name;
        public int numRuleInvocations;
        public int numUniqueRulesInvoked;
        public int numDecisionEvents;
        public int numDecisionsCovered;
        public int numDecisionsThatPotentiallyBacktrack;
        public int numDecisionsThatDoBacktrack;
        public int maxRuleInvocationDepth;
        public float avgkPerDecisionEvent;
        public float avgkPerBacktrackingDecisionEvent;
        public float averageDecisionPercentBacktracks;
        public int numBacktrackOccurrences;
        public int numFixedDecisions;
        public int minDecisionMaxFixedLookaheads;
        public int maxDecisionMaxFixedLookaheads;
        public int avgDecisionMaxFixedLookaheads;
        public int stddevDecisionMaxFixedLookaheads;
        public int numCyclicDecisions;
        public int minDecisionMaxCyclicLookaheads;
        public int maxDecisionMaxCyclicLookaheads;
        public int avgDecisionMaxCyclicLookaheads;
        public int stddevDecisionMaxCyclicLookaheads;
        public int numSemanticPredicates;
        public int numTokens;
        public int numHiddenTokens;
        public int numCharsMatched;
        public int numHiddenCharsMatched;
        public int numReportedErrors;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
        public int numGuessingRuleInvocations;
        public int numMemoizationCacheEntries;
    }
}

