/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import org.eclipse.persistence.internal.libraries.antlr.runtime.BaseRecognizer;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonToken;
import org.eclipse.persistence.internal.libraries.antlr.runtime.EarlyExitException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedNotSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedRangeException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedTokenException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.NoViableAltException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognizerSharedState;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;

    public Lexer() {
    }

    public Lexer(CharStream charStream) {
        this.input = charStream;
    }

    public Lexer(CharStream charStream, RecognizerSharedState recognizerSharedState) {
        super(recognizerSharedState);
        this.input = charStream;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.input != null) {
            this.input.seek(0);
        }
        if (this.state == null) {
            return;
        }
        this.state.token = null;
        this.state.type = 0;
        this.state.channel = 0;
        this.state.tokenStartCharIndex = -1;
        this.state.tokenStartCharPositionInLine = -1;
        this.state.tokenStartLine = -1;
        this.state.text = null;
    }

    @Override
    public Token nextToken() {
        while (true) {
            this.state.token = null;
            this.state.channel = 0;
            this.state.tokenStartCharIndex = this.input.index();
            this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.state.tokenStartLine = this.input.getLine();
            this.state.text = null;
            if (this.input.LA(1) == -1) {
                return this.getEOFToken();
            }
            try {
                this.mTokens();
                if (this.state.token == null) {
                    this.emit();
                } else if (this.state.token == Token.SKIP_TOKEN) continue;
                return this.state.token;
            }
            catch (MismatchedRangeException mismatchedRangeException) {
                this.reportError(mismatchedRangeException);
                continue;
            }
            catch (MismatchedTokenException mismatchedTokenException) {
                this.reportError(mismatchedTokenException);
                continue;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover(recognitionException);
                continue;
            }
            break;
        }
    }

    public Token getEOFToken() {
        CommonToken commonToken = new CommonToken(this.input, -1, 0, this.input.index(), this.input.index());
        commonToken.setLine(this.getLine());
        commonToken.setCharPositionInLine(this.getCharPositionInLine());
        return commonToken;
    }

    public void skip() {
        this.state.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream charStream) {
        this.input = null;
        this.reset();
        this.input = charStream;
    }

    public CharStream getCharStream() {
        return this.input;
    }

    @Override
    public String getSourceName() {
        return this.input.getSourceName();
    }

    public void emit(Token token) {
        this.state.token = token;
    }

    public Token emit() {
        CommonToken commonToken = new CommonToken(this.input, this.state.type, this.state.channel, this.state.tokenStartCharIndex, this.getCharIndex() - 1);
        commonToken.setLine(this.state.tokenStartLine);
        commonToken.setText(this.state.text);
        commonToken.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
        this.emit(commonToken);
        return commonToken;
    }

    public void match(String string) throws MismatchedTokenException {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (this.input.LA(1) != string.charAt(i2)) {
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(string.charAt(i2), this.input);
                this.recover(mismatchedTokenException);
                throw mismatchedTokenException;
            }
            this.input.consume();
            this.state.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int n2) throws MismatchedTokenException {
        if (this.input.LA(1) != n2) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(n2, this.input);
            this.recover(mismatchedTokenException);
            throw mismatchedTokenException;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public void matchRange(int n2, int n3) throws MismatchedRangeException {
        if (this.input.LA(1) < n2 || this.input.LA(1) > n3) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedRangeException mismatchedRangeException = new MismatchedRangeException(n2, n3, this.input);
            this.recover(mismatchedRangeException);
            throw mismatchedRangeException;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.state.text != null) {
            return this.state.text;
        }
        return this.input.substring(this.state.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String string) {
        this.state.text = string;
    }

    @Override
    public void reportError(RecognitionException recognitionException) {
        this.displayRecognitionError(this.getTokenNames(), recognitionException);
    }

    @Override
    public String getErrorMessage(RecognitionException recognitionException, String[] stringArray) {
        String string;
        if (recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting " + this.getCharErrorDisplay(mismatchedTokenException.expecting);
        } else if (recognitionException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)recognitionException;
            string = "no viable alternative at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof EarlyExitException) {
            EarlyExitException earlyExitException = (EarlyExitException)recognitionException;
            string = "required (...)+ loop did not match anything at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof MismatchedNotSetException) {
            MismatchedNotSetException mismatchedNotSetException = (MismatchedNotSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedNotSetException.expecting;
        } else if (recognitionException instanceof MismatchedSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedSetException.expecting;
        } else if (recognitionException instanceof MismatchedRangeException) {
            MismatchedRangeException mismatchedRangeException = (MismatchedRangeException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + this.getCharErrorDisplay(mismatchedRangeException.a) + ".." + this.getCharErrorDisplay(mismatchedRangeException.b);
        } else {
            string = super.getErrorMessage(recognitionException, stringArray);
        }
        return string;
    }

    public String getCharErrorDisplay(int n2) {
        String string = String.valueOf((char)n2);
        switch (n2) {
            case -1: {
                string = "<EOF>";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 13: {
                string = "\\r";
            }
        }
        return "'" + string + "'";
    }

    public void recover(RecognitionException recognitionException) {
        this.input.consume();
    }

    public void traceIn(String string, int n2) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceIn(string, n2, string2);
    }

    public void traceOut(String string, int n2) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceOut(string, n2, string2);
    }
}

