/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;

public class OracleObjectTypeMetadata
extends OracleComplexTypeMetadata {
    private List<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();

    public OracleObjectTypeMetadata() {
        super("<oracle-object>");
    }

    public OracleObjectTypeMetadata(MetadataAnnotation objectType, MetadataAccessor accessor) {
        super(objectType, accessor);
        Object[] objectArray = objectType.getAttributeArray("fields");
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object field = objectArray[n3];
            this.fields.add(new PLSQLParameterMetadata((MetadataAnnotation)field, accessor));
            ++n3;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof OracleObjectTypeMetadata && this.valuesMatch(this.fields, ((OracleObjectTypeMetadata)objectToCompare).getFields());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public List<PLSQLParameterMetadata> getFields() {
        return this.fields;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.fields, accessibleObject);
    }

    @Override
    public OracleObjectType process() {
        OracleObjectType objectType = new OracleObjectType();
        super.process(objectType);
        HashMap<String, DatabaseType> typeFields = new HashMap<String, DatabaseType>();
        for (PLSQLParameterMetadata field : this.fields) {
            typeFields.put(field.getName(), this.getDatabaseTypeEnum(field.getDatabaseType()));
        }
        objectType.setFields(typeFields);
        return objectType;
    }

    public void setFields(List<PLSQLParameterMetadata> fields) {
        this.fields = fields;
    }

    @Override
    public boolean isOracleObjectTypeMetadata() {
        return true;
    }
}

