/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.graphs.NamedAttributeNodeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.AttributeGroup;

public class NamedSubgraphMetadata
extends ORMetadata {
    protected String m_name;
    protected MetadataClass m_type;
    protected String m_typeName;
    protected List<NamedAttributeNodeMetadata> m_namedAttributeNodes = new ArrayList<NamedAttributeNodeMetadata>();

    public NamedSubgraphMetadata() {
        super("<named-subgraph>");
    }

    public NamedSubgraphMetadata(MetadataAnnotation namedSubgraph, ClassAccessor accessor) {
        super(namedSubgraph, accessor);
        this.m_name = namedSubgraph.getAttributeString("name");
        this.m_type = this.getMetadataClass(namedSubgraph.getAttributeClass("type", ClassConstants.Object_Class));
        Object[] objectArray = namedSubgraph.getAttributeArray("attributeNodes");
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object attributeNode = objectArray[n3];
            this.m_namedAttributeNodes.add(new NamedAttributeNodeMetadata((MetadataAnnotation)attributeNode, accessor));
            ++n3;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedSubgraphMetadata) {
            NamedSubgraphMetadata namedSubgraph = (NamedSubgraphMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, namedSubgraph.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_typeName, namedSubgraph.getTypeName())) {
                return false;
            }
            return this.valuesMatch(this.m_namedAttributeNodes, namedSubgraph.getNamedAttributeNodes());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_name != null ? this.m_name.hashCode() : 0;
        result = 31 * result + (this.m_typeName != null ? this.m_typeName.hashCode() : 0);
        result = 31 * result + (this.m_namedAttributeNodes != null ? this.m_namedAttributeNodes.hashCode() : 0);
        return result;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public List<NamedAttributeNodeMetadata> getNamedAttributeNodes() {
        return this.m_namedAttributeNodes;
    }

    public String getTypeClassName() {
        return this.m_type.getName();
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_namedAttributeNodes, accessibleObject);
        this.m_type = this.m_typeName != null && !this.m_typeName.equals("") ? this.initXMLClassName(this.m_typeName) : this.getMetadataClass(ClassConstants.Object_Class);
    }

    public void process(Map<String, Map<String, AttributeGroup>> attributeGraphs) {
        AttributeGroup attributeGraph = new AttributeGroup(this.getName(), this.getTypeClassName(), true);
        if (!attributeGraphs.containsKey(this.getName())) {
            attributeGraphs.put(this.getName(), new HashMap());
        }
        attributeGraphs.get(this.getName()).put(this.getTypeClassName(), attributeGraph);
    }

    public void processAttributeNodes(Map<String, Map<String, AttributeGroup>> attributeGraphs, AttributeGroup subgraph, AttributeGroup entityGraph) {
        for (NamedAttributeNodeMetadata attributeNode : this.getNamedAttributeNodes()) {
            attributeNode.process(attributeGraphs, subgraph, entityGraph);
        }
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNamedAttributeNodes(List<NamedAttributeNodeMetadata> namedAttributeNodes) {
        this.m_namedAttributeNodes = namedAttributeNodes;
    }

    public void setType(MetadataClass type) {
        this.m_type = type;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

