/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine {
    private static final String ATTRIBUTE = "@";
    private static final String TEXT = "text()";
    private static final String ALL_CHILDREN = "child::*";
    private static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence/orm";
    private static XPathEngine instance = null;

    private XPathEngine() {
    }

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    public Node selectSingleNode(Node contextNode, String[] xPathFragments) {
        if (contextNode == null) {
            return null;
        }
        return this.selectSingleNode(contextNode, xPathFragments, 0);
    }

    private Node selectSingleNode(Node contextNode, String[] xPathFragments, int index) {
        Node resultNode = this.getSingleNode(contextNode, xPathFragments[index]);
        if (resultNode == null || xPathFragments.length == index + 1) {
            return resultNode;
        }
        return this.selectSingleNode(resultNode, xPathFragments, index + 1);
    }

    public NodeList selectNodes(Node contextNode, String[] xPathFragments) {
        if (contextNode == null) {
            return null;
        }
        return this.selectNodes(contextNode, xPathFragments, 0);
    }

    private NodeList selectNodes(Node contextNode, String[] xPathFragments, int index) {
        NodeList resultNodes = this.getNodes(contextNode, xPathFragments[index]);
        if (xPathFragments.length != index + 1) {
            XMLNodeList result = new XMLNodeList();
            int numberOfResultNodes = resultNodes.getLength();
            int x2 = 0;
            while (x2 < numberOfResultNodes) {
                Node resultNode = resultNodes.item(x2);
                result.addAll(this.selectNodes(resultNode, xPathFragments, index + 1));
                ++x2;
            }
            return result;
        }
        return resultNodes;
    }

    private Node getSingleNode(Node contextNode, String xPathFragment) {
        if (xPathFragment.startsWith(ATTRIBUTE)) {
            return this.selectSingleAttribute(contextNode, xPathFragment);
        }
        if (TEXT.equals(xPathFragment)) {
            return this.selectSingleText(contextNode);
        }
        return this.selectSingleElement(contextNode, xPathFragment);
    }

    private NodeList getNodes(Node contextNode, String xPathFragment) {
        if (xPathFragment.startsWith(ATTRIBUTE)) {
            return this.selectAttributeNodes(contextNode, xPathFragment);
        }
        if (TEXT.equals(xPathFragment)) {
            return this.selectTextNodes(contextNode);
        }
        if (xPathFragment.equals(ALL_CHILDREN)) {
            return this.selectChildElements(contextNode);
        }
        return this.selectElementNodes(contextNode, xPathFragment);
    }

    private Node selectSingleAttribute(Node contextNode, String xPathFragment) {
        Element contextElement = (Element)contextNode;
        return contextElement.getAttributeNode(xPathFragment.substring(1));
    }

    private NodeList selectAttributeNodes(Node contextNode, String xPathFragment) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleAttribute(contextNode, xPathFragment);
        if (child != null) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, String xPathFragment) {
        Node child = contextNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && this.sameName(child, xPathFragment) && this.sameNamespaceURI(child, NAMESPACE_URI)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private NodeList selectChildElements(Node contextNode) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = contextNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                xmlNodeList.add(child);
            }
            child = child.getNextSibling();
        }
        return xmlNodeList;
    }

    private NodeList selectElementNodes(Node contextNode, String xPathFragment) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = contextNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && this.sameName(child, xPathFragment) && this.sameNamespaceURI(child, NAMESPACE_URI)) {
                xmlNodeList.add(child);
            }
            child = child.getNextSibling();
        }
        return xmlNodeList;
    }

    private Node selectSingleText(Node contextNode) {
        NodeList childrenNodes = contextNode.getChildNodes();
        if (childrenNodes.getLength() == 0) {
            return null;
        }
        if (childrenNodes.getLength() == 1) {
            Node child = childrenNodes.item(0);
            if (child.getNodeType() == 3) {
                return child;
            }
            return null;
        }
        String returnVal = null;
        int i2 = 0;
        while (i2 < childrenNodes.getLength()) {
            String val;
            Node next = childrenNodes.item(i2);
            if (next.getNodeType() == 3 && (val = ((Text)next).getNodeValue()) != null) {
                if (returnVal == null) {
                    returnVal = "";
                }
                returnVal = String.valueOf(returnVal) + val;
            }
            ++i2;
        }
        if (returnVal != null) {
            return contextNode.getOwnerDocument().createTextNode(returnVal);
        }
        return null;
    }

    private NodeList selectTextNodes(Node contextNode) {
        Node n2 = this.selectSingleText(contextNode);
        XMLNodeList xmlNodeList = new XMLNodeList();
        if (n2 != null) {
            xmlNodeList.add(n2);
        }
        return xmlNodeList;
    }

    private boolean sameNamespaceURI(Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI == namespaceURI) {
            return true;
        }
        if (nodeNamespaceURI == null && namespaceURI.equals("")) {
            return true;
        }
        if (namespaceURI == null && nodeNamespaceURI.equals("")) {
            return true;
        }
        return nodeNamespaceURI != null && nodeNamespaceURI.equals(namespaceURI);
    }

    private boolean sameName(Node node, String name) {
        return name.equals(node.getLocalName()) || name.equals(node.getNodeName());
    }
}

