/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;

public class DirectoryArchive
extends ArchiveBase
implements Archive {
    private File directory;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public DirectoryArchive(File directory, String descriptorLocation) throws MalformedURLException {
        this(directory, descriptorLocation, Logger.global);
    }

    public DirectoryArchive(File directory, String descriptorLocation, Logger logger) throws MalformedURLException {
        logger.entering("DirectoryArchive", "DirectoryArchive", new Object[]{directory});
        this.logger = logger;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory." + "If it is a jar file, then use JarFileArchive.");
        }
        this.directory = directory;
        this.rootURL = directory.toURI().toURL();
        this.descriptorLocation = descriptorLocation;
        logger.logp(Level.FINER, "DirectoryArchive", "DirectoryArchive", "rootURL = {0}", this.rootURL);
        this.init(this.directory, this.directory);
    }

    private void init(File top, File directory) {
        File[] dirFiles = directory.listFiles();
        if (dirFiles != null) {
            File[] fileArray = dirFiles;
            int n2 = dirFiles.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                if (!file.isDirectory()) {
                    String entryName = file.getPath().replace(File.separator, "/").substring(top.getPath().length() + 1);
                    this.entries.add(entryName);
                }
                ++n3;
            }
            File[] subDirs = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (subDirs != null) {
                File[] fileArray2 = subDirs;
                int n4 = subDirs.length;
                n2 = 0;
                while (n2 < n4) {
                    File subDir = fileArray2[n2];
                    this.init(top, subDir);
                    ++n2;
                }
            }
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        File f2 = this.getFile(entryPath);
        FileInputStream is = f2.exists() ? new FileInputStream(f2) : null;
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        File f2 = this.getFile(entryPath);
        URL url = f2.exists() ? f2.toURI().toURL() : null;
        return url;
    }

    private File getFile(String entryPath) {
        File f2 = new File(this.directory, entryPath);
        return f2;
    }

    @Override
    public void close() {
    }
}

