/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.IsolatedHashMap;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class EntityManagerFactoryProvider {
    public static final Map<String, EntityManagerSetupImpl> emSetupImpls = IsolatedHashMap.newMap();
    protected static final String[][] oldPropertyNames = new String[][]{{"max", "eclipselink.max-write-connections"}, {"min", "eclipselink.min-write-connections"}, {"max", "eclipselink.max-read-connections"}, {"min", "eclipselink.min-read-connections"}, {"max", "eclipselink.connections.max"}, {"min", "eclipselink.connections.min"}, {"initial", "eclipselink.connections.initial"}, {"wait", "eclipselink.connections.wait"}, {"max", "eclipselink.write-connections.max"}, {"min", "eclipselink.write-connections.min"}, {"initial", "eclipselink.write-connections.initial"}, {"max", "eclipselink.read-connections.max"}, {"min", "eclipselink.read-connections.min"}, {"shared", "eclipselink.read-connections.shared"}, {"initial", "eclipselink.read-connections.initial"}, {"eclipselink.jdbc.bind-parameters", "eclipselink.bind-all-parameters"}, {"eclipselink.target-database", "eclipselink.platform.class.name"}, {"eclipselink.target-server", "eclipselink.server.platform.class.name"}, {"eclipselink.cache.size.default", "eclipselink.cache.default-size"}, {"javax.persistence.jdbc.user", "eclipselink.jdbc.user"}, {"javax.persistence.jdbc.driver", "eclipselink.jdbc.driver"}, {"javax.persistence.jdbc.url", "eclipselink.jdbc.url"}, {"javax.persistence.jdbc.password", "eclipselink.jdbc.password"}, {"eclipselink.weaving", "persistence.tools.weaving"}, {"eclipselink.logging.level.metamodel", "eclipselink.logging.level.jpa_metamodel"}, {"eclipselink.logging.level.metadata", "eclipselink.logging.level.ejb_or_metadata"}};

    public static void addEntityManagerSetupImpl(String name, EntityManagerSetupImpl setup) {
        if (name == null) {
            emSetupImpls.put("", setup);
        }
        emSetupImpls.put(name, setup);
    }

    protected static void generateDefaultTables(SchemaManager mgr, EntityManagerSetupImpl.TableCreationType ddlType) {
        if (ddlType == null || ddlType == EntityManagerSetupImpl.TableCreationType.CREATE) {
            mgr.createDefaultTables(true);
        } else if (ddlType == EntityManagerSetupImpl.TableCreationType.DROP) {
            mgr.dropDefaultTables();
        } else if (ddlType == EntityManagerSetupImpl.TableCreationType.DROP_AND_CREATE) {
            mgr.replaceDefaultTables(true, false, true);
        } else if (ddlType == EntityManagerSetupImpl.TableCreationType.EXTEND) {
            mgr.extendDefaultTables(true);
        }
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides) {
        String value = overrides != null ? (String)overrides.get(propertyKey) : null;
        return value != null ? value : PrivilegedAccessHelper.getSystemProperty(propertyKey);
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides, String defaultValue) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString(propertyKey, overrides);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session);
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, AbstractSession session, boolean useSystemAsDefault) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session, useSystemAsDefault);
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, String defaultValue, AbstractSession session) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, overrides, session);
        if (value == null) {
            value = defaultValue;
            session.log(1, "properties", "property_value_default", new Object[]{propertyKey, value});
        }
        return value;
    }

    protected static Object getConfigPropertyLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        return EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session, true);
    }

    protected static Object getConfigPropertyLogDebug(String propertyKey, Map overrides, AbstractSession session, boolean useSystemAsDefault) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null && useSystemAsDefault) {
            value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(propertyKey)) : System.getProperty(propertyKey);
        }
        if (value != null && session != null && session.shouldLog(1, "properties")) {
            String overrideValue = PersistenceUnitProperties.getOverriddenLogStringForProperty(propertyKey);
            String logValue = overrideValue == null ? value : overrideValue;
            session.log(1, "properties", "property_value_specified", new Object[]{propertyKey, logValue});
        }
        return value;
    }

    public static boolean hasConfigProperty(String propertyKey, Map overrides) {
        return EntityManagerFactoryProvider.getConfigProperty(propertyKey, overrides) != null;
    }

    protected static Object getConfigProperty(String propertyKey, Map overrides) {
        return EntityManagerFactoryProvider.getConfigProperty(propertyKey, overrides, true);
    }

    protected static Object getConfigProperty(String propertyKey, Map overrides, boolean useSystemAsDefault) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null && useSystemAsDefault) {
            value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(propertyKey)) : System.getProperty(propertyKey);
        }
        return value;
    }

    protected static Object getConfigProperty(String propertyKey, Map overrides, Object defaultObj) {
        Object obj = EntityManagerFactoryProvider.getConfigProperty(propertyKey, overrides);
        return obj == null ? defaultObj : obj;
    }

    public static EntityManagerSetupImpl getEntityManagerSetupImpl(String emName) {
        if (emName == null) {
            return emSetupImpls.get("");
        }
        return emSetupImpls.get(emName);
    }

    public static Map<String, EntityManagerSetupImpl> getEmSetupImpls() {
        return emSetupImpls;
    }

    protected static void login(DatabaseSessionImpl session, Map properties, boolean requiresConnection) {
        String databaseGenerationAction = EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.database.action", properties);
        if ((databaseGenerationAction == null || databaseGenerationAction.equals("none")) && !requiresConnection) {
            session.setDatasourceAndInitialize();
        } else {
            String eclipselinkPlatform = (String)properties.get("eclipselink.target-database");
            if (eclipselinkPlatform == null || eclipselinkPlatform.equals("Auto") || session.isBroker()) {
                session.loginAndDetectDatasource();
            } else {
                session.login();
            }
        }
    }

    public static Map mergeMaps(Map target, Map source) {
        HashMap map = new HashMap();
        if (source != null) {
            map.putAll(source);
        }
        if (target != null) {
            map.putAll(target);
        }
        return map;
    }

    public static Map removeSpecifiedProperties(Map source, Collection keysToBeRemoved) {
        HashMap target = new HashMap();
        if (source != null) {
            target.putAll(source);
            Iterator it = keysToBeRemoved.iterator();
            while (it.hasNext()) {
                target.remove(it.next());
            }
        }
        return target;
    }

    public static Map keepSpecifiedProperties(Map source, Collection keysToBeKept) {
        HashMap target = new HashMap();
        if (source != null) {
            target.putAll(source);
            for (Map.Entry entry : source.entrySet()) {
                if (!keysToBeKept.contains(entry.getKey())) continue;
                target.put(entry.getKey(), entry.getValue());
            }
        }
        return target;
    }

    public static Map[] splitSpecifiedProperties(Map source, Collection keysToBeKept) {
        HashMap in = new HashMap();
        HashMap out = new HashMap();
        Map[] target = new Map[]{in, out};
        if (source != null) {
            for (Map.Entry entry : source.entrySet()) {
                if (keysToBeKept.contains(entry.getKey())) {
                    in.put(entry.getKey(), entry.getValue());
                    continue;
                }
                out.put(entry.getKey(), entry.getValue());
            }
        }
        return target;
    }

    public static Map[] splitProperties(Map source, Collection[] keys) {
        Map[] target = new Map[keys.length + 1];
        int i2 = 0;
        while (i2 <= keys.length) {
            target[i2] = new HashMap();
            ++i2;
        }
        if (source != null) {
            for (Map.Entry entry : source.entrySet()) {
                boolean isFound = false;
                int i3 = 0;
                while (i3 < keys.length && !isFound) {
                    if (keys[i3].contains(entry.getKey())) {
                        isFound = true;
                        target[i3].put(entry.getKey(), entry.getValue());
                    }
                    ++i3;
                }
                if (isFound) continue;
                target[keys.length].put(entry.getKey(), entry.getValue());
            }
        }
        return target;
    }

    protected static void translateOldProperties(Map m2, AbstractSession session) {
        int i2 = 0;
        while (i2 < oldPropertyNames.length) {
            String value = EntityManagerFactoryProvider.getConfigPropertyAsString(oldPropertyNames[i2][1], m2);
            if (value != null) {
                if (session != null) {
                    session.log(5, "transaction", "deprecated_property", oldPropertyNames[i2]);
                }
                m2.put(oldPropertyNames[i2][0], value);
            }
            ++i2;
        }
    }

    protected static void warnOldProperties(Map m2, AbstractSession session) {
        int i2 = 0;
        while (i2 < oldPropertyNames.length) {
            Object value = m2.get(oldPropertyNames[i2][1]);
            if (value != null) {
                session.log(5, "transaction", "deprecated_property", oldPropertyNames[i2]);
            }
            ++i2;
        }
    }
}

