/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class GenericsClassHelper {
    public static Type[] getParameterizedTypeArguments(Class concrete, Class classOrIface) {
        DeclaringClassInterfacePair declaringClassInterfacePair = GenericsClassHelper.getClass(concrete, classOrIface);
        if (declaringClassInterfacePair != null) {
            return GenericsClassHelper.getParameterizedTypeArguments(declaringClassInterfacePair);
        }
        return null;
    }

    private static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p2) {
        if (p2.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p2.genericInterface;
            Type[] as2 = pt.getActualTypeArguments();
            Type[] ras = new Type[as2.length];
            int i2 = 0;
            while (i2 < as2.length) {
                ClassTypePair ctp;
                Type a2 = as2[i2];
                if (a2 instanceof Class) {
                    ras[i2] = a2;
                } else if (a2 instanceof ParameterizedType) {
                    pt = (ParameterizedType)a2;
                    ras[i2] = a2;
                } else if (a2 instanceof TypeVariable && (ctp = GenericsClassHelper.resolveTypeVariable(p2.concreteClass, p2.declaringClass, (TypeVariable)a2)) != null) {
                    ras[i2] = ctp.t;
                }
                ++i2;
            }
            return ras;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class classOrIface) {
        return GenericsClassHelper.getClass(concrete, classOrIface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class classOrIface, Class c2) {
        DeclaringClassInterfacePair p2;
        Type[] gis = null;
        if (c2.getGenericSuperclass() != null) {
            gis = new Type[]{c2.getGenericSuperclass()};
        }
        if (gis == null) {
            gis = c2.getGenericInterfaces();
        }
        if ((p2 = GenericsClassHelper.getType(concrete, classOrIface, c2, gis)) != null) {
            return p2;
        }
        if ((c2 = c2.getSuperclass()) == null || c2 == Object.class) {
            return null;
        }
        return GenericsClassHelper.getClass(concrete, classOrIface, c2);
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class classOrIface, Class c2, Type[] ts) {
        Type[] typeArray = ts;
        int n2 = ts.length;
        int n3 = 0;
        while (n3 < n2) {
            Type t2 = typeArray[n3];
            DeclaringClassInterfacePair p2 = GenericsClassHelper.getType(concrete, classOrIface, c2, t2);
            if (p2 != null) {
                return p2;
            }
            ++n3;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class classOrIface, Class c2, Type t2) {
        if (t2 instanceof Class) {
            if (t2 == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c2, t2);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)t2);
        }
        if (t2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t2;
            if (pt.getRawType() == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c2, t2);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)pt.getRawType());
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(Class c2, Class dc, TypeVariable tv) {
        return GenericsClassHelper.resolveTypeVariable(c2, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class c2, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        Type[] typeArray = gis = c2.getGenericInterfaces();
        int n2 = gis.length;
        int n3 = 0;
        while (n3 < n2) {
            ParameterizedType pt;
            ClassTypePair ctp;
            Type gi = typeArray[n3];
            if (gi instanceof ParameterizedType && (ctp = GenericsClassHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map)) != null) {
                return ctp;
            }
            ++n3;
        }
        Type gsc = c2.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return GenericsClassHelper.resolveTypeVariable(pt, c2.getSuperclass(), dc, tv, map);
        }
        if (gsc instanceof Class) {
            return GenericsClassHelper.resolveTypeVariable(c2.getSuperclass(), dc, tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class c2, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = c2.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        int i2 = 0;
        while (i2 < typeArguments.length) {
            if (typeArguments[i2] instanceof TypeVariable) {
                Type t2 = map.get(typeArguments[i2]);
                submap.put(typeParameters[i2], t2);
            } else {
                submap.put(typeParameters[i2], typeArguments[i2]);
            }
            ++i2;
        }
        if (c2 == dc) {
            Type t3 = (Type)submap.get(tv);
            if (t3 instanceof Class) {
                return new ClassTypePair((Class)t3);
            }
            if (t3 instanceof GenericArrayType) {
                if ((t3 = ((GenericArrayType)t3).getGenericComponentType()) instanceof Class) {
                    c2 = (Class)t3;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c2));
                    }
                    catch (Exception t2) {
                        return null;
                    }
                }
                if (t3 instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t3).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c2 = (Class)rt;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c2), t3);
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
                return null;
            }
            if (t3 instanceof ParameterizedType) {
                pt = (ParameterizedType)t3;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return GenericsClassHelper.resolveTypeVariable(c2, dc, tv, submap);
    }

    protected static Class getClassOfType(Type type) {
        ParameterizedType subType;
        Type t2;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t3 = arrayType.getGenericComponentType();
            if (t3 instanceof Class) {
                return GenericsClassHelper.getArrayClass((Class)t3);
            }
        } else if (type instanceof ParameterizedType && (t2 = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t2;
        }
        return null;
    }

    private static Class getArrayClass(Class c2) {
        try {
            Object o2 = Array.newInstance(c2, 0);
            return o2.getClass();
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    private static class ClassTypePair {
        public final Type t;

        public ClassTypePair(Class c2) {
            this(c2, c2);
        }

        public ClassTypePair(Class c2, Type t2) {
            this.t = t2;
        }
    }

    private static class DeclaringClassInterfacePair {
        public final Class concreteClass;
        public final Class declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class concreteClass, Class declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }
}

