/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper.linkedlist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;

public class ExposedNodeLinkedList
implements List {
    private transient LinkedNode header;
    private transient int size = 0;

    public ExposedNodeLinkedList() {
        this.header.next = this.header = new LinkedNode(null, null, null);
        this.header.previous = this.header;
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw ValidationException.operationNotSupported("toArray");
    }

    @Override
    public Object[] toArray() {
        throw ValidationException.operationNotSupported("toArray");
    }

    public Object set(int index, Object value) {
        throw ValidationException.operationNotSupported("set");
    }

    public ListIterator listIterator(int index) {
        throw ValidationException.operationNotSupported("listIterator");
    }

    public ListIterator listIterator() {
        throw ValidationException.operationNotSupported("listIterator");
    }

    @Override
    public Iterator iterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public List subList(int start, int end) {
        throw ValidationException.operationNotSupported("subList");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw ValidationException.operationNotSupported("retainAll");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw ValidationException.operationNotSupported("removeAll");
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw ValidationException.operationNotSupported("containsAll");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw ValidationException.operationNotSupported("addAll");
    }

    public boolean addAll(int index, Collection collection) {
        throw ValidationException.operationNotSupported("addAll");
    }

    @Override
    public boolean remove(Object object) {
        throw ValidationException.operationNotSupported("remove");
    }

    @Override
    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    @Override
    public int lastIndexOf(Object object) {
        throw ValidationException.operationNotSupported("lastIndexOf");
    }

    public void add(int index, Object object) {
        throw ValidationException.operationNotSupported("add");
    }

    public Object remove(int index) {
        throw ValidationException.operationNotSupported("remove");
    }

    public Object get(int index) {
        throw ValidationException.operationNotSupported("get");
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.header.next.contents;
    }

    @Override
    public Object getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.header.previous.contents;
    }

    @Override
    public Object removeFirst() {
        if (this.size != 0) {
            Object first = this.header.next.contents;
            this.remove(this.header.next);
            return first;
        }
        return null;
    }

    @Override
    public Object removeLast() {
        if (this.size != 0) {
            Object last = this.header.previous.contents;
            this.remove(this.header.previous);
            return last;
        }
        return null;
    }

    public LinkedNode addFirst(Object o2) {
        return this.addAfter(o2, this.header);
    }

    public LinkedNode addLast(Object o2) {
        return this.addAfter(o2, this.header.previous);
    }

    @Override
    public boolean contains(Object o2) {
        return this.indexOf(o2) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
    }

    @Override
    public int indexOf(Object o2) {
        int index = 0;
        if (o2 == null) {
            LinkedNode n2 = this.header.next;
            while (n2 != this.header) {
                if (n2.contents == null) {
                    return index;
                }
                ++index;
                n2 = n2.next;
            }
        } else {
            LinkedNode n3 = this.header.next;
            while (n3 != this.header) {
                if (o2.equals(n3.contents)) {
                    return index;
                }
                ++index;
                n3 = n3.next;
            }
        }
        return -1;
    }

    private LinkedNode addAfter(Object o2, LinkedNode n2) {
        LinkedNode newNode;
        newNode.previous.next = newNode = new LinkedNode(o2, n2.next, n2);
        newNode.next.previous = newNode;
        ++this.size;
        return newNode;
    }

    public void remove(LinkedNode n2) {
        if (n2 == this.header) {
            throw new NoSuchElementException();
        }
        if (n2.previous == null || n2.next == null) {
            return;
        }
        n2.previous.next = n2.next;
        n2.next.previous = n2.previous;
        n2.previous = null;
        n2.next = null;
        n2.contents = null;
        --this.size;
    }

    public void moveFirst(LinkedNode node) {
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        if (node.previous == null || node.next == null) {
            ++this.size;
        } else {
            node.previous.next = node.next;
            node.next.previous = node.previous;
        }
        node.next = this.header.next;
        node.previous = this.header;
        this.header.next = node;
        node.next.previous = node;
    }
}

