/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class NonSynchronizedSubVector
extends NonSynchronizedVector {
    private Vector l;
    private int offset;
    private int size;

    public NonSynchronizedSubVector(Vector list, int fromIndex, int toIndex) {
        super(0);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public Object set(int index, Object element) {
        return this.l.set(index + this.offset, element);
    }

    @Override
    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    @Override
    public Object elementAt(int index) {
        return this.get(index);
    }

    @Override
    public Object firstElement() {
        return this.get(0);
    }

    @Override
    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object elem, int index) {
        int size = this.size();
        if (elem == null) {
            int i2 = index;
            while (i2 < size) {
                if (this.get(i2) == null) {
                    return i2;
                }
                ++i2;
            }
        } else {
            int i3 = index;
            while (i3 < size) {
                if (elem.equals(this.get(i3))) {
                    return i3;
                }
                ++i3;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem, int index) {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " >= " + size);
        }
        if (elem == null) {
            int i2 = index;
            while (i2 >= 0) {
                if (this.get(i2) == null) {
                    return i2;
                }
                --i2;
            }
        } else {
            int i3 = index;
            while (i3 >= 0) {
                if (elem.equals(this.get(i3))) {
                    return i3;
                }
                --i3;
            }
        }
        return -1;
    }

    @Override
    public Object get(int index) {
        return this.l.get(index + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(index + this.offset, element);
        ++this.size;
        ++this.modCount;
    }

    @Override
    public Object remove(int index) {
        Object result = this.l.remove(index + this.offset);
        --this.size;
        ++this.modCount;
        return result;
    }

    @Override
    public boolean addAll(Collection c2) {
        return this.addAll(this.size, c2);
    }

    @Override
    public boolean addAll(int index, Collection c2) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c2.size();
        if (cSize == 0) {
            return false;
        }
        this.l.addAll(this.offset + index, c2);
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < NonSynchronizedSubVector.this.size();
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedSubVector.this.elementCount) {
                    return NonSynchronizedSubVector.this.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.l.toArray(), this.offset, result, 0, this.size);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a2) {
        if (a2.length < this.size) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.l.toArray(), this.offset, a2, 0, this.size);
        if (a2.length > this.size) {
            a2[this.size] = null;
        }
        return a2;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new ListIterator(index){
            private ListIterator i;
            {
                this.i = NonSynchronizedSubVector.this.l.listIterator(n2 + NonSynchronizedSubVector.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < NonSynchronizedSubVector.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size - 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }

            public void set(Object o2) {
                this.i.set(o2);
            }

            public void add(Object o2) {
                this.i.add(o2);
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size + 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }
        };
    }
}

