/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class LiteralExpression
extends Expression {
    protected String value;
    protected Expression localBase;

    public LiteralExpression() {
    }

    public LiteralExpression(String newValue, Expression baseExpression) {
        this.value = newValue;
        this.localBase = baseExpression;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LiteralExpression expression = (LiteralExpression)object;
        return this.getValue() == expression.getValue() || this.getValue() != null && this.getValue().equals(expression.getValue());
    }

    @Override
    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getValue() != null) {
            hashCode += this.getValue().hashCode();
        }
        return hashCode;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Literal";
    }

    @Override
    public ExpressionBuilder getBuilder() {
        if (this.localBase != null) {
            return this.localBase.getBuilder();
        }
        return null;
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isLiteralExpression() {
        return true;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.localBase = this.localBase.copiedVersionFrom(alreadyDone);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printString(this.value);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        LiteralExpression result = (LiteralExpression)this.clone();
        ((Expression)result).setLocalBase(this.getLocalBase().rebuildOn(newBase));
        return result;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
    }

    @Override
    public void setLocalBase(Expression e2) {
        this.localBase = e2;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        return (Expression)this.clone();
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        return this.getLocalBase().getFieldValue(this.getValue(), session);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getValue().toString());
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        newFields.addElement(new DatabaseField(this.getValue()));
        this.printSQL(printer);
    }
}

