/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.core.queries;

import java.util.ArrayDeque;

public class CoreAttributeConverter {
    private static final String DOT = Character.toString('.');

    public static final String[] convert(String ... nameOrPath) throws IllegalArgumentException {
        if (nameOrPath == null) {
            throw new IllegalArgumentException("Name or path value is null");
        }
        switch (nameOrPath.length) {
            case 0: {
                throw new IllegalArgumentException("Name or path value size is zero");
            }
            case 1: {
                String str = nameOrPath[0];
                if (str == null) {
                    throw new IllegalArgumentException("Name or path value is null");
                }
                int len = str.length();
                if (!str.contains(DOT)) {
                    switch (len) {
                        case 0: {
                            throw new IllegalArgumentException("Empty name or path value");
                        }
                        case 1: {
                            switch (str.charAt(0)) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Name or path value starts with whitespace.");
                                }
                            }
                        }
                    }
                    switch (str.charAt(0)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value starts with whitespace.");
                        }
                    }
                    switch (str.charAt(len - 1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value ends with whitespace.");
                        }
                    }
                    return nameOrPath;
                }
                char[] chars = nameOrPath[0].toCharArray();
                ConvertState s2 = ConvertState.DOT;
                int begIndex = 0;
                ArrayDeque<String> elements = null;
                int index = 0;
                while (index < len) {
                    char c2 = chars[index];
                    block17 : switch (s2) {
                        case DOT: {
                            switch (c2) {
                                case '.': {
                                    throw new IllegalArgumentException("Name or path value contains empty path element");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Path element starts with whitespace.");
                                }
                            }
                            s2 = ConvertState.CH;
                            break;
                        }
                        case SP: {
                            switch (c2) {
                                case '.': {
                                    throw new IllegalArgumentException("Path element ends with whitespace.");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    break block17;
                                }
                            }
                            s2 = ConvertState.CH;
                            break;
                        }
                        case CH: {
                            switch (c2) {
                                case '.': {
                                    if (elements == null) {
                                        elements = new ArrayDeque<String>(4);
                                    }
                                    elements.addLast(new String(chars, begIndex, index - begIndex));
                                    begIndex = index + 1;
                                    s2 = ConvertState.DOT;
                                    break block17;
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    s2 = ConvertState.SP;
                                }
                            }
                        }
                    }
                    ++index;
                }
                switch (s2) {
                    case DOT: {
                        throw new IllegalArgumentException("Empty name or path value or last path element");
                    }
                    case SP: {
                        throw new IllegalArgumentException("Name or path value ends with space");
                    }
                }
                if (elements == null) {
                    return nameOrPath;
                }
                int n2 = 0;
                int count = elements.size();
                String[] paths = new String[count + 1];
                while ((paths[n2++] = (String)elements.pollFirst()) != null) {
                }
                paths[count] = new String(chars, begIndex, index - begIndex);
                return paths;
            }
        }
        int i2 = 0;
        while (i2 < nameOrPath.length) {
            String item = nameOrPath[i2];
            if (item == null) {
                throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i2) + " is null");
            }
            int itemLen = item.length();
            if (itemLen == 0) {
                throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i2) + " is empty String");
            }
            switch (item.charAt(0)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i2) + " starts with whitespace");
                }
            }
            if (itemLen > 0) {
                switch (item.charAt(itemLen - 1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i2) + " ends with whitespace");
                    }
                }
            }
            ++i2;
        }
        return nameOrPath;
    }

    private CoreAttributeConverter() {
        throw new UnsupportedOperationException("Instances of CoreAttributeConverter are not allowed");
    }

    private static enum ConvertState {
        DOT,
        SP,
        CH;

    }
}

