/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel
implements Observer {
    private Image bgImage = null;
    private String imgPath;
    private boolean autosize;

    public String getImgPath() {
        return this.imgPath;
    }

    public void setImgPath(String imgPath) {
        try {
            this.setBgImage(ImageIO.read(this.getClass().getResourceAsStream(imgPath)));
        }
        catch (IOException ex) {
            Logger.getLogger(BackgroundPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.imgPath = imgPath;
    }

    public boolean isAutosize() {
        return this.autosize;
    }

    public void setAutosize(boolean autosize) {
        this.autosize = autosize;
        if (autosize) {
            this.resize();
        }
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image bgImage) {
        this.bgImage = bgImage;
        if (this.autosize) {
            this.resize();
        }
    }

    private void resize() {
        if (this.bgImage != null) {
            this.setPreferredSize(new Dimension(this.bgImage.getWidth(this), this.bgImage.getHeight(this)));
        }
    }

    public BackgroundPanel(Image img) throws IOException {
        this.bgImage = img;
        this.initComponents();
    }

    public BackgroundPanel() throws IOException {
        this.initComponents();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.bgImage != null) {
            g2.drawImage(this.bgImage, 0, 0, null);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void update(Observable o2, Object arg) {
        this.resize();
    }
}

