/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.Config;
import com.systel.print.ConfigTkt;
import com.systel.print.Field;
import com.systel.print.UCShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class UCText
extends UCShape {
    protected Color colFore;
    protected Color colBack;
    protected String text;
    protected String fontName;
    protected int fontSize;
    protected int fontStyle;
    protected int fontInvert;
    protected Field field;
    protected int al;
    protected boolean isTkt;
    protected boolean bBreakDraw;

    UCText(int n2, int n3, int n4, int n5, Field field, String string, String string2, int n6, int n7, int n8, Color color, int n9, boolean bl, boolean bl2) {
        super(n2, n3, n4, n5, color, true);
        this.text = string;
        this.fontSize = n7;
        this.fontStyle = n6;
        this.fontName = string2;
        this.field = field;
        this.al = n8;
        this.colFore = color;
        this.fontInvert = n9;
        this.isTkt = bl;
        this.bBreakDraw = bl2;
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCText\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<w>" + this.width + "</w>";
        string = string + "<h>" + this.height + "</h>";
        string = string + "<text>" + this.text + "</text>";
        string = string + "<font>" + this.fontName + "</font>";
        string = string + "<style>" + this.fontStyle + "</style>";
        string = string + "<size>" + this.fontSize + "</size>";
        string = string + "<align>" + this.al + "</align>";
        if (this.field != null) {
            string = this.isTkt ? string + "<field>" + ConfigTkt.FIELDS.indexOf(this.field) + "</field>" : string + "<field>" + Config.FIELDS.indexOf(this.field) + "</field>";
        }
        string = string + "<col>" + this.color.getRGB() + "</col>";
        string = string + "<inv>" + this.fontInvert + "</inv>";
        string = string + "</UCShape>";
        return string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n2) {
        this.fontSize = n2;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setStyle(int n2) {
        this.fontStyle = n2;
    }

    public int getFontInvert() {
        return this.fontInvert;
    }

    public void setFontInvert(int n2) {
        this.fontInvert = n2;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getAlignment() {
        return this.al;
    }

    public void setAlignment(int n2) {
        this.al = n2;
    }

    public void drawIntoRect(String string, Rectangle rectangle, Graphics graphics) {
        Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        int n4 = string.length();
        n2 = (int)((double)(n4 * rectangle.width) / (double)n2);
        if (n2 >= n4) {
            graphics.drawString(string, rectangle.x, rectangle.y + n3);
            return;
        }
        int n5 = n4 / n2;
        int n6 = 0;
        for (int i2 = 1; i2 <= n5; ++i2) {
            int n7 = n6;
            String string2 = string.substring(n7, n7 + n2 - 1);
            if (!string.substring(n6 + n2 - 1, n6 + n2).equals(" ") && !string.substring(n6 + n2 - 2, n6 + n2 - 1).equals(" ")) {
                string2 = string2 + "-";
            }
            graphics.drawString(string2.trim(), rectangle.x, rectangle.y + i2 * n3 + (i2 - 1) * 3);
            n6 += n2 - 1;
        }
        graphics.drawString(string.substring(n6, n4).trim(), rectangle.x, rectangle.y + (n5 + 1) * n3 + n5 * 3);
    }

    @Override
    public void draw(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
        if (this.text == null) {
            this.text = " ";
        }
        if (this.text.equals("")) {
            this.text = " ";
        }
        Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
        graphics.setFont(font);
        graphics.setColor(this.colFore);
        if (this.field != null) {
            if (this.isTkt) {
                if (!this.field.equals(ConfigTkt.FIELDS.get(0))) {
                    graphics.setColor(Color.RED);
                }
            } else if (!this.field.equals(Config.FIELDS.get(0))) {
                graphics.setColor(Color.RED);
            }
        }
        Object object = new AttributedString(this.text);
        ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
        if (this.fontInvert == 1) {
            if (this.field != null) {
                if (this.isTkt) {
                    if (!this.field.equals(ConfigTkt.FIELDS.get(0))) {
                        ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, Color.WHITE);
                        ((AttributedString)object).addAttribute(TextAttribute.BACKGROUND, Color.RED);
                    } else {
                        ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, Color.WHITE);
                        ((AttributedString)object).addAttribute(TextAttribute.BACKGROUND, Color.BLACK);
                    }
                } else if (!this.field.equals(Config.FIELDS.get(0))) {
                    ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, Color.WHITE);
                    ((AttributedString)object).addAttribute(TextAttribute.BACKGROUND, Color.RED);
                } else {
                    ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, Color.WHITE);
                    ((AttributedString)object).addAttribute(TextAttribute.BACKGROUND, Color.BLACK);
                }
            } else {
                ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, Color.WHITE);
                ((AttributedString)object).addAttribute(TextAttribute.BACKGROUND, Color.BLACK);
            }
        }
        object = ((AttributedString)object).getIterator();
        int n2 = object.getBeginIndex();
        int n3 = object.getEndIndex();
        FontRenderContext fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
        object = new LineBreakMeasurer((AttributedCharacterIterator)object, fontRenderContext);
        float f2 = this.width;
        float f3 = this.y;
        ((LineBreakMeasurer)object).setPosition(n2);
        new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        while (((LineBreakMeasurer)object).getPosition() < n3) {
            TextLayout textLayout = ((LineBreakMeasurer)object).nextLayout(f2);
            float f4 = this.al == 0 ? (float)this.x : (this.al == 2 ? (float)this.x + (f2 - textLayout.getAdvance()) / 2.0f : (float)this.x + f2 - textLayout.getAdvance());
            textLayout.draw((Graphics2D)graphics, f4, f3 += textLayout.getAscent());
            f4 = textLayout.getDescent() + textLayout.getLeading();
            n2 = (int)((double)((f3 += f4) + textLayout.getAscent()) + 0.5 - (double)this.y);
            if (n2 < this.height || !this.bBreakDraw) continue;
        }
    }

    @Override
    public void preview(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(Config.a);
        graphics2D.drawRect(this.x, this.y, this.width, this.height);
        this.draw(graphics);
    }

    @Override
    public String getName() {
        return "UCText";
    }
}

