/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.Config;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;

public class UCShape
implements Serializable {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Color color;
    protected boolean solid;
    protected boolean selected;
    protected boolean firstDrag;
    protected int dx1;
    protected int dx2;
    protected int dy1;
    protected int dy2;

    public UCShape(int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.x = n2;
        this.y = n3;
        this.width = n4 < 30 ? 30 : n4;
        this.height = n5 < 30 ? 30 : n5;
        this.color = color;
        this.solid = bl;
        this.firstDrag = false;
        this.dx1 = 0;
        this.dx2 = 0;
        this.dy1 = 0;
        this.dy2 = 0;
    }

    public UCShape(UCShape uCShape) {
        this(uCShape.x, uCShape.y, uCShape.width, uCShape.height, uCShape.color, uCShape.solid);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n2) {
        this.y = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean bl) {
        this.solid = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void draw(Graphics graphics) {
    }

    public void preview(Graphics graphics) {
    }

    public void highlight(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        graphics.setColor(Color.RED);
        ((Graphics2D)graphics).setStroke(Config.a);
        graphics.drawRect(this.x, this.y, this.width, this.height);
    }

    public boolean hasXY(int n2, int n3) {
        return n2 <= this.x + this.width && n2 >= this.x && n3 <= this.y + this.height && n3 >= this.y;
    }

    public void select() {
        this.selected = true;
        this.firstDrag = true;
    }

    public void deselect() {
        this.selected = false;
        this.firstDrag = false;
    }

    public void setXY(int n2, int n3) {
        this.setX(n2);
        this.setY(n3);
    }

    public void setSize(int n2, int n3) {
        this.setWidth(n2);
        this.setHeight(n3);
    }

    public void incX(int n2) {
        this.x += n2;
    }

    public void incY(int n2) {
        this.y += n2;
    }

    public void incXY(int n2, int n3) {
        this.incX(n2);
        this.incY(n3);
    }

    public void drag(int n2, int n3) {
        int n4 = this.getX() + this.getWidth() / 2;
        int n5 = this.getY() + this.getHeight() / 2;
        UCShape uCShape = this;
        uCShape.setX(uCShape.x + (n2 - n4));
        UCShape uCShape2 = this;
        uCShape2.setY(uCShape2.y + (n3 - n5));
    }

    public String getName() {
        return "UCShape";
    }

    public String toXml() {
        return "<UCShape></UCShape>";
    }
}

