/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.UCShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

class UCRegPolygon
extends UCShape {
    protected int numSides;
    protected int border;

    public UCRegPolygon(int n2, int n3, int n4, int n5, int n6, int n7, Color color, boolean bl) {
        super(n2, n3, n4, n5, color, bl);
        this.numSides = n6 < 3 ? 3 : n6;
        this.border = n7;
    }

    public UCRegPolygon(UCRegPolygon uCRegPolygon) {
        super(uCRegPolygon.x, uCRegPolygon.y, uCRegPolygon.width, uCRegPolygon.height, uCRegPolygon.color, uCRegPolygon.solid);
        this.numSides = uCRegPolygon.numSides < 3 ? 3 : uCRegPolygon.numSides;
        this.border = uCRegPolygon.border;
    }

    public int getSides() {
        return this.numSides;
    }

    public void setSides(int n2) {
        if (n2 <= 3) {
            this.numSides = n2;
        }
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n2) {
        this.border = n2;
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCRegPolygon\">";
        string = string + "<x1>" + this.x + "</x1>";
        string = string + "<y1>" + this.y + "</y1>";
        string = string + "<x2>" + this.width + "</x2>";
        string = string + "<y2>" + this.height + "</y2>";
        string = string + "<s>" + this.numSides + "</s>";
        string = string + "<col>" + this.color.getRGB() + "</col>";
        string = string + "<solid>" + this.solid + "</solid>";
        string = string + "<border>" + this.border + "</border>";
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public String getName() {
        return "UCRegPolygon";
    }

    @Override
    public void draw(Graphics graphics) {
        graphics.setColor(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(this.border));
        int[] nArray = new int[this.numSides];
        int[] nArray2 = new int[this.numSides];
        double d2 = Math.PI * 2 / (double)this.numSides;
        double d3 = Math.sqrt(Math.pow(this.width - this.x, 2.0) + Math.pow(this.height - this.y, 2.0));
        for (int i2 = 0; i2 < this.numSides; ++i2) {
            nArray[i2] = (int)((double)this.x + d3 * Math.sin((double)i2 * d2));
            nArray2[i2] = (int)((double)this.y + d3 * Math.cos((double)i2 * d2));
        }
        if (this.solid) {
            graphics2D.drawPolygon(nArray, nArray2, this.numSides);
            return;
        }
        graphics.fillPolygon(nArray, nArray2, this.numSides);
    }
}

