/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.Config;
import com.systel.print.UCShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class UCRect
extends UCShape {
    protected int border;
    protected int rw;
    protected int rh;

    public UCRect(int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        super(n2, n3, n4, n5, color, bl);
        this.border = n6;
        this.rw = 0;
        this.rh = 0;
    }

    public UCRect(int n2, int n3, int n4, int n5, int n6, Color color, boolean bl, int n7, int n8) {
        super(n2, n3, n4, n5, color, bl);
        this.border = n6;
        this.rw = Math.abs(n7);
        this.rh = Math.abs(n8);
    }

    public UCRect(UCRect uCRect) {
        super(uCRect.getX(), uCRect.getY(), uCRect.getWidth(), uCRect.getHeight(), uCRect.getColor(), uCRect.isSolid());
        this.border = uCRect.border;
        this.rw = Math.abs(uCRect.rw);
        this.rh = Math.abs(uCRect.rh);
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n2) {
        this.border = n2;
    }

    @Override
    public void draw(Graphics graphics) {
        graphics.setColor(this.getColor());
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(this.border));
        if (this.solid) {
            if (this.rw + this.rh > 0) {
                graphics2D.drawRoundRect(this.x, this.y, this.width, this.height, this.rw, this.rh);
                return;
            }
            graphics2D.drawRect(this.x, this.y, this.width, this.height);
            return;
        }
        if (this.rw + this.rh > 0) {
            graphics.fillRoundRect(this.x, this.y, this.width, this.height, this.rw, this.rh);
            graphics.setColor(Config.BLACK);
            graphics2D.drawRoundRect(this.x, this.y, this.width, this.height, this.rw, this.rh);
            return;
        }
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.setColor(Config.BLACK);
        graphics2D.drawRect(this.x, this.y, this.width, this.height);
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCRect\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<w>" + this.width + "</w>";
        string = string + "<h>" + this.height + "</h>";
        string = string + "<col>" + this.color.getRGB() + "</col>";
        string = string + "<solid>" + this.solid + "</solid>";
        string = string + "<rw>" + this.rw + "</rw>";
        string = string + "<rh>" + this.rh + "</rh>";
        string = string + "<border>" + this.border + "</border>";
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public String getName() {
        return "UCRect";
    }
}

