/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.systel.print.UCShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class UCQrCode
extends UCShape {
    byte[] img;
    BufferedImage bImage;
    private String value;
    int dim;

    public UCQrCode(UCShape uCShape) {
        super(uCShape);
        this.dim = 400;
        this.y += 50;
    }

    public UCQrCode(int n2, int n3, int n4, String string) {
        int n5 = n4;
        super(n2, n3, n5, n5, Color.BLACK, false);
        this.dim = 400;
        this.dim = n4;
        this.setValue(string);
    }

    public byte[] getQRCodeImage(String object, int n2, int n3) {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        object = qRCodeWriter.encode((String)object, BarcodeFormat.QR_CODE, n2, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)object, "PNG", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = byArray;
        return byArray;
    }

    public BufferedImage getQRCodeImageImage(String object, int n2) {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        int n3 = n2;
        object = qRCodeWriter.encode((String)object, BarcodeFormat.QR_CODE, n3, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)object, "PNG", byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        object = new ByteArrayInputStream((byte[])object);
        object = ImageIO.read((InputStream)object);
        return object;
    }

    public static void generateQRCodeImage(String object, int n2, int n3, String string) {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        object = qRCodeWriter.encode((String)object, BarcodeFormat.QR_CODE, n2, n3);
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)object, "PNG", path);
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCQrCode\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<value>" + this.value + "</value>";
        string = string + "<dim>" + this.dim + "</dim>";
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public void draw(Graphics graphics) {
        graphics.setColor(Color.getHSBColor(0.0f, 0.0f, 0.0f));
        BufferedImage bufferedImage = this.bImage;
        graphics.drawImage(bufferedImage, this.x, this.y, this.dim, this.dim, null);
    }

    @Override
    public String getName() {
        return "UCQrCode";
    }

    public void setImg(BufferedImage bufferedImage) {
        this.bImage = bufferedImage;
    }

    void setModuleWith(double d2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDim(int n2) {
        this.height = n2;
        this.width = n2;
        this.dim = n2;
        try {
            this.bImage = this.getQRCodeImageImage(this.value, n2);
            return;
        }
        catch (WriterException writerException) {
            Logger.getLogger(UCQrCode.class.getName()).log(Level.SEVERE, null, writerException);
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(UCQrCode.class.getName()).log(Level.SEVERE, null, iOException);
            return;
        }
    }

    public int getDim() {
        return this.dim;
    }

    public void setValue(String string) {
        this.value = string;
        try {
            this.bImage = this.getQRCodeImageImage(string, this.dim);
            return;
        }
        catch (WriterException writerException) {
            Logger.getLogger(UCQrCode.class.getName()).log(Level.SEVERE, null, writerException);
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(UCQrCode.class.getName()).log(Level.SEVERE, null, iOException);
            return;
        }
    }

    public String getValue() {
        return "qrDataLinkTest";
    }
}

