/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.Config;
import com.systel.print.Field;
import com.systel.print.UCShape;
import com.systel.print.editor.TemplateEditor;
import com.ucod.util.ImageTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UCImage
extends UCShape {
    private Image img;
    private Field field;
    private Dimension img2 = new Dimension(0, 0);
    private Dimension bound = new Dimension(0, 0);
    private Dimension result = new Dimension(0, 0);

    UCImage(int n2, int n3, Field field, int n4, int n5, Color color, Image image) {
        super(n2, n3, n4, n5, color, false);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        this.img = bufferedImage;
        this.field = field;
        graphics.dispose();
    }

    UCImage(UCImage uCImage) {
        super(uCImage.x, uCImage.y, uCImage.width, uCImage.height, uCImage.color, false);
        this.img = uCImage.img;
    }

    @Override
    public String toXml() {
        String string;
        block7: {
            string = "<UCShape type=\"UCImage\">";
            string = string + "<x>" + this.x + "</x>";
            string = string + "<y>" + this.y + "</y>";
            string = string + "<w>" + this.width + "</w>";
            string = string + "<h>" + this.height + "</h>";
            string = string + "<col>" + this.color.getRGB() + "</col>";
            string = string + "<solid>" + this.solid + "</solid>";
            if (this.img != null) {
                try {
                    BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12);
                    Graphics graphics = bufferedImage.getGraphics();
                    if (this.width < 0) {
                        this.x += this.width;
                        this.width = -this.width;
                    }
                    if (this.height < 0) {
                        this.y += this.height;
                        this.height = -this.height;
                    }
                    if (this.img != null) {
                        this.img2 = new Dimension(this.img.getWidth(null), this.img.getHeight(null));
                        this.bound = new Dimension(this.width, this.height);
                        this.result = UCImage.getScaledDimension(this.img2, this.bound);
                    }
                    graphics.drawImage(this.img, 0, 0, this.width, this.height, null);
                    graphics.dispose();
                    string = string + "<img>" + ImageTools.encodeImage(bufferedImage) + "</img>";
                }
                catch (IOException iOException) {
                    if (TemplateEditor.isRunInPc) break block7;
                    Logger.getLogger(UCImage.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
        if (this.field != null) {
            string = string + "<field>" + Config.IMAGE_FIELDS.indexOf(this.field) + "</field>";
        }
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public void draw(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
        if (this.img != null) {
            this.img2 = new Dimension(this.img.getWidth(null), this.img.getHeight(null));
            this.bound = new Dimension(this.width, this.height);
            this.result = UCImage.getScaledDimension(this.img2, this.bound);
            graphics.drawImage(this.img, this.x, this.y, this.width, this.height, null);
        }
    }

    @Override
    public String getName() {
        return "UCImage";
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image image) {
        this.img = image;
    }

    public static Dimension getScaledDimension(Dimension dimension, Dimension dimension2) {
        int n2 = dimension.width;
        int n3 = dimension.height;
        int cfr_ignored_0 = dimension2.width;
        int n4 = dimension2.height;
        n3 = n4 * n2 / n3;
        return new Dimension(n3, n4);
    }
}

