/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.UCIVAInfoItem;
import com.systel.print.UCShape;
import com.systel.print.UCText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ResourceBundle;

public class UCIVAInfoTable
extends UCShape {
    private static final double[] a = new double[]{0.25, 0.5, 0.75, 1.0};
    public static final UCIVAInfoItem[] DEFAULT_DATA = new UCIVAInfoItem[]{new UCIVAInfoItem(ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("IVA-tasa"), 0, 0, 2, false, 2, false, 0), new UCIVAInfoItem(ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("IVA-Imponible"), 0, 1, 2, false, 2, false, 0), new UCIVAInfoItem(ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("IVA-IVA"), 0, 2, 2, false, 2, false, 0), new UCIVAInfoItem(ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("Total"), 0, 3, 2, false, 2, false, 0), new UCIVAInfoItem("5", 1, 0, 2, false, 0, false, 0), new UCIVAInfoItem("20", 1, 1, 2, false, 0, false, 0), new UCIVAInfoItem("1", 1, 2, 2, false, 0, false, 0), new UCIVAInfoItem("21", 1, 3, 2, false, 0, false, 0)};
    public static final String TITLE = ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("IVA-TITLE");
    public static final String FOOTNOTE = "  ";
    protected int headerHeight;
    protected int rowHeight;
    protected UCIVAInfoItem[] items;
    protected String fontName;
    protected int fontStyle;
    protected int fontSize;
    protected String title;
    protected String titleFontName;
    protected int titleFontStyle;
    protected int titleFontSize;
    protected boolean showFootnote;
    protected String footnote;
    protected String fnFontName;
    protected int fnFontStyle;
    protected int fnFontSize;
    protected boolean drawHLines;
    protected boolean drawVLines;
    protected int outlineStroke;
    protected int intLinesStroke;
    protected boolean isDesignMode;
    private int rows;

    public UCIVAInfoTable(int n2, int n3, int n4, int n5, int n6, int n7, String string, String string2, int n8, int n9, UCIVAInfoItem[] uCIVAInfoItemArray, String string3, int n10, int n11, boolean bl, String string4, String string5, int n12, int n13, boolean bl2, boolean bl3, int n14, int n15, boolean bl4) {
        super(n2, n3, n4, n5, Color.BLACK, true);
        this.headerHeight = n6;
        this.rowHeight = n7;
        String string6 = this.title = string == null ? TITLE : string;
        if (this.title.equals("")) {
            this.title = TITLE;
        }
        this.titleFontName = string2;
        this.titleFontSize = n9;
        this.titleFontStyle = n8;
        this.isDesignMode = bl4;
        this.a(uCIVAInfoItemArray);
        this.fontName = string3;
        this.fontSize = n11;
        this.fontStyle = n10;
        this.showFootnote = bl;
        String string7 = this.footnote = string4 == null ? FOOTNOTE : string4;
        if (this.footnote.equals("")) {
            this.footnote = FOOTNOTE;
        }
        this.fnFontName = string5;
        this.fnFontSize = n13;
        this.fnFontStyle = n12;
        this.drawHLines = bl2;
        this.drawVLines = bl3;
        this.intLinesStroke = 2;
        this.outlineStroke = 2;
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int n2) {
        this.headerHeight = n2;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n2) {
        this.rowHeight = n2;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n2) {
        this.fontStyle = n2;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n2) {
        this.fontSize = n2;
    }

    public boolean isShowFootnote() {
        return this.showFootnote;
    }

    public void setShowFootnote(boolean bl) {
        this.showFootnote = bl;
    }

    public boolean isDrawHLines() {
        return this.drawHLines;
    }

    public void setDrawHLines(boolean bl) {
        this.drawHLines = bl;
    }

    public boolean isDrawVLines() {
        return this.drawVLines;
    }

    public void setDrawVLines(boolean bl) {
        this.drawVLines = bl;
    }

    public UCIVAInfoItem[] getItems() {
        return this.items;
    }

    private void a(UCIVAInfoItem[] uCIVAInfoItemArray) {
        if (uCIVAInfoItemArray == null) {
            if (!this.isDesignMode) {
                return;
            }
            uCIVAInfoItemArray = DEFAULT_DATA;
        }
        this.items = uCIVAInfoItemArray;
        this.a();
    }

    public void setItems(UCIVAInfoItem[] uCIVAInfoItemArray) {
        this.a(uCIVAInfoItemArray);
    }

    public String getTitleFontName() {
        return this.titleFontName;
    }

    public void setTitleFontName(String string) {
        this.titleFontName = string;
    }

    public int getTitleFontStyle() {
        return this.titleFontStyle;
    }

    public void setTitleFontStyle(int n2) {
        this.titleFontStyle = n2;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(int n2) {
        this.titleFontSize = n2;
    }

    public int getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(int n2) {
        this.outlineStroke = n2;
    }

    public int getIntLinesStroke() {
        return this.intLinesStroke;
    }

    public void setIntLinesStroke(int n2) {
        this.intLinesStroke = n2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    private void a() {
        this.rows = 0;
        if (this.items != null) {
            this.rows = this.items.length / 4;
        }
    }

    public String getFootnote() {
        return this.footnote;
    }

    public void setFootnote(String string) {
        this.footnote = string;
    }

    public String getFootnoteFontName() {
        return this.fnFontName;
    }

    public void setFootnoteFontName(String string) {
        this.fnFontName = string;
    }

    public int getFootnoteFontStyle() {
        return this.fnFontStyle;
    }

    public void setFootnoteFontStyle(int n2) {
        this.fnFontStyle = n2;
    }

    public int getFootnoteFontSize() {
        return this.fnFontSize;
    }

    public void setFootnoteFontSize(int n2) {
        this.fnFontSize = n2;
    }

    @Override
    public void draw(Graphics object) {
        int n2;
        int n3;
        Graphics2D graphics2D = (Graphics2D)object;
        object = new BasicStroke(this.outlineStroke);
        BasicStroke basicStroke = new BasicStroke(this.intLinesStroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(this.x, this.y, this.width, this.height);
        graphics2D.setColor(Color.black);
        if (this.drawHLines) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.drawLine(this.x, this.y, this.x + this.width, this.y);
            n3 = this.y + this.headerHeight;
            graphics2D.setStroke(basicStroke);
            for (n2 = 1; n2 < this.rows; ++n2) {
                int n4 = this.x;
                graphics2D.drawLine(n4, n3, n4 + this.width, n3);
                n3 += this.rowHeight;
            }
            graphics2D.setStroke((Stroke)object);
            int n5 = this.x;
            graphics2D.drawLine(n5, n3, n5 + this.width, n3);
        }
        if (this.drawVLines) {
            n3 = this.y + this.headerHeight + (this.rows - 1) * this.rowHeight;
            graphics2D.setStroke((Stroke)object);
            graphics2D.drawLine(this.x, this.y, this.x, n3);
            graphics2D.drawLine(this.x + this.width, this.y, this.x + this.width, n3);
            graphics2D.setStroke(basicStroke);
            for (n2 = 0; n2 < 4; ++n2) {
                int n6 = (int)((double)this.x + (double)this.width * a[n2]);
                graphics2D.drawLine(n6, this.y + this.headerHeight, n6, n3);
            }
        }
        UCText uCText = new UCText(this.x + this.outlineStroke + 1, this.y + this.outlineStroke + 1, this.width - 2 * (this.outlineStroke + 1), 1, null, this.title, this.titleFontName, this.titleFontStyle, this.titleFontSize, 2, this.color, 0, false, false);
        uCText.draw(graphics2D);
        UCIVAInfoItem[] uCIVAInfoItemArray = this.items;
        int n7 = this.items.length;
        for (int i2 = 0; i2 < n7; ++i2) {
            UCIVAInfoItem uCIVAInfoItem = uCIVAInfoItemArray[i2];
            int n8 = uCIVAInfoItem.col == 0 ? this.x : (int)((double)this.x + (double)this.width * a[uCIVAInfoItem.col - 1]);
            int n9 = this.isDesignMode ? (uCIVAInfoItem.row == 0 ? this.y + uCText.height + 15 : this.y + this.headerHeight + (uCIVAInfoItem.row - 1) * this.rowHeight) : (uCIVAInfoItem.row == 0 ? this.y + uCText.height + 3 : this.y + this.headerHeight + (uCIVAInfoItem.row - 1) * this.rowHeight);
            int n10 = uCIVAInfoItem.hasJoinedColumns && uCIVAInfoItem.colTo > uCIVAInfoItem.col ? (int)((double)this.x + (double)this.width * a[uCIVAInfoItem.colTo]) : (int)((double)this.x + (double)this.width * a[uCIVAInfoItem.col]);
            int n11 = uCIVAInfoItem.hasJoinedRows && uCIVAInfoItem.rowTo > uCIVAInfoItem.row && uCIVAInfoItem.row != 0 ? this.y + this.headerHeight + (uCIVAInfoItem.rowTo - 1) * this.rowHeight : (uCIVAInfoItem.row == 0 ? this.y + this.headerHeight : this.y + this.headerHeight + uCIVAInfoItem.row * this.rowHeight);
            int n12 = this.outlineStroke / 2 + 1;
            n8 += n12;
            n10 -= n12;
            n9 += n12;
            n11 -= n12;
            if ((uCIVAInfoItem.hasJoinedColumns || uCIVAInfoItem.hasJoinedRows) && uCIVAInfoItem.row != 0) {
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(n8, n9, n10 - n8, n11 - n9 + 1);
                graphics2D.setColor(Color.black);
            }
            uCText = new UCText(n8, n9, n10 - n8, n11 - n9, null, uCIVAInfoItem.value, this.fontName, this.fontStyle, this.fontSize, uCIVAInfoItem.alignment, this.color, 0, false, false);
            uCText.draw(graphics2D);
        }
        if (this.showFootnote) {
            int n13 = this.y + this.headerHeight + (this.rows - 1) * this.rowHeight + this.outlineStroke + 3;
            UCText uCText2 = new UCText(this.x, n13, this.width, 1, null, this.footnote, this.fnFontName, this.fnFontStyle, this.fnFontSize, 0, this.color, 0, false, false);
            uCText2.draw(graphics2D);
        }
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCIVAInfoTable\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<w>" + this.width + "</w>";
        string = string + "<h>" + this.height + "</h>";
        string = string + "<hh>" + this.headerHeight + "</hh>";
        string = string + "<rh>" + this.rowHeight + "</rh>";
        string = string + "<font>" + this.fontName + "</font>";
        string = string + "<style>" + this.fontStyle + "</style>";
        string = string + "<size>" + this.fontSize + "</size>";
        string = string + "<title>" + this.title + "</title>";
        string = string + "<title_font>" + this.titleFontName + "</title_font>";
        string = string + "<title_style>" + this.titleFontStyle + "</title_style>";
        string = string + "<title_size>" + this.titleFontSize + "</title_size>";
        string = string + "<show_footnote>" + this.showFootnote + "</show_footnote>";
        string = string + "<footnote>" + this.footnote + "</footnote>";
        string = string + "<footnote_font>" + this.fnFontName + "</footnote_font>";
        string = string + "<footnote_style>" + this.fnFontStyle + "</footnote_style>";
        string = string + "<footnote_size>" + this.fnFontSize + "</footnote_size>";
        string = string + "<vlines>" + this.drawVLines + "</vlines>";
        string = string + "<hlines>" + this.drawHLines + "</hlines>";
        string = string + "<outline>" + this.outlineStroke + "</outline>";
        string = string + "<stroke>" + this.intLinesStroke + "</stroke>";
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public String getName() {
        return "UCIVAInfoTable";
    }
}

