/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.BarcodeErrorListener;
import com.systel.print.Config;
import com.systel.print.Field;
import com.systel.print.PrinterMargins;
import com.systel.print.UCShape;
import com.systel.print.UCText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class UCFixData
extends UCShape {
    public static final String TITLE_WEIGHT = ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("PESO");
    public static final String TITLE_TARE = ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString("TARA");
    private final boolean antiAlias;
    private final List errorListeners = new LinkedList();
    protected String fontName;
    protected int fontSize;
    protected int fontStyle;
    protected String title_weight;
    protected String title_tare;
    protected String data_weight = "";
    protected String data_tare = "";
    protected String unimedi = "";
    protected Field field_weight;
    protected Field field_tare;
    protected int envWidth;
    protected int envHeight;
    protected PrinterMargins margins;
    protected int outlineStroke;
    protected boolean isDesignMode;

    public PrinterMargins getMargins() {
        return this.margins;
    }

    public void setMargins(PrinterMargins printerMargins) {
        this.margins = printerMargins;
    }

    public int getEnvWidth() {
        return this.envWidth;
    }

    public void setEnvWidth(int n2) {
        this.envWidth = n2;
    }

    public int getEnvHeight() {
        return this.envHeight;
    }

    public void setEnvHeight(int n2) {
        this.envHeight = n2;
    }

    public Field getField_weight() {
        return this.field_weight;
    }

    public void setField_weight(Field field) {
        this.field_weight = field;
    }

    public Field getField_tare() {
        return this.field_tare;
    }

    public void setField_tare(Field field) {
        this.field_tare = field;
    }

    public String getData_weight() {
        return this.data_weight;
    }

    public void setData_weight(String string) {
        this.data_weight = string;
    }

    public String getData_tare() {
        return this.data_tare;
    }

    public void setData_tare(String string) {
        this.data_tare = string;
    }

    UCFixData(int n2, int n3, int n4, int n5, Field field, Field field2, String string, int n6, int n7, int n8, boolean bl, String string2, int n9, int n10, PrinterMargins printerMargins) {
        super(n2, n3, n4, n5, Color.RED, true);
        this.fontSize = n7;
        this.fontStyle = n6;
        this.fontName = string;
        this.title_weight = TITLE_WEIGHT;
        this.title_tare = TITLE_TARE;
        this.field_weight = field;
        this.field_tare = field2;
        this.isDesignMode = bl;
        this.fontName = string;
        this.fontSize = n7;
        this.fontStyle = n6;
        this.envWidth = n9;
        this.envHeight = n10;
        this.margins = printerMargins;
        if (string2.isEmpty()) {
            string2 = "kg";
        }
        if (this.data_weight.isEmpty()) {
            this.data_weight = "12,123 " + string2 + " (N)";
        }
        if (this.data_tare.isEmpty()) {
            this.data_tare = "1,234 " + string2 + " (T)";
        }
        this.outlineStroke = 2;
        this.antiAlias = false;
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCFixData\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<w>" + this.width + "</w>";
        string = string + "<h>" + this.height + "</h>";
        string = string + "<font>" + this.fontName + "</font>";
        string = string + "<style>" + this.fontStyle + "</style>";
        string = string + "<size>" + this.fontSize + "</size>";
        string = string + "<text>" + TITLE_WEIGHT + "</text>";
        string = string + "<field>" + Config.FIELDS.indexOf(this.field_weight) + "</field>";
        string = string + "<text>" + TITLE_TARE + "</text>";
        string = string + "<field>" + Config.FIELDS.indexOf(this.field_tare) + "</field>";
        string = string + "<outline>" + this.outlineStroke + "</outline>";
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public String getName() {
        return "UCFixData";
    }

    public void addErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.add(barcodeErrorListener);
    }

    public void removeErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.remove(barcodeErrorListener);
    }

    public void fireSuccessNotification() {
        Iterator iterator = this.errorListeners.iterator();
        while (iterator.hasNext()) {
            ((BarcodeErrorListener)iterator.next()).notifySuccess();
        }
    }

    public void fireErrorNotification(Exception exception) {
        Iterator iterator = this.errorListeners.iterator();
        while (iterator.hasNext()) {
            ((BarcodeErrorListener)iterator.next()).notifyException(exception);
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n2) {
        this.fontStyle = n2;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n2) {
        this.fontSize = n2;
    }

    public int getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(int n2) {
        this.outlineStroke = n2;
    }

    @Override
    public void draw(Graphics object) {
        Graphics2D graphics2D = (Graphics2D)object;
        object = new BasicStroke(this.outlineStroke);
        PrinterMargins printerMargins = this.getMargins();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        this.width = this.getFontSize() * 10;
        this.height = this.getFontSize() * 3 + 3;
        if (this.x < printerMargins.getLeft()) {
            this.x = printerMargins.getLeft();
        }
        if (this.x + this.width + printerMargins.getRight() > this.envWidth) {
            this.x = this.envWidth - this.width;
        }
        if (this.y < printerMargins.getTop()) {
            this.y = printerMargins.getTop();
        }
        if (this.y + this.height > this.envHeight) {
            this.y = this.envHeight - this.height;
        }
        if (this.x < 0) {
            this.x = printerMargins.getLeft();
        }
        if (this.y < 0) {
            this.y = printerMargins.getTop();
        }
        graphics2D.fillRect(this.x, this.y, this.width, this.height);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke((Stroke)object);
        graphics2D.drawLine(this.x, this.y, this.x + this.width, this.y);
        int n2 = this.y + this.height;
        graphics2D.setStroke((Stroke)object);
        int n3 = this.x;
        graphics2D.drawLine(n3, n2, n3 + this.width, n2);
        n2 = this.y + this.height;
        graphics2D.setStroke((Stroke)object);
        graphics2D.drawLine(this.x, this.y, this.x, n2);
        int n4 = this.x + this.width;
        graphics2D.drawLine(n4, this.y, n4, n2);
        UCText uCText = new UCText(this.x + this.outlineStroke + 1, this.y + this.outlineStroke + 1, this.width - 2 * (this.outlineStroke + 1), 1, null, TITLE_WEIGHT, this.fontName, this.fontStyle, this.fontSize, 0, this.color, 0, false, false);
        uCText.draw(graphics2D);
        uCText = new UCText(this.x + this.outlineStroke + 1, this.y + this.outlineStroke + 1, this.width - 2 * (this.outlineStroke + 1), 1, null, this.data_weight, this.fontName, this.fontStyle, this.fontSize, 1, this.color, 0, false, false);
        uCText.draw(graphics2D);
        uCText = new UCText(this.x + this.outlineStroke + 1, this.y + this.outlineStroke + this.height / 2, this.width - 2 * (this.outlineStroke + 1), 1, null, TITLE_TARE, this.fontName, this.fontStyle, this.fontSize, 0, this.color, 0, false, false);
        uCText.draw(graphics2D);
        uCText = new UCText(this.x + this.outlineStroke + 1, this.y + this.outlineStroke + this.height / 2, this.width - 2 * (this.outlineStroke + 1), 1, null, this.data_tare, this.fontName, this.fontStyle, this.fontSize, 1, this.color, 0, false, false);
        uCText.draw(graphics2D);
    }
}

