/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.BarcodeErrorListener;
import com.systel.print.BarcodeType;
import com.systel.print.Config;
import com.systel.print.Field;
import com.systel.print.UCShape;
import com.systel.print.editor.TemplateEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixBean;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.impl.upcean.UPCEBean;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class UCBarcode
extends UCShape {
    public static final double dotSizeMM = 0.125;
    public static final double dpi = 203.2;
    public static final double MODULE_WIDTH = 0.25;
    public static final int BAR_HEIGHT = 10;
    private String value;
    private AbstractBarcodeBean bean;
    private ITF14Bean beanITF14;
    private BarcodeType barcode;
    private int orientation;
    private double moduleWidth;
    private int barHeight;
    private Field field;
    private BitmapCanvasProvider canvas;
    private final boolean antiAlias;
    private final List errorListeners = new LinkedList();

    UCBarcode(int n2, int n3, Field field, String string, int n4, double d2, int n5, int n6) {
        super(n2, n3, 0, 0, Color.BLACK, false);
        this.field = field;
        this.value = string;
        this.orientation = n4;
        this.moduleWidth = d2;
        this.barHeight = n5;
        this.setBarcode(new BarcodeType(n6));
        if (this.barcode.getId() == 6) {
            this.beanITF14.setModuleWidth(d2 / 2.0);
            this.beanITF14.doQuietZone(true);
            this.beanITF14.setBarHeight(n5);
            this.beanITF14.setBearerBarWidth(1.0);
        } else {
            this.bean.setModuleWidth(d2);
            this.bean.doQuietZone(true);
            this.bean.setBarHeight(n5);
        }
        this.antiAlias = false;
    }

    @Override
    public String toXml() {
        String string = "<UCShape type=\"UCBarcode\">";
        string = string + "<x>" + this.x + "</x>";
        string = string + "<y>" + this.y + "</y>";
        string = string + "<value>" + this.value + "</value>";
        string = string + "<ori>" + this.orientation + "</ori>";
        string = string + "<mw>" + this.moduleWidth + "</mw>";
        string = string + "<bh>" + this.barHeight + "</bh>";
        string = string + "<bc>" + this.barcode.getId() + "</bc>";
        if (this.field != null) {
            string = string + "<field>" + Config.BARCODE_FIELDS.indexOf(this.field) + "</field>";
        }
        string = string + "</UCShape>";
        return string;
    }

    @Override
    public void draw(Graphics graphics) {
        BarcodeDimension barcodeDimension;
        block10: {
            if (this.value == "0000000000000") {
                return;
            }
            if (this.barcode.getId() == 6) {
                this.beanITF14.setHeight(this.barHeight + 5);
                this.beanITF14.setBearerBarWidth(0.0);
                this.beanITF14.setBearerBox(false);
                this.beanITF14.setFontSize(this.moduleWidth * 11.0);
            } else {
                if (this.barcode.getId() == 1) {
                    this.bean.setFontSize(2.49);
                }
                this.bean.setHeight(this.barHeight);
            }
            graphics.setColor(this.color);
            this.canvas = new BitmapCanvasProvider(203, 12, this.antiAlias, this.orientation);
            try {
                if (this.barcode.getId() == 6) {
                    this.beanITF14.generateBarcode(this.canvas, this.value);
                } else {
                    this.bean.generateBarcode(this.canvas, this.value);
                }
                this.fireSuccessNotification();
            }
            catch (Exception exception) {
                this.fireErrorNotification(exception);
                return;
            }
            new BarcodeDimension(1.0, 1.0);
            barcodeDimension = this.barcode.getId() == 6 ? this.beanITF14.calcDimensions(this.value) : this.bean.calcDimensions(this.value);
            try {
                this.canvas.finish();
            }
            catch (IOException iOException) {
                if (TemplateEditor.isRunInPc) break block10;
                Logger.getLogger(UCBarcode.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        BufferedImage bufferedImage = this.canvas.getBufferedImage();
        this.width = bufferedImage.getWidth();
        this.height = (int)(barcodeDimension.getHeight() * 8.0);
        graphics.drawImage(bufferedImage, this.x, this.y, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
    }

    @Override
    public String getName() {
        return "UCBarcode";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public BarcodeType getBarcode() {
        return this.barcode;
    }

    public void setBarcode(BarcodeType barcodeType) {
        this.barcode = barcodeType;
        switch (this.barcode.getId()) {
            case 11: {
                this.bean = new CodabarBean();
                return;
            }
            case 1: {
                this.bean = new Code128Bean();
                return;
            }
            case 2: {
                this.bean = new EAN128Bean();
                return;
            }
            case 3: {
                this.bean = new Code39Bean();
                return;
            }
            case 4: {
                this.bean = new DataMatrixBean();
                return;
            }
            case 5: {
                this.bean = new Interleaved2Of5Bean();
                return;
            }
            case 6: {
                this.beanITF14 = new ITF14Bean();
                this.beanITF14.setChecksumMode(ChecksumMode.CP_IGNORE);
                return;
            }
            case 7: {
                this.bean = new PDF417Bean();
                return;
            }
            case 8: {
                this.bean = new EAN8Bean();
                ((EAN8Bean)this.bean).setChecksumMode(ChecksumMode.CP_IGNORE);
                return;
            }
            case 9: {
                this.bean = new UPCABean();
                return;
            }
            case 10: {
                this.bean = new UPCEBean();
                ((UPCEBean)this.bean).setChecksumMode(ChecksumMode.CP_IGNORE);
            }
            case 0: {
                this.bean = new EAN13Bean();
                ((EAN13Bean)this.bean).setChecksumMode(ChecksumMode.CP_IGNORE);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
        this.canvas = new BitmapCanvasProvider(203, 12, this.antiAlias, n2);
    }

    public double getModuleWith() {
        return this.moduleWidth;
    }

    public void setModuleWith(double d2) {
        this.moduleWidth = d2;
        if (this.barcode.getId() == 6) {
            this.beanITF14.setModuleWidth(d2 / 1.5);
            return;
        }
        this.bean.setModuleWidth(d2);
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int n2) {
        this.barHeight = n2;
        if (this.barcode.getId() == 6) {
            this.beanITF14.setBarHeight((double)n2 + 5.0);
            return;
        }
        this.bean.setBarHeight(n2);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void addErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.add(barcodeErrorListener);
    }

    public void removeErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.remove(barcodeErrorListener);
    }

    public void fireSuccessNotification() {
        Iterator iterator = this.errorListeners.iterator();
        while (iterator.hasNext()) {
            ((BarcodeErrorListener)iterator.next()).notifySuccess();
        }
    }

    public void fireErrorNotification(Exception exception) {
        Iterator iterator = this.errorListeners.iterator();
        while (iterator.hasNext()) {
            ((BarcodeErrorListener)iterator.next()).notifyException(exception);
        }
    }
}

