/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.Field;
import com.systel.print.PrinterMargins;
import com.systel.print.Template;
import com.systel.print.UCFixData;
import com.systel.print.UCShape;
import com.systel.print.a;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class UCBand
extends UCShape {
    private final List<UCShape> shapes;
    private BandType type;
    private boolean addUCFixData = false;

    public UCBand(BandType bandType, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5, Color.BLACK, true);
        this.x = n2;
        this.y = n3;
        this.height = n5;
        this.width = n4;
        this.type = bandType;
        this.shapes = new ArrayList<UCShape>();
    }

    public UCBand(BandType object, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5, Color.BLACK, true);
        this.x = n2;
        this.y = n3;
        this.height = n5;
        this.width = n4;
        this.type = object;
        this.addUCFixData = bl;
        this.shapes = new ArrayList<UCShape>();
        if (this.addUCFixData) {
            object = new UCFixData(0, 0, 180, 57, new Field(18, "system", "weight", "weight"), new Field(10, "system", "tare", "tare"), "Malgun Gothic", 0, 18, 2, false, "kg", 100, 100, new PrinterMargins(0, 0, 0, 0));
            this.addShape((UCShape)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setX(int n2) {
        int n3 = n2 - this.x;
        this.x = n2;
        List<UCShape> list = this.shapes;
        synchronized (list) {
            this.shapes.stream().forEach(uCShape -> uCShape.x += n3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setY(int n2) {
        int n3 = n2 - this.y;
        this.y = n2;
        List<UCShape> list = this.shapes;
        synchronized (list) {
            this.shapes.stream().forEach(uCShape -> uCShape.y += n3);
            return;
        }
    }

    public synchronized UCShape[] getShapeList() {
        return this.shapes.toArray(new UCShape[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShape(UCShape uCShape) {
        if (uCShape == null) {
            return;
        }
        List<UCShape> list = this.shapes;
        synchronized (list) {
            this.shapes.add(uCShape);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShape(UCShape uCShape) {
        if (uCShape == null) {
            return;
        }
        List<UCShape> list = this.shapes;
        synchronized (list) {
            if (this.shapes.contains(uCShape)) {
                this.shapes.remove(uCShape);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShapeAtIndex(int n2) {
        List<UCShape> list = this.shapes;
        synchronized (list) {
            if (n2 >= 0 && n2 < this.shapes.size()) {
                try {
                    this.shapes.remove(n2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    IndexOutOfBoundsException indexOutOfBoundsException2 = indexOutOfBoundsException;
                    throw indexOutOfBoundsException;
                }
            } else {
                throw new IndexOutOfBoundsException();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXml() {
        String string = "";
        String string2 = "<UCShape type=\"UCBand\">";
        string2 = string2 + "<bandType>" + this.type.getName() + "</bandType>";
        string2 = string2 + "<x>" + this.x + "</x>";
        string2 = string2 + "<y>" + this.y + "</y>";
        string2 = string2 + "<w>" + this.width + "</w>";
        string2 = string2 + "<h>" + this.height + "</h>";
        List<UCShape> list = this.shapes;
        synchronized (list) {
            for (UCShape uCShape : this.shapes) {
                if (uCShape instanceof UCFixData) {
                    string = uCShape.toXml();
                    continue;
                }
                string2 = string2.concat(uCShape.toXml());
            }
            if (!string.isEmpty()) {
                string2 = string2.concat(string);
            }
        }
        string2 = string2.concat("</UCShape>");
        return string2;
    }

    @Override
    public void draw(Graphics graphics) {
        this.draw(graphics, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(Graphics graphics, Template object) {
        int n2;
        int n3;
        int n4;
        int n5;
        void var4_12;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (object == null) {
            if (BandType.HEADER.equals((Object)this.type)) {
                PrinterMargins object22 = new PrinterMargins(0, 0, 0, 0);
                object = Template.TemplateType.LABEL;
            } else {
                PrinterMargins printerMargins = new PrinterMargins(0, 0, 0, 0, 0);
                object = Template.TemplateType.TICKET;
            }
        } else {
            PrinterMargins printerMargins = object.getMargins();
            object = object.getType();
        }
        graphics.setColor(new Color(221, 221, 221));
        graphics.fillRect(this.x, this.y, this.width, this.height);
        if (BandType.HEADERLEGAL.equals((Object)this.type)) {
            graphics2D.setColor(new Color(255, 255, 255));
            n5 = this.x + var4_12.getLeft();
            n4 = this.y + var4_12.getTopLegal();
            n3 = this.width - var4_12.getLeft() - var4_12.getRight();
            n2 = this.height - var4_12.getTopLegal();
        } else if (BandType.HEADER.equals((Object)this.type)) {
            graphics2D.setColor(new Color(255, 255, 255));
            n5 = this.x + var4_12.getLeft();
            n4 = this.y + var4_12.getTop();
            n3 = this.width - var4_12.getLeft() - var4_12.getRight();
            n2 = Template.TemplateType.LABEL.equals(object) ? this.height - var4_12.getTop() - var4_12.getBottom() : this.height - var4_12.getTop();
        } else if (BandType.DETAIL.equals((Object)this.type)) {
            graphics2D.setColor(new Color(240, 200, 160));
            n5 = this.x + var4_12.getLeft();
            n4 = this.y;
            n3 = this.width - var4_12.getLeft() - var4_12.getRight();
            n2 = this.height;
        } else {
            graphics2D.setColor(new Color(255, 255, 255));
            n5 = this.x + var4_12.getLeft();
            n4 = this.y;
            n3 = this.width - var4_12.getLeft() - var4_12.getRight();
            n2 = this.height - var4_12.getBottom();
        }
        graphics2D.fillRect(n5, n4, n3, n2);
        List<UCShape> list = this.shapes;
        synchronized (list) {
            for (UCShape uCShape : this.shapes) {
                uCShape.draw(graphics2D);
                if (!uCShape.isSelected()) continue;
                uCShape.highlight(graphics2D);
            }
            return;
        }
    }

    public BandType getType() {
        return this.type;
    }

    public void setType(BandType bandType) {
        this.type = bandType;
    }

    @Override
    public String getName() {
        return "UCBand";
    }

    public static BandType strToBandType(String string) {
        if (BandType.DETAIL.getName().equals(string)) {
            return BandType.DETAIL;
        }
        if (BandType.FOOTER.getName().equals(string)) {
            return BandType.FOOTER;
        }
        if (BandType.HEADER.getName().equals(string)) {
            return BandType.HEADER;
        }
        if (BandType.HEADERLEGAL.getName().equals(string)) {
            return BandType.HEADERLEGAL;
        }
        return null;
    }

    public static enum BandType {
        HEADERLEGAL{

            @Override
            public final String getName() {
                return "HeaderLegal";
            }
        }
        ,
        HEADER{

            @Override
            public final String getName() {
                return "Header";
            }
        }
        ,
        DETAIL{

            @Override
            public final String getName() {
                return "Detail";
            }
        }
        ,
        FOOTER{

            @Override
            public final String getName() {
                return "Footer";
            }
        };


        private BandType() {
        }

        public abstract String getName();

        /* synthetic */ BandType(String string, int n2, a a2) {
            this();
        }
    }
}

