/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.BarcodeErrorListener;
import com.systel.print.Config;
import com.systel.print.DrawEnv;
import com.systel.print.DrawListener;
import com.systel.print.DrawingSelectionEvent;
import com.systel.print.PrinterMargins;
import com.systel.print.Template;
import com.systel.print.TemplatePage;
import com.systel.print.UCBand;
import com.systel.print.UCBarcode;
import com.systel.print.UCFixData;
import com.systel.print.UCImage;
import com.systel.print.UCLine;
import com.systel.print.UCNutInfoRotulo;
import com.systel.print.UCNutInfoTable;
import com.systel.print.UCOval;
import com.systel.print.UCQrCode;
import com.systel.print.UCRect;
import com.systel.print.UCRegPolygon;
import com.systel.print.UCShape;
import com.systel.print.UCText;
import com.systel.print.editor.ByteaToImageConverter;
import com.systel.print.editor.TemplateEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class DrawingPanel
extends JPanel
implements BarcodeErrorListener,
MouseListener,
MouseMotionListener {
    int x1 = -1;
    int y1 = -1;
    int x2 = -1;
    int y2 = -1;
    int xPoiter = 0;
    int yPoiter = 0;
    int xori = -1;
    int yori = -1;
    String op = "CMD_SELECT";
    Font defaultFont = null;
    UCShape selectedShape = null;
    UCShape copyShape = null;
    DrawEnv drawEnv;
    private final List errorListeners;
    private final List drawListeners;
    private final PrinterMargins margins;
    private int templateHeight;
    private int templateWidth;
    private final TemplatePage page;
    private final Template.TemplateType ttype;
    private Template template;
    private UCBand header = null;
    private UCBand detail = null;
    private UCBand footer = null;
    private boolean drag = false;
    private boolean isTkt = false;

    public DrawingPanel(DrawEnv object, TemplatePage object2, boolean bl) {
        if (object == null) {
            throw new Exception("The environment variables object can't be null");
        }
        if (object2 == null) {
            throw new Exception("The page template can't be null");
        }
        this.page = object2;
        this.drawEnv = object;
        this.isTkt = bl;
        this.drawEnv.setIsTkt(this.isTkt);
        this.errorListeners = new LinkedList();
        this.drawListeners = new LinkedList();
        this.template = ((TemplatePage)object2).getParent();
        if (this.template == null) {
            throw new Exception("The page template can't be orphan");
        }
        this.margins = this.template.getMargins();
        this.ttype = this.template.getType();
        this.header = ((TemplatePage)object2).getHeader();
        this.templateHeight = this.header.getHeight();
        this.templateWidth = this.header.getWidth();
        if (Template.TemplateType.TICKET.equals((Object)this.ttype)) {
            this.detail = ((TemplatePage)object2).getDetail();
            this.footer = ((TemplatePage)object2).getFooter();
            this.templateHeight += this.detail.getHeight();
            this.templateHeight += this.footer.getHeight();
        }
        object = this;
        object2 = new GroupLayout((Container)object);
        ((Container)object).setLayout((LayoutManager)object2);
        Object object3 = object2;
        ((GroupLayout)object3).setHorizontalGroup(((GroupLayout)object3).createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 448, Short.MAX_VALUE));
        Object object4 = object2;
        ((GroupLayout)object4).setVerticalGroup(((GroupLayout)object4).createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1680, Short.MAX_VALUE));
        DrawingPanel drawingPanel = this;
        drawingPanel.addMouseListener(drawingPanel);
        DrawingPanel drawingPanel2 = this;
        drawingPanel2.addMouseMotionListener(drawingPanel2);
    }

    public UCBand getHeader() {
        return this.header;
    }

    public UCBand getDetail() {
        return this.detail;
    }

    public UCBand getFooter() {
        return this.footer;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.x1 = mouseEvent.getX();
        this.xori = mouseEvent.getX();
        this.y1 = mouseEvent.getY();
        this.yori = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.drag) {
            this.drag = false;
            return;
        }
        if (this.op.equals("CMD_SELECT")) {
            this.selectShape();
        } else {
            this.a(false, null);
        }
        this.repaint();
        this.x1 = -1;
        this.x2 = -1;
        this.y1 = -1;
        this.y2 = -1;
    }

    private void a(boolean bl, Graphics graphics) {
        int n2;
        int n3;
        UCBand uCBand;
        UCShape uCShape;
        int n4;
        Color color;
        block51: {
            color = this.drawEnv.getForeground();
            n4 = this.drawEnv.getStrokeSize();
            uCShape = null;
            if (this.x1 == -1 || this.y1 == -1 || this.x2 == -1 || this.y1 == -1) {
                return;
            }
            uCBand = Template.TemplateType.TICKET.equals((Object)this.ttype) && !this.header.hasXY(this.x1, this.y1) ? (this.detail.hasXY(this.x1, this.y1) ? this.detail : this.footer) : this.header;
            if (this.x2 < this.x1) {
                n3 = this.x2;
                this.x2 = this.xori;
                this.x1 = n3;
            }
            if (this.y2 < this.y1) {
                n3 = this.y2;
                this.y2 = this.yori;
                this.y1 = n3;
            }
            n3 = Math.abs(this.x2 - this.x1);
            n2 = Math.abs(this.y2 - this.y1);
            if (this.op.equals("CMD_DRAW_RECTANGLE") || this.op.equals("CMD_FILL_RECTANGLE")) {
                uCShape = new UCRect(this.x1, this.y1, n3, n2, n4, color, this.op.equals("CMD_DRAW_RECTANGLE"), 0, 0);
                if (bl) {
                    uCShape.draw(graphics);
                } else {
                    uCBand.addShape(uCShape);
                }
            }
            if (this.op.equals("CMD_DRAW_ROUND_RECT") || this.op.equals("CMD_FILL_ROUND_RECT")) {
                uCShape = new UCRect(this.x1, this.y1, n3, n2, n4, color, this.op.equals("CMD_DRAW_ROUND_RECT"), this.drawEnv.getRoundRectCorner(), this.drawEnv.getRoundRectCorner());
                if (bl) {
                    uCShape.draw(graphics);
                } else {
                    uCBand.addShape(uCShape);
                }
            }
            if (this.op.equals("CMD_DRAW_OVAL") || this.op.equals("CMD_FILL_OVAL")) {
                uCShape = new UCOval(this.x1, this.y1, n3, n2, n4, color, this.op.equals("CMD_DRAW_OVAL"));
                if (bl) {
                    uCShape.draw(graphics);
                } else {
                    uCBand.addShape(uCShape);
                }
            }
            try {
                if (this.op.equals("CMD_DRAW_IMAGE")) {
                    if (!Config.IMAGE_FIELDS.get(0).equals(this.drawEnv.getImageField()) && !Config.IMAGE_FIELDS.get(15).equals(this.drawEnv.getImageField())) {
                        uCShape = new UCImage(this.x1, this.y1, null, n3, n2, color, Config.getImage("com/ucod/images/i48/image_file-48.png"));
                        ((UCImage)uCShape).setImg(Config.getImage("com/ucod/images/i48/image_file-48.png"));
                    } else if (Config.IMAGE_FIELDS.get(15).equals(this.drawEnv.getImageField())) {
                        uCShape = new UCImage(this.x1, this.y1, this.drawEnv.getImageField(), n3, n2, color, ByteaToImageConverter.getInstance().convertForward(this.drawEnv.getImageSelected().getBinarydata()).getImage());
                        ((UCImage)uCShape).setImg(ByteaToImageConverter.getInstance().convertForward(this.drawEnv.getImageSelected().getBinarydata()).getImage());
                    } else {
                        uCShape = new UCImage(this.x1, this.y1, this.drawEnv.getImageField(), n3, n2, color, Config.getImage("com/ucod/images/i48/image_file-48.png"));
                        ((UCImage)uCShape).setImg(Config.getImage("com/ucod/images/i48/image_file-48.png"));
                    }
                    if (bl) {
                        uCShape.draw(graphics);
                    } else {
                        uCBand.addShape(uCShape);
                    }
                }
            }
            catch (Exception exception) {
                if (TemplateEditor.isRunInPc) break block51;
                Logger.getLogger(DrawingPanel.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        if (this.op.equals("CMD_DRAW_BARCODE") && !bl) {
            uCShape = new UCBarcode(this.x1, this.y1, this.drawEnv.getBarcodeField(), this.drawEnv.getBarcodeValue(), this.drawEnv.getBcAngle(), this.drawEnv.getBcModuleWidth(), this.drawEnv.getBcBarHeight(), this.drawEnv.getBarcodeType());
            uCBand.addShape(uCShape);
            ((UCBarcode)uCShape).addErrorListener(this);
        }
        if (this.op.equals("CMD_DRAW_FIXDATA") && !bl) {
            uCShape = new UCFixData(this.x1, this.y1, n3, n2, this.drawEnv.getFieldWeight(), this.drawEnv.getFieldTare(), this.drawEnv.getFontName(), this.drawEnv.getFontStyle(), this.drawEnv.getFontSize(), this.drawEnv.getOutlineStroke(), true, this.drawEnv.getUnimedi(), this.templateWidth, this.templateHeight, this.margins);
            if (bl) {
                uCShape.draw(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (this.op.equals("CMD_DRAW_LINE")) {
            uCShape = new UCLine(this.x1, this.y1, this.x2, this.y2, n4, color);
            if (bl) {
                uCShape.draw(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (this.op.equals("CMD_DRAW_POLYGON") || this.op.equals("CMD_FILL_POLYGON")) {
            uCShape = new UCRegPolygon(this.x1, this.y1, this.x2, this.y2, this.drawEnv.getPolygonPoints(), n4, color, this.op.equals("CMD_DRAW_POLYGON"));
            if (bl) {
                uCShape.draw(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (this.op.equals("CMD_DRAW_TEXT")) {
            uCShape = this.drawEnv.getField() == null ? new UCText(this.x1, this.y1, n3, n2, null, this.drawEnv.getText(), this.drawEnv.getFontName(), this.drawEnv.getFontStyle(), this.drawEnv.getFontSize(), this.drawEnv.getFontAlignment(), color, this.drawEnv.getFontInvert(), this.drawEnv.getIsTkt(), true) : new UCText(this.x1, this.y1, n3, n2, this.drawEnv.getField(), this.drawEnv.getText(), this.drawEnv.getFontName(), this.drawEnv.getFontStyle(), this.drawEnv.getFontSize(), this.drawEnv.getFontAlignment(), color, this.drawEnv.getFontInvert(), this.drawEnv.getIsTkt(), true);
            if (bl) {
                uCShape.preview(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (this.op.equals("CMD_DRAW_TABLE")) {
            uCShape = new UCNutInfoTable(this.x1, this.y1, n3, n2, this.drawEnv.getHeaderHeight(), this.drawEnv.getRowHeight(), this.drawEnv.getTitleNutInfo(), this.drawEnv.getTitleFontName(), this.drawEnv.getTitleFontStyle(), this.drawEnv.getTitleFontSize(), null, this.drawEnv.getNutTableItemFontName(), this.drawEnv.getNutTableItemFontStyle(), this.drawEnv.getNutTableItemFontSize(), this.drawEnv.isFootnoteVisible(), this.drawEnv.getFootnoteNutInfo(), this.drawEnv.getFnFontName(), this.drawEnv.getFnFontStyle(), this.drawEnv.getFnFontSize(), this.drawEnv.areHLinesVisible(), this.drawEnv.areVLinesVisible(), this.drawEnv.getOutlineStroke(), this.drawEnv.getStrokeSize(), true, "1");
            if (bl) {
                uCShape.draw(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (this.op.equals("CMD_DRAW_ROTULO")) {
            try {
                if (Config.REGION.equalsIgnoreCase("BRASIL")) {
                    uCShape = new UCNutInfoRotulo(this.x1, this.y1, null, n3, n2, color, Config.TipoTablaNut.BRA_LEF_RDC_N_429_ANVISA_2.getType(), 0, 7, DrawingPanel.a("com/systel/resources/etiquetadoFrontalBR/brHorizontal.png"), 0, n3, n2);
                    ((UCNutInfoRotulo)uCShape).setImg(DrawingPanel.a("com/systel/resources/etiquetadoFrontalBR/brHorizontal.png"));
                } else if (Config.REGION.equalsIgnoreCase("MEXICO")) {
                    uCShape = new UCNutInfoRotulo(this.x1, this.y1, null, n3, n2, color, Config.TipoTablaNut.MEX_LEF_NOM_051_SCFI_SSA1_2010_4.getType(), 0, 7, DrawingPanel.a("com/systel/resources/etiquetadoFrontalMX/full.png"), 0, n3, n2);
                    ((UCNutInfoRotulo)uCShape).setImg(DrawingPanel.a("com/systel/resources/etiquetadoFrontalMX/full.png"));
                } else {
                    uCShape = new UCNutInfoRotulo(this.x1, this.y1, null, n3, n2, color, Config.TipoTablaNut.ARG_LEF_Ley_N_27642_OCTOGONOS_3.getType(), 0, 7, DrawingPanel.a("com/systel/resources/etiquetadoFrontalAR/full.png"), 0, n3, n2);
                    ((UCNutInfoRotulo)uCShape).setImg(DrawingPanel.a("com/systel/resources/etiquetadoFrontalAR/full.png"));
                }
                if (bl) {
                    uCShape.draw(graphics);
                } else {
                    uCBand.addShape(uCShape);
                }
            }
            catch (Exception exception) {}
        }
        if (this.op.equals("CMD_DRAW_QR")) {
            uCShape = new UCQrCode(this.x1, this.y1, n3, this.drawEnv.getBarcodeValue());
            if (bl) {
                uCShape.draw(graphics);
            } else {
                uCBand.addShape(uCShape);
            }
        }
        if (!this.op.equals("CMD_SELECT") && !bl && uCShape != null) {
            this.op = "CMD_SELECT";
            uCShape.select();
            this.selectedShape = uCShape;
            this.fireDrawNotification(uCShape);
            DrawingPanel drawingPanel = this;
            drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
        }
        if (graphics != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics.setColor(Color.BLUE);
            graphics2D.drawLine(this.xPoiter, this.yPoiter, 0, this.yPoiter);
            graphics2D.drawLine(this.xPoiter, this.yPoiter, this.xPoiter, 0);
            graphics2D.drawLine(this.xPoiter, this.yPoiter, this.xPoiter + this.getWidth(), this.yPoiter);
            graphics2D.drawLine(this.xPoiter, this.yPoiter, this.xPoiter, this.yPoiter + this.getHeight());
        }
    }

    private static Image a(String object) {
        object = UCNutInfoRotulo.class.getClassLoader().getResource((String)object);
        try {
            return ImageIO.read((URL)object);
        }
        catch (IOException iOException) {
            if (!TemplateEditor.isRunInPc) {
                Logger.getLogger(DrawingPanel.class.getName()).log(Level.SEVERE, null, iOException);
            }
            return null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.op.equals("CMD_SELECT")) {
            this.drag = true;
        }
        this.x2 = mouseEvent.getX();
        this.y2 = mouseEvent.getY();
        this.xPoiter = mouseEvent.getX();
        this.yPoiter = mouseEvent.getY();
        int n2 = Math.abs(this.x2 - this.x1);
        int n3 = Math.abs(this.y2 - this.y1);
        DrawingPanel drawingPanel = this;
        drawingPanel.dragShape(drawingPanel.x2, this.y2, n2, n3);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.xPoiter = mouseEvent.getX();
        this.yPoiter = mouseEvent.getY();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            if (this.defaultFont == null) {
                this.defaultFont = graphics.getFont();
            }
            graphics.setColor(new Color(221, 221, 221));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (Template.TemplateType.TICKET.equals((Object)this.ttype)) {
                this.header.draw(graphics, this.template);
                this.detail.draw(graphics, this.template);
                this.footer.draw(graphics, this.template);
            } else {
                this.header.height = this.template.getPageLen();
                this.header.draw(graphics, this.template);
            }
            this.a(true, graphics);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void deselectAll() {
        for (UCShape uCShape : this.header.getShapeList()) {
            uCShape.deselect();
        }
        if (Template.TemplateType.TICKET.equals((Object)this.ttype)) {
            for (UCShape uCShape : this.detail.getShapeList()) {
                uCShape.deselect();
            }
            for (UCShape uCShape : this.footer.getShapeList()) {
                uCShape.deselect();
            }
        }
        this.selectedShape = null;
        DrawingPanel drawingPanel = this;
        drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
    }

    public void dragShape(int n2, int n3, int n4, int n5) {
        if (!this.op.equals("CMD_SELECT")) {
            return;
        }
        if (this.selectedShape == null) {
            return;
        }
        if (!this.selectedShape.hasXY(n2, n3)) {
            return;
        }
        this.selectedShape.drag(n2, n3);
    }

    public void setOperation(String string) {
        this.op = string;
        if (string.equals("CMD_SELECT") || string.equals("CMD_COPY")) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.deselectAll();
        this.repaint();
    }

    public String getOperation() {
        return this.op;
    }

    public void undo() {
    }

    public void redo() {
    }

    public void delSelectedShape() {
        if (this.selectedShape != null) {
            this.header.removeShape(this.selectedShape);
            if (Template.TemplateType.TICKET.equals((Object)this.ttype)) {
                this.detail.removeShape(this.selectedShape);
                this.footer.removeShape(this.selectedShape);
            }
            this.op = "CMD_SELECT";
            DrawingPanel drawingPanel = this;
            drawingPanel.fireDrawNotification(drawingPanel.selectedShape);
            this.deselectAll();
            this.repaint();
        }
    }

    public void selectShape() {
        UCShape uCShape = Template.TemplateType.TICKET.equals((Object)this.ttype) && !this.header.hasXY(this.x1, this.y1) ? (this.detail.hasXY(this.x1, this.y1) ? this.detail : this.footer) : this.header;
        UCShape[] uCShapeArray = ((UCBand)uCShape).getShapeList();
        UCShape uCShape2 = this.selectedShape;
        this.selectedShape = null;
        for (int i2 = uCShapeArray.length - 1; i2 >= 0; --i2) {
            uCShape = uCShapeArray[i2];
            if (!uCShape.hasXY(this.x1, this.y1)) continue;
            if (uCShape.equals(uCShape2)) {
                this.selectedShape = uCShape2;
                break;
            }
            this.deselectAll();
            uCShape.select();
            this.selectedShape = uCShape;
            break;
        }
        if (this.selectedShape == null) {
            this.deselectAll();
            DrawingPanel drawingPanel = this;
            drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
            return;
        }
        if (!this.selectedShape.equals(uCShape2)) {
            DrawingPanel drawingPanel = this;
            drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
        }
    }

    public void selectShape(String object) {
        UCShape uCShape = this.header;
        UCShape[] uCShapeArray = uCShape.getShapeList();
        uCShape = this.selectedShape;
        this.selectedShape = null;
        for (int i2 = uCShapeArray.length - 1; i2 >= 0; --i2) {
            if (!uCShapeArray[i2].getName().equalsIgnoreCase((String)object)) continue;
            object = uCShapeArray[i2];
            this.deselectAll();
            ((UCShape)object).select();
            this.selectedShape = object;
            break;
        }
        if (this.selectedShape == null) {
            this.deselectAll();
            DrawingPanel drawingPanel = this;
            drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
            return;
        }
        if (!this.selectedShape.equals(uCShape)) {
            DrawingPanel drawingPanel = this;
            drawingPanel.fireSelectionValueChanged(drawingPanel.selectedShape);
        }
    }

    public BufferedImage renderImage() {
        int n2 = this.getWidth();
        int n3 = this.header.getHeight();
        if (this.detail != null) {
            n3 += this.detail.getHeight();
        }
        if (this.footer != null) {
            n3 += this.footer.getHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 12);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n2, n3);
        for (UCShape uCShape : this.header.getShapeList()) {
            uCShape.draw(graphics2D);
            if (!uCShape.isSelected()) continue;
            uCShape.highlight(graphics2D);
        }
        if (Template.TemplateType.TICKET.equals((Object)this.ttype)) {
            for (UCShape uCShape : this.detail.getShapeList()) {
                uCShape.draw(graphics2D);
                if (!uCShape.isSelected()) continue;
                uCShape.highlight(graphics2D);
            }
            for (UCShape uCShape : this.footer.getShapeList()) {
                uCShape.draw(graphics2D);
                if (!uCShape.isSelected()) continue;
                uCShape.highlight(graphics2D);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public void addDrawListener(DrawListener drawListener) {
        this.listenerList.add(DrawListener.class, drawListener);
    }

    public void removeDrawListener(DrawListener drawListener) {
        this.listenerList.remove(DrawListener.class, drawListener);
    }

    protected void fireDrawNotification(UCShape uCShape) {
        DrawListener[] drawListenerArray = this.getDrawListeners();
        DrawListener[] drawListenerArray2 = drawListenerArray;
        drawListenerArray2 = drawListenerArray;
        int n2 = drawListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DrawListener drawListener = drawListenerArray2[i2];
            drawListener.shapeDrawn(uCShape);
        }
    }

    public DrawListener[] getDrawListeners() {
        return (DrawListener[])this.listenerList.getListeners(DrawListener.class);
    }

    protected void fireSelectionValueChanged(UCShape drawListenerArray) {
        drawListenerArray = this.getDrawListeners();
        DrawingSelectionEvent drawingSelectionEvent = new DrawingSelectionEvent(this);
        for (DrawListener drawListener : drawListenerArray) {
            drawListener.valueChanged(drawingSelectionEvent);
        }
    }

    public void addErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.add(barcodeErrorListener);
    }

    public void removeErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.remove(barcodeErrorListener);
    }

    public UCShape getSelectedShape() {
        return this.selectedShape;
    }

    @Override
    public void notifySuccess() {
    }

    @Override
    public void notifyException(Exception object) {
        Exception exception = object;
        object = this;
        object = ((DrawingPanel)object).errorListeners.iterator();
        while (object.hasNext()) {
            ((BarcodeErrorListener)object.next()).notifyException(exception);
        }
    }
}

