/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import com.systel.print.BarcodeErrorListener;
import com.systel.print.Config;
import com.systel.print.DrawEnv;
import com.systel.print.DrawListener;
import com.systel.print.DrawingPanel;
import com.systel.print.DrawingSelectionEvent;
import com.systel.print.Template;
import com.systel.print.TemplatePage;
import com.systel.print.UCBand;
import com.systel.print.UCBarcode;
import com.systel.print.UCFixData;
import com.systel.print.UCIVAInfoTable;
import com.systel.print.UCImage;
import com.systel.print.UCLine;
import com.systel.print.UCNutInfoRotulo;
import com.systel.print.UCNutInfoTable;
import com.systel.print.UCOval;
import com.systel.print.UCQrCode;
import com.systel.print.UCRect;
import com.systel.print.UCShape;
import com.systel.print.UCText;
import com.systel.print.b;
import com.systel.print.editor.BarcodePropPanel;
import com.systel.print.editor.BorderPropPanel;
import com.systel.print.editor.ByteaToImageConverter;
import com.systel.print.editor.FieldPropPanel;
import com.systel.print.editor.FontPropPanel;
import com.systel.print.editor.ImagePropPanel;
import com.systel.print.editor.IvaTablePropPanel;
import com.systel.print.editor.NutRotPropPanel;
import com.systel.print.editor.NutTablePropPanel;
import com.systel.print.editor.PosPropPanel;
import com.systel.print.editor.QrPropPanel;
import com.systel.print.editor.SizePropPanel;
import com.systel.print.editor.TemplateEditor;
import com.ucod.lang.LocaleUtil;
import com.ucod.swingplus.PropsPanel;
import com.ucod.swingplus.VirtualKeyboard;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DrawingArea
extends JPanel
implements BarcodeErrorListener,
DrawListener,
AdjustmentListener,
ChangeListener {
    public DrawEnv env = new DrawEnv();
    private final JScrollBar hbar;
    private final JScrollBar vbar;
    private int hVal = 0;
    private int vVal = 0;
    private String op = "CMD_SELECT";
    private int selectedIndex;
    private UCShape selectedShape;
    private PropsPanel propsPanel;
    private final PosPropPanel posPanel;
    private final SizePropPanel sizePanel;
    private final NutRotPropPanel nutRotPanel;
    private final FontPropPanel fontPanel;
    private final BorderPropPanel borderPanel;
    private FieldPropPanel fieldPanel;
    private final BarcodePropPanel barcodePanel;
    private final QrPropPanel qrPanel;
    private final ImagePropPanel imgPanel;
    private final FontPropPanel nutTableTitlePanel;
    private final FontPropPanel nutTableItemsPanel;
    private final FontPropPanel nutTableFootnotePanel;
    private final NutTablePropPanel nutTablePanel;
    private final FontPropPanel ivaTableTitlePanel;
    private final FontPropPanel ivaTableItemsPanel;
    private final FontPropPanel ivaTableFootnotePanel;
    private final IvaTablePropPanel ivaTablePanel;
    private final VirtualKeyboard keyboard;
    private final List errorListeners;
    protected boolean isTkt;
    private final JFrame parent;
    private Template template;
    public JPanel pagesPanel;
    private JScrollPane pagesScrollPane;
    private JSplitPane splitPane;

    public DrawingArea(JFrame componentArray, Template template, boolean bl, boolean n2, String string) {
        super(true);
        this.keyboard = new VirtualKeyboard((Frame)componentArray, true);
        this.selectedIndex = 0;
        this.errorListeners = new LinkedList();
        this.isTkt = bl;
        this.parent = componentArray;
        this.env.setIsEmbedded(n2 != 0);
        this.env.setUnimedi(string);
        this.env.setNutTableType(template.getNutInfoType());
        componentArray = this;
        this.splitPane = new JSplitPane();
        componentArray.pagesScrollPane = new JScrollPane();
        componentArray.pagesPanel = new JPanel();
        componentArray.setLayout(new BorderLayout());
        componentArray.splitPane.setDividerLocation(430);
        componentArray.splitPane.setFont(new Font("Segoe UI Semibold", 0, 14));
        componentArray.pagesScrollPane.setDoubleBuffered(true);
        componentArray.pagesScrollPane.setPreferredSize(new Dimension(448, 100));
        componentArray.pagesPanel.setMinimumSize(new Dimension(448, 1680));
        componentArray.pagesPanel.setLayout(new CardLayout());
        componentArray.pagesScrollPane.setViewportView(componentArray.pagesPanel);
        componentArray.splitPane.setLeftComponent(componentArray.pagesScrollPane);
        Container container = componentArray;
        container.add((Component)((DrawingArea)container).splitPane, "Center");
        if (!n2) {
            this.splitPane.setDividerLocation(550);
        }
        this.hbar = this.pagesScrollPane.getHorizontalScrollBar();
        this.vbar = this.pagesScrollPane.getVerticalScrollBar();
        this.hbar.setPreferredSize(new Dimension(template.getPageWidth() + 20, 24));
        this.vbar.setPreferredSize(new Dimension(24, template.getPageLen() + 400));
        componentArray = new Dimension(this.hbar.getPreferredSize().width, this.vbar.getPreferredSize().height);
        this.pagesScrollPane.setPreferredSize((Dimension)componentArray);
        this.pagesPanel.setPreferredSize((Dimension)componentArray);
        this.propsPanel = new PropsPanel();
        this.posPanel = new PosPropPanel(this.env);
        this.sizePanel = new SizePropPanel(this.env);
        this.nutRotPanel = new NutRotPropPanel(this.env);
        this.fontPanel = new FontPropPanel();
        this.fontPanel.setFootnotePanelVisible(false);
        this.borderPanel = new BorderPropPanel();
        this.fieldPanel = null;
        this.barcodePanel = new BarcodePropPanel(this.env);
        this.qrPanel = new QrPropPanel(this.env);
        this.imgPanel = new ImagePropPanel(this.env);
        this.nutTableTitlePanel = new FontPropPanel();
        this.nutTableTitlePanel.setAlignmentPanelVisible(false);
        this.nutTableTitlePanel.setFootnotePanelVisible(false);
        this.nutTableItemsPanel = new FontPropPanel();
        this.nutTableItemsPanel.setAlignmentPanelVisible(false);
        this.nutTableItemsPanel.setFootnotePanelVisible(false);
        this.nutTableItemsPanel.setTextPanelVisible(false);
        this.nutTableFootnotePanel = new FontPropPanel();
        this.nutTableFootnotePanel.setAlignmentPanelVisible(false);
        this.nutTablePanel = new NutTablePropPanel();
        this.ivaTableTitlePanel = new FontPropPanel();
        this.ivaTableTitlePanel.setAlignmentPanelVisible(false);
        this.ivaTableTitlePanel.setFootnotePanelVisible(false);
        this.ivaTableItemsPanel = new FontPropPanel();
        this.ivaTableItemsPanel.setAlignmentPanelVisible(false);
        this.ivaTableItemsPanel.setFootnotePanelVisible(false);
        this.ivaTableItemsPanel.setTextPanelVisible(false);
        this.ivaTableFootnotePanel = new FontPropPanel();
        this.ivaTableFootnotePanel.setAlignmentPanelVisible(false);
        this.ivaTablePanel = new IvaTablePropPanel();
        this.propsPanel.addBar(LocaleUtil.getMessage("Posici\u00f3n"), this.posPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Tama\u00f1o"), this.sizePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Texto"), this.fontPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Borde"), this.borderPanel);
        this.setFieldPanel(bl);
        this.propsPanel.addBar(LocaleUtil.getMessage("C\u00f3digo de barras"), this.barcodePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("C\u00f3digo QR"), this.qrPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Imagen"), this.imgPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("T\u00edtulo"), this.nutTableTitlePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Datos"), this.nutTableItemsPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Nota"), this.nutTableFootnotePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Info. nutricional"), this.nutTablePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Rotulo"), this.nutRotPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("T\u00edtulo IVA"), this.ivaTableTitlePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Datos IVA"), this.ivaTableItemsPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Nota IVA"), this.ivaTableFootnotePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Info. IVA"), this.ivaTablePanel);
        this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo QR"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
        this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setRightComponent(this.propsPanel);
        for (Component component : this.pagesPanel.getComponents()) {
            if (!(component instanceof DrawingPanel)) continue;
            component = (DrawingPanel)component;
            ((DrawingPanel)component).addDrawListener(this);
            ((DrawingPanel)component).addErrorListener(this);
        }
        this.a(template, bl);
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    public final void setSelectedIndex(int n2) {
        if (n2 >= 0 && n2 < this.pagesPanel.getComponentCount()) {
            this.selectedIndex = n2;
            CardLayout cardLayout = (CardLayout)this.pagesPanel.getLayout();
            cardLayout.show(this.pagesPanel, this.pagesPanel.getComponent(n2).getName());
            for (Component component : this.pagesPanel.getComponents()) {
                if (!(component instanceof DrawingPanel)) continue;
                component = (DrawingPanel)component;
                ((DrawingPanel)component).deselectAll();
            }
            EventQueue.invokeLater(new b(this));
        }
    }

    private DrawingPanel a() {
        Component component = this.pagesPanel.getComponent(this.selectedIndex);
        if (component instanceof DrawingPanel) {
            return (DrawingPanel)component;
        }
        return null;
    }

    public final BufferedImage renderImage() {
        DrawingPanel drawingPanel = this.a();
        if (drawingPanel != null) {
            return drawingPanel.renderImage();
        }
        return null;
    }

    private void a(String string) {
        for (Component component : this.pagesPanel.getComponents()) {
            if (!(component instanceof DrawingPanel)) continue;
            component = (DrawingPanel)component;
            ((DrawingPanel)component).setOperation(string);
        }
    }

    public final void setOperation(String object) {
        this.fontPanel.setTextPanelVisible(true);
        this.fontPanel.setAlignmentPanelVisible(true);
        this.fontPanel.setStylePanelVisible(true);
        switch (object) {
            case "CMD_SELECT": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.a((String)object);
                break;
            }
            case "CMD_DRAW_RECTANGLE": 
            case "CMD_DRAW_ROUND_RECT": 
            case "CMD_DRAW_LINE": 
            case "CMD_DRAW_OVAL": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.setVisibleBar(3);
                break;
            }
            case "CMD_FILL_RECTANGLE": 
            case "CMD_FILL_ROUND_RECT": 
            case "CMD_FILL_OVAL": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.setVisibleBar(3);
                break;
            }
            case "CMD_DRAW_BARCODE": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.showBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.setVisibleBar(5);
                break;
            }
            case "CMD_DRAW_QR": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.showBar(LocaleUtil.getMessage("C\u00f3digo QR"));
                this.propsPanel.setVisibleBar(6);
                break;
            }
            case "CMD_DRAW_FIXDATA": {
                this.fontPanel.setTextPanelVisible(false);
                this.fontPanel.setAlignmentPanelVisible(false);
                this.fontPanel.setStylePanelVisible(false);
                this.propsPanel.showBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.setVisibleBar(0);
                break;
            }
            case "CMD_DRAW_IMAGE": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.setVisibleBar(6);
                break;
            }
            case "CMD_DRAW_TEXT": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.setVisibleBar(2);
                break;
            }
            case "CMD_FILL_POLYGON": {
                break;
            }
            case "CMD_DRAW_TABLE": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.setVisibleBar(10);
                break;
            }
            case "CMD_DRAW_ROTULO": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(6);
                break;
            }
            case "CMD_DRAW_IVA": {
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.showBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.setVisibleBar(10);
                break;
            }
            case "CMD_UNDO": {
                break;
            }
            case "CMD_REDO": {
                break;
            }
            case "CMD_DELETE": {
                object = this.a();
                if (object != null) {
                    ((DrawingPanel)object).delSelectedShape();
                }
                return;
            }
            case "CMD_PRINT": {
                return;
            }
        }
        this.a((String)object);
        this.op = object;
    }

    public final void addErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.add(barcodeErrorListener);
    }

    public final void removeErrorListener(BarcodeErrorListener barcodeErrorListener) {
        this.errorListeners.remove(barcodeErrorListener);
    }

    public final int getHeaderHeight() {
        Serializable serializable = this.a();
        if (serializable != null && (serializable = ((DrawingPanel)serializable).getHeader()) != null) {
            return ((UCShape)serializable).getHeight();
        }
        return 0;
    }

    public final int getHeaderWidth() {
        Serializable serializable = this.a();
        if (serializable != null && (serializable = ((DrawingPanel)serializable).getHeader()) != null) {
            return ((UCShape)serializable).getWidth();
        }
        return 0;
    }

    public final void updateBands() {
        for (Component component : this.pagesPanel.getComponents()) {
            if (!(component instanceof DrawingPanel)) continue;
            component = (DrawingPanel)component;
            Serializable serializable = ((DrawingPanel)component).getHeader();
            UCBand uCBand = ((DrawingPanel)component).getDetail();
            UCBand uCBand2 = ((DrawingPanel)component).getFooter();
            if (serializable != null && uCBand != null) {
                uCBand.setY(serializable.getHeight());
                uCBand.setX(0);
                if (uCBand2 != null) {
                    uCBand2.setY(uCBand.getY() + uCBand.getHeight());
                    uCBand2.setX(uCBand.getX());
                }
            }
            this.hbar.setPreferredSize(new Dimension(serializable.getWidth(), 24));
            if (uCBand != null) {
                this.vbar.setPreferredSize(new Dimension(24, serializable.getHeight() + uCBand.getHeight() + uCBand2.getHeight()));
            } else {
                this.vbar.setPreferredSize(new Dimension(24, serializable.getHeight()));
            }
            serializable = new Dimension(this.hbar.getPreferredSize().width, this.vbar.getPreferredSize().height + 400);
            this.pagesScrollPane.setPreferredSize((Dimension)serializable);
            this.pagesScrollPane.setSize((Dimension)serializable);
            this.pagesPanel.setPreferredSize((Dimension)serializable);
            this.pagesPanel.setSize((Dimension)serializable);
            ((DrawingPanel)component).deselectAll();
            ((DrawingPanel)component).selectShape("UCFixData");
            component.repaint();
            this.repaint();
        }
    }

    public final void setHeaderHeight(int n2) {
        for (Component component : this.pagesPanel.getComponents()) {
            DrawingPanel drawingPanel;
            UCBand uCBand;
            if (!(component instanceof DrawingPanel) || (uCBand = (drawingPanel = (DrawingPanel)component).getHeader()) == null) continue;
            uCBand.setHeight(n2);
            this.updateBands();
        }
    }

    public final void setHeaderWidth(int n2) {
        for (Component component : this.pagesPanel.getComponents()) {
            DrawingPanel drawingPanel;
            UCBand uCBand;
            if (!(component instanceof DrawingPanel) || (uCBand = (drawingPanel = (DrawingPanel)component).getHeader()) == null) continue;
            uCBand.setWidth(n2);
            this.updateBands();
        }
    }

    public final int getDetailHeight() {
        Serializable serializable = this.a();
        if (serializable != null && (serializable = ((DrawingPanel)serializable).getDetail()) != null) {
            return ((UCShape)serializable).getHeight();
        }
        return 0;
    }

    public final void setDetailHeight(int n2) {
        for (Component component : this.pagesPanel.getComponents()) {
            DrawingPanel drawingPanel;
            UCBand uCBand;
            if (!(component instanceof DrawingPanel) || (uCBand = (drawingPanel = (DrawingPanel)component).getDetail()) == null) continue;
            uCBand.setHeight(n2);
            this.updateBands();
        }
    }

    public final int getFooterHeight() {
        Serializable serializable = this.a();
        if (serializable != null && (serializable = ((DrawingPanel)serializable).getFooter()) != null) {
            return ((UCShape)serializable).getHeight();
        }
        return 0;
    }

    public final void setFooterHeight(int n2) {
        for (Component component : this.pagesPanel.getComponents()) {
            if (!(component instanceof DrawingPanel)) continue;
            UCBand uCBand = ((DrawingPanel)(component = (DrawingPanel)component)).getFooter();
            if (uCBand != null) {
                uCBand.setHeight(n2);
            }
            component.repaint();
        }
    }

    @Override
    public final void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Point point = this.pagesPanel.getLocation();
        if (adjustmentEvent.getAdjustable().getOrientation() == 0) {
            point.x = point.x - adjustmentEvent.getValue() + this.hVal;
            this.hVal = adjustmentEvent.getValue();
        }
        if (adjustmentEvent.getAdjustable().getOrientation() == 1) {
            point.y = point.y - adjustmentEvent.getValue() + this.vVal;
            this.vVal = adjustmentEvent.getValue();
        }
        this.pagesPanel.setLocation(point);
        this.pagesPanel.repaint();
    }

    @Override
    public final void stateChanged(ChangeEvent object) {
        DrawingPanel drawingPanel = this.a();
        if (drawingPanel == null) {
            return;
        }
        try {
            UCShape uCShape = this.selectedShape;
            if (((EventObject)object).getSource().equals(this.posPanel)) {
                if (uCShape == null) {
                    return;
                }
                uCShape.setX(this.posPanel.getPosX());
                uCShape.setY(this.posPanel.getPosY());
            } else if (((EventObject)object).getSource().equals(this.sizePanel)) {
                if (uCShape == null) {
                    return;
                }
                uCShape.setWidth(this.sizePanel.getWidthProp());
                uCShape.setHeight(this.sizePanel.getHeightProp());
            } else if (((EventObject)object).getSource().equals(this.nutRotPanel)) {
                if (uCShape == null) {
                    return;
                }
                uCShape.setWidth(this.nutRotPanel.getWidthProp());
                uCShape.setHeight(this.nutRotPanel.getHeightProp());
                ((UCNutInfoRotulo)uCShape).setDwidth(this.nutRotPanel.getDwidth());
                ((UCNutInfoRotulo)uCShape).setDheight(this.nutRotPanel.getDheight());
                int n2 = this.nutRotPanel.getOrinetation();
                int n3 = this.nutRotPanel.getCant();
                Image image = null;
                String string = this.nutRotPanel.getNutInfoType();
                ((UCNutInfoRotulo)uCShape).setType(string);
                ((UCNutInfoRotulo)uCShape).setAutoSize(this.nutRotPanel.getAutoSize());
                if (string.equals(Config.TipoTablaNut.BRA_LEF_RDC_N_429_ANVISA_2.getType())) {
                    switch (n2) {
                        case 0: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalBR/brHorizontal.png");
                            break;
                        }
                        case 1: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalBR/brVertical.png");
                            break;
                        }
                    }
                } else if (string.equals(Config.TipoTablaNut.ARG_LEF_Ley_N_27642_OCTOGONOS_3.getType())) {
                    switch (n2) {
                        case 0: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalAR/full.png");
                            break;
                        }
                        case 1: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalAR/micro7.png");
                            break;
                        }
                        case 2: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalAR/partes.png");
                            break;
                        }
                        case 3: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalAR/partOcto/partOcto" + n3 + ".png");
                            break;
                        }
                        case 4: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalAR/partRect/partRect" + n3 + ".png");
                            break;
                        }
                    }
                } else if (string.equals(Config.TipoTablaNut.MEX_LEF_NOM_051_SCFI_SSA1_2010_4.getType())) {
                    switch (n2) {
                        case 0: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalMX/full.png");
                            break;
                        }
                        case 1: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalMX/micro1.png");
                            break;
                        }
                        case 2: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalMX/partes.png");
                            break;
                        }
                        case 3: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalMX/partOcto/partOcto" + n3 + ".png");
                            break;
                        }
                        case 4: {
                            image = Config.getImage("com/systel/resources/etiquetadoFrontalMX/partRect/partRect" + n3 + ".png");
                        }
                    }
                }
                ((UCNutInfoRotulo)uCShape).setImg(image);
                ((UCNutInfoRotulo)uCShape).setOrientation(n2);
                ((UCNutInfoRotulo)uCShape).setCant(n3);
            } else if (((EventObject)object).getSource().equals(this.borderPanel)) {
                if (uCShape == null) {
                    return;
                }
                if ("UCRect".equals(uCShape.getName()) || "UCLine".equals(uCShape.getName()) || "UCText".equals(uCShape.getName())) {
                    uCShape.setColor(this.borderPanel.getForeground());
                }
                switch (uCShape.getName()) {
                    case "UCRect": {
                        ((UCRect)uCShape).setBorder(this.borderPanel.getStrokeSize());
                        break;
                    }
                    case "UCLine": {
                        ((UCLine)uCShape).setBorder(this.borderPanel.getStrokeSize());
                        break;
                    }
                    case "UCOval": {
                        ((UCOval)uCShape).setBorder(this.borderPanel.getStrokeSize());
                    }
                }
            } else if (((EventObject)object).getSource().equals(this.fieldPanel)) {
                if (uCShape == null) {
                    return;
                }
                ((UCText)uCShape).setField(this.fieldPanel.getField());
            } else if (((EventObject)object).getSource().equals(this.fontPanel)) {
                this.env.setFontName(this.fontPanel.getFontName());
                this.env.setFontAlignment(this.fontPanel.getAlignment());
                this.env.setFontStyle(this.fontPanel.getFontStyle());
                this.env.setFontSize(this.fontPanel.getFontSize());
                this.env.setText(this.fontPanel.getText());
                this.env.setFontInvert(this.fontPanel.getFontInvert());
                if (uCShape != null) {
                    if (uCShape instanceof UCFixData) {
                        ((UCFixData)uCShape).setFontSize(this.fontPanel.getFontSize());
                        ((UCFixData)uCShape).setFontName(this.fontPanel.getFontName());
                    } else {
                        ((UCText)uCShape).setFontSize(this.fontPanel.getFontSize());
                        ((UCText)uCShape).setAlignment(this.fontPanel.getAlignment());
                        ((UCText)uCShape).setFontName(this.fontPanel.getFontName());
                        ((UCText)uCShape).setStyle(this.fontPanel.getFontStyle());
                        ((UCText)uCShape).setText(this.fontPanel.getText());
                        ((UCText)uCShape).setFontInvert(this.fontPanel.getFontInvert());
                    }
                }
            } else if (((EventObject)object).getSource().equals(this.barcodePanel)) {
                if (uCShape == null) {
                    return;
                }
                ((UCBarcode)uCShape).setBarHeight(this.barcodePanel.getBarHeight());
                ((UCBarcode)uCShape).setBarcode(this.barcodePanel.getBcType());
                ((UCBarcode)uCShape).setField(this.barcodePanel.getField());
                ((UCBarcode)uCShape).setModuleWith(this.barcodePanel.getModuleWitdh());
                ((UCBarcode)uCShape).setOrientation(this.barcodePanel.getOrientation());
                ((UCBarcode)uCShape).setValue(this.barcodePanel.getValue());
            } else if (((EventObject)object).getSource().equals(this.qrPanel)) {
                if (uCShape == null) {
                    return;
                }
                ((UCQrCode)uCShape).setValue(this.qrPanel.getValue());
                ((UCQrCode)uCShape).setDim(this.qrPanel.getDim());
            } else if (((EventObject)object).getSource().equals(this.imgPanel)) {
                if (uCShape == null) {
                    return;
                }
                ((UCImage)uCShape).setField(this.imgPanel.getField());
                if (Config.IMAGE_FIELDS.get(0).equals(this.imgPanel.getField())) {
                    ((UCImage)uCShape).setImg(Config.getImage("com/ucod/images/i48/image_file-48.png"));
                } else if (this.env.getImageSelected() != null) {
                    ((UCImage)uCShape).setImg(ByteaToImageConverter.getInstance().convertForward(this.env.getImageSelected().getBinarydata()).getImage());
                } else if (!"".equals(this.env.getImgPath())) {
                    ((UCImage)uCShape).setImg(this.env.getImage());
                } else {
                    ((UCImage)uCShape).setImg(Config.getImage("com/ucod/images/i48/image_file-48.png"));
                }
            } else if (((EventObject)object).getSource().equals(this.nutTableTitlePanel)) {
                this.env.setTitleNutInfo(this.nutTableTitlePanel.getText());
                this.env.setTitleFontName(this.nutTableTitlePanel.getFontName());
                this.env.setTitleFontSize(this.nutTableTitlePanel.getFontSize());
                this.env.setTitleFontStyle(this.nutTableTitlePanel.getFontStyle());
                if (uCShape != null) {
                    ((UCNutInfoTable)uCShape).setTitle(this.nutTableTitlePanel.getText());
                    ((UCNutInfoTable)uCShape).setTitleFontName(this.nutTableTitlePanel.getFontName());
                    ((UCNutInfoTable)uCShape).setTitleFontSize(this.nutTableTitlePanel.getFontSize());
                    ((UCNutInfoTable)uCShape).setTitleFontStyle(this.nutTableTitlePanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.nutTableItemsPanel)) {
                this.env.setNutTableItemFontName(this.nutTableItemsPanel.getFontName());
                this.env.setNutTableItemFontSize(this.nutTableItemsPanel.getFontSize());
                this.env.setNutTableItemFontStyle(this.nutTableItemsPanel.getFontStyle());
                if (uCShape != null) {
                    ((UCNutInfoTable)uCShape).setFontName(this.nutTableItemsPanel.getFontName());
                    ((UCNutInfoTable)uCShape).setFontSize(this.nutTableItemsPanel.getFontSize());
                    ((UCNutInfoTable)uCShape).setFontStyle(this.nutTableItemsPanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.nutTableFootnotePanel)) {
                this.env.setShowFootnote(this.nutTableFootnotePanel.isFootnoteVisible());
                this.env.setFootnoteNutInfo(this.nutTableFootnotePanel.getText());
                this.env.setFnFontName(this.nutTableFootnotePanel.getFontName());
                this.env.setFnFontSize(this.nutTableFootnotePanel.getFontSize());
                this.env.setFnFontStyle(this.nutTableFootnotePanel.getFontStyle());
                if (uCShape != null) {
                    ((UCNutInfoTable)uCShape).setShowFootnote(this.nutTableFootnotePanel.isFootnoteVisible());
                    ((UCNutInfoTable)uCShape).setFootnote(this.nutTableFootnotePanel.getText());
                    ((UCNutInfoTable)uCShape).setFootnoteFontName(this.nutTableFootnotePanel.getFontName());
                    ((UCNutInfoTable)uCShape).setFootnoteFontSize(this.nutTableFootnotePanel.getFontSize());
                    ((UCNutInfoTable)uCShape).setFootnoteFontStyle(this.nutTableFootnotePanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.nutTablePanel)) {
                this.env.setHeaderHeight(this.nutTablePanel.getHeaderHeight());
                this.env.setRowHeight(this.nutTablePanel.getRowHeight());
                this.env.setDrawHLines(this.nutTablePanel.showHorizontalLines());
                this.env.setDrawVLines(this.nutTablePanel.showVerticalLines());
                this.env.setOutlineStroke(this.nutTablePanel.getOutline());
                this.env.setNutTableType(this.nutTablePanel.getNutInfoType());
                if (uCShape != null) {
                    ((UCNutInfoTable)uCShape).setHeaderHeight(this.nutTablePanel.getHeaderHeight());
                    ((UCNutInfoTable)uCShape).setRowHeight(this.nutTablePanel.getRowHeight());
                    ((UCNutInfoTable)uCShape).setDrawHLines(this.nutTablePanel.showHorizontalLines());
                    ((UCNutInfoTable)uCShape).setDrawVLines(this.nutTablePanel.showVerticalLines());
                    ((UCNutInfoTable)uCShape).setOutlineStroke(this.nutTablePanel.getOutline());
                    ((UCNutInfoTable)uCShape).setIntLinesStroke(this.nutTablePanel.getStroke());
                    ((UCNutInfoTable)uCShape).setNutInfoType(this.nutTablePanel.getNutInfoType());
                }
            } else if (((EventObject)object).getSource().equals(this.ivaTableTitlePanel)) {
                this.env.setTitleIvaInfo(this.ivaTableTitlePanel.getText());
                this.env.setTitleFontName(this.ivaTableTitlePanel.getFontName());
                this.env.setTitleFontSize(this.ivaTableTitlePanel.getFontSize());
                this.env.setTitleFontStyle(this.ivaTableTitlePanel.getFontStyle());
                if (uCShape != null) {
                    ((UCIVAInfoTable)uCShape).setTitle(this.ivaTableTitlePanel.getText());
                    ((UCIVAInfoTable)uCShape).setTitleFontName(this.ivaTableTitlePanel.getFontName());
                    ((UCIVAInfoTable)uCShape).setTitleFontSize(this.ivaTableTitlePanel.getFontSize());
                    ((UCIVAInfoTable)uCShape).setTitleFontStyle(this.ivaTableTitlePanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.ivaTableItemsPanel)) {
                this.env.setNutTableItemFontName(this.ivaTableItemsPanel.getFontName());
                this.env.setNutTableItemFontSize(this.ivaTableItemsPanel.getFontSize());
                this.env.setNutTableItemFontStyle(this.ivaTableItemsPanel.getFontStyle());
                if (uCShape != null) {
                    ((UCIVAInfoTable)uCShape).setFontName(this.ivaTableItemsPanel.getFontName());
                    ((UCIVAInfoTable)uCShape).setFontSize(this.ivaTableItemsPanel.getFontSize());
                    ((UCIVAInfoTable)uCShape).setFontStyle(this.ivaTableItemsPanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.ivaTableFootnotePanel)) {
                this.env.setShowFootnote(this.ivaTableFootnotePanel.isFootnoteVisible());
                this.env.setFootnoteIvaInfo(this.ivaTableFootnotePanel.getText());
                this.env.setFnFontName(this.ivaTableFootnotePanel.getFontName());
                this.env.setFnFontSize(this.ivaTableFootnotePanel.getFontSize());
                this.env.setFnFontStyle(this.ivaTableFootnotePanel.getFontStyle());
                if (uCShape != null) {
                    ((UCIVAInfoTable)uCShape).setShowFootnote(this.ivaTableFootnotePanel.isFootnoteVisible());
                    ((UCIVAInfoTable)uCShape).setFootnote(this.ivaTableFootnotePanel.getText());
                    ((UCIVAInfoTable)uCShape).setFootnoteFontName(this.ivaTableFootnotePanel.getFontName());
                    ((UCIVAInfoTable)uCShape).setFootnoteFontSize(this.ivaTableFootnotePanel.getFontSize());
                    ((UCIVAInfoTable)uCShape).setFootnoteFontStyle(this.ivaTableFootnotePanel.getFontStyle());
                }
            } else if (((EventObject)object).getSource().equals(this.ivaTablePanel)) {
                this.env.setHeaderHeight(this.ivaTablePanel.getHeaderHeight());
                this.env.setRowHeight(this.ivaTablePanel.getRowHeight());
                this.env.setDrawHLines(this.ivaTablePanel.showHorizontalLines());
                this.env.setDrawVLines(this.ivaTablePanel.showVerticalLines());
                this.env.setOutlineStroke(this.ivaTablePanel.getOutline());
                if (uCShape != null) {
                    ((UCIVAInfoTable)uCShape).setHeaderHeight(this.ivaTablePanel.getHeaderHeight());
                    ((UCIVAInfoTable)uCShape).setRowHeight(this.ivaTablePanel.getRowHeight());
                    ((UCIVAInfoTable)uCShape).setDrawHLines(this.ivaTablePanel.showHorizontalLines());
                    ((UCIVAInfoTable)uCShape).setDrawVLines(this.ivaTablePanel.showVerticalLines());
                    ((UCIVAInfoTable)uCShape).setOutlineStroke(this.ivaTablePanel.getOutline());
                    ((UCIVAInfoTable)uCShape).setIntLinesStroke(this.ivaTablePanel.getStroke());
                }
            }
            if (uCShape != null) {
                drawingPanel.repaint();
            }
            return;
        }
        catch (Exception exception) {
            if (!TemplateEditor.isRunInPc) {
                Logger.getLogger(DrawingArea.class.getName()).log(Level.SEVERE, null, exception);
            }
            return;
        }
    }

    @Override
    public final void valueChanged(DrawingSelectionEvent serializable) {
        serializable = this.a();
        if (serializable == null) {
            return;
        }
        serializable = ((DrawingPanel)serializable).getSelectedShape();
        this.selectedShape = serializable;
        if (serializable == null) {
            this.propsPanel.hideBar(LocaleUtil.getMessage("Posici\u00f3n"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo QR"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
            this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
            return;
        }
        this.propsPanel.showBar(LocaleUtil.getMessage("Posici\u00f3n"));
        this.propsPanel.showBar(LocaleUtil.getMessage("Tama\u00f1o"));
        this.posPanel.removeChangeListener(this);
        this.posPanel.setPosX(((UCShape)serializable).getX());
        this.posPanel.setPosY(((UCShape)serializable).getY());
        this.sizePanel.removeChangeListener(this);
        this.sizePanel.setWidthProp(((UCShape)serializable).getWidth());
        this.sizePanel.setHeightProp(((UCShape)serializable).getHeight());
        this.fontPanel.setTextPanelVisible(true);
        this.fontPanel.setAlignmentPanelVisible(true);
        this.fontPanel.setStylePanelVisible(true);
        switch (((UCShape)serializable).getName()) {
            case "UCRect": {
                this.borderPanel.removeChangeListener(this);
                this.borderPanel.setStrokeSize(((UCRect)serializable).getBorder());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(3);
                this.borderPanel.addChangeListener(this);
                break;
            }
            case "UCLine": {
                this.borderPanel.removeChangeListener(this);
                this.borderPanel.setStrokeSize(((UCLine)serializable).getBorder());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(3);
                this.borderPanel.addChangeListener(this);
                break;
            }
            case "UCOval": {
                this.borderPanel.removeChangeListener(this);
                this.borderPanel.setStrokeSize(((UCOval)serializable).getBorder());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(3);
                this.borderPanel.addChangeListener(this);
                break;
            }
            case "UCBarcode": {
                this.barcodePanel.removeChangeListener(this);
                this.barcodePanel.setBarHeight(((UCBarcode)serializable).getBarHeight());
                this.barcodePanel.setBarcodeType(((UCBarcode)serializable).getBarcode());
                this.barcodePanel.setField(((UCBarcode)serializable).getField());
                this.barcodePanel.setModuleWidth(((UCBarcode)serializable).getModuleWith());
                this.barcodePanel.setOrientation(((UCBarcode)serializable).getOrientation());
                this.barcodePanel.setValue(((UCBarcode)serializable).getValue());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(5);
                this.barcodePanel.addChangeListener(this);
                break;
            }
            case "UCQrCode": {
                this.qrPanel.removeChangeListener(this);
                this.qrPanel.setValue(((UCQrCode)serializable).getValue());
                this.qrPanel.setDim(((UCQrCode)serializable).getDim());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("C\u00f3digo QR"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(7);
                this.qrPanel.addChangeListener(this);
                break;
            }
            case "UCImage": {
                this.imgPanel.removeChangeListener(this);
                this.imgPanel.setField(((UCImage)serializable).getField());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(6);
                this.imgPanel.addChangeListener(this);
                break;
            }
            case "UCText": {
                this.fieldPanel.removeChangeListener(this);
                this.fontPanel.removeChangeListener(this);
                this.borderPanel.removeChangeListener(this);
                this.fieldPanel.setField(((UCText)serializable).getField());
                this.fontPanel.setAlignment(((UCText)serializable).getAlignment());
                this.fontPanel.setFontName(((UCText)serializable).getFontName());
                this.fontPanel.setFontSize(((UCText)serializable).getFontSize());
                this.fontPanel.setFontStyle(((UCText)serializable).getFontStyle());
                this.fontPanel.setText(((UCText)serializable).getText());
                this.fontPanel.setFontInvert(((UCText)serializable).getFontInvert());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(2);
                this.fieldPanel.addChangeListener(this);
                this.fontPanel.addChangeListener(this);
                this.borderPanel.addChangeListener(this);
                break;
            }
            case "UCFixData": {
                this.fontPanel.removeChangeListener(this);
                this.borderPanel.removeChangeListener(this);
                serializable = (UCFixData)serializable;
                ((UCFixData)serializable).setEnvWidth(this.getHeaderWidth());
                ((UCFixData)serializable).setEnvHeight(this.getHeaderHeight());
                ((UCFixData)serializable).setMargins(this.template.getMargins());
                this.fontPanel.setTextPanelVisible(false);
                this.fontPanel.setAlignmentPanelVisible(false);
                this.fontPanel.setStylePanelVisible(false);
                this.fontPanel.setText("");
                this.fontPanel.setFontName(((UCFixData)serializable).getFontName());
                this.fontPanel.setFontSize(((UCFixData)serializable).getFontSize());
                this.fontPanel.setFontStyle(((UCFixData)serializable).getFontStyle());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.setVisibleBar(0);
                this.fontPanel.addChangeListener(this);
                this.borderPanel.addChangeListener(this);
                break;
            }
            case "UCNutInfoTable": {
                this.nutTableTitlePanel.removeChangeListener(this);
                this.nutTableItemsPanel.removeChangeListener(this);
                this.nutTableFootnotePanel.removeChangeListener(this);
                this.nutTablePanel.removeChangeListener(this);
                serializable = (UCNutInfoTable)serializable;
                this.nutTableTitlePanel.setText(((UCNutInfoTable)serializable).getTitle());
                this.nutTableTitlePanel.setFontName(((UCNutInfoTable)serializable).getTitleFontName());
                this.nutTableTitlePanel.setFontSize(((UCNutInfoTable)serializable).getTitleFontSize());
                this.nutTableTitlePanel.setFontStyle(((UCNutInfoTable)serializable).getTitleFontStyle());
                this.nutTableItemsPanel.setFontName(((UCNutInfoTable)serializable).getFontName());
                this.nutTableItemsPanel.setFontSize(((UCNutInfoTable)serializable).getFontSize());
                this.nutTableItemsPanel.setFontStyle(((UCNutInfoTable)serializable).getFontStyle());
                this.nutTableFootnotePanel.setFootnoteVisible(((UCNutInfoTable)serializable).isShowFootnote());
                this.nutTableFootnotePanel.setText(((UCNutInfoTable)serializable).getFootnote());
                this.nutTableFootnotePanel.setFontName(((UCNutInfoTable)serializable).getFootnoteFontName());
                this.nutTableFootnotePanel.setFontSize(((UCNutInfoTable)serializable).getFootnoteFontSize());
                this.nutTableFootnotePanel.setFontStyle(((UCNutInfoTable)serializable).getFootnoteFontStyle());
                this.nutTablePanel.setOutline(((UCNutInfoTable)serializable).getOutlineStroke());
                this.nutTablePanel.setHeaderHeight(((UCNutInfoTable)serializable).getHeaderHeight());
                this.nutTablePanel.setRowHeight(((UCNutInfoTable)serializable).getRowHeight());
                this.nutTablePanel.setShowHLines(((UCNutInfoTable)serializable).isDrawHLines());
                this.nutTablePanel.setShowVLines(((UCNutInfoTable)serializable).isDrawVLines());
                this.nutTablePanel.setStroke(((UCNutInfoTable)serializable).getIntLinesStroke());
                this.nutTablePanel.setNutInfoType(((UCNutInfoTable)serializable).getNutInfoType());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(10);
                this.nutTableTitlePanel.addChangeListener(this);
                this.nutTableItemsPanel.addChangeListener(this);
                this.nutTableFootnotePanel.addChangeListener(this);
                this.nutTablePanel.addChangeListener(this);
                break;
            }
            case "UCNutInfoRotulo": {
                this.nutRotPanel.removeChangeListener(this);
                serializable = (UCNutInfoRotulo)serializable;
                this.nutRotPanel.setNutInfoType(((UCNutInfoRotulo)serializable).getType());
                this.nutRotPanel.setOrientation(((UCNutInfoRotulo)serializable).getOrientation());
                this.nutRotPanel.setCant(((UCNutInfoRotulo)serializable).getCant());
                this.nutRotPanel.setAutoSize(((UCNutInfoRotulo)serializable).isAutoSize());
                this.nutRotPanel.setWidthProp(((UCNutInfoRotulo)serializable).getDwidth());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. nutricional"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Tama\u00f1o"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(10);
                this.nutRotPanel.addChangeListener(this);
                break;
            }
            case "UCIVAInfoTable": {
                this.ivaTableTitlePanel.removeChangeListener(this);
                this.ivaTableItemsPanel.removeChangeListener(this);
                this.ivaTableFootnotePanel.removeChangeListener(this);
                this.ivaTablePanel.removeChangeListener(this);
                serializable = (UCIVAInfoTable)serializable;
                this.ivaTableTitlePanel.setText(((UCIVAInfoTable)serializable).getTitle());
                this.ivaTableTitlePanel.setFontName(((UCIVAInfoTable)serializable).getTitleFontName());
                this.ivaTableTitlePanel.setFontSize(((UCIVAInfoTable)serializable).getTitleFontSize());
                this.ivaTableTitlePanel.setFontStyle(((UCIVAInfoTable)serializable).getTitleFontStyle());
                this.ivaTableItemsPanel.setFontName(((UCIVAInfoTable)serializable).getFontName());
                this.ivaTableItemsPanel.setFontSize(((UCIVAInfoTable)serializable).getFontSize());
                this.ivaTableItemsPanel.setFontStyle(((UCIVAInfoTable)serializable).getFontStyle());
                this.ivaTableFootnotePanel.setFootnoteVisible(((UCIVAInfoTable)serializable).isShowFootnote());
                this.ivaTableFootnotePanel.setText(((UCIVAInfoTable)serializable).getFootnote());
                this.ivaTableFootnotePanel.setFontName(((UCIVAInfoTable)serializable).getFootnoteFontName());
                this.ivaTableFootnotePanel.setFontSize(((UCIVAInfoTable)serializable).getFootnoteFontSize());
                this.ivaTableFootnotePanel.setFontStyle(((UCIVAInfoTable)serializable).getFootnoteFontStyle());
                this.ivaTablePanel.setOutline(((UCIVAInfoTable)serializable).getOutlineStroke());
                this.ivaTablePanel.setHeaderHeight(((UCIVAInfoTable)serializable).getHeaderHeight());
                this.ivaTablePanel.setRowHeight(((UCIVAInfoTable)serializable).getRowHeight());
                this.ivaTablePanel.setShowHLines(((UCIVAInfoTable)serializable).isDrawHLines());
                this.ivaTablePanel.setShowVLines(((UCIVAInfoTable)serializable).isDrawVLines());
                this.ivaTablePanel.setStroke(((UCIVAInfoTable)serializable).getIntLinesStroke());
                this.propsPanel.hideBar(LocaleUtil.getMessage("Texto"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Borde"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Campo de datos"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("C\u00f3digo de barras"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Imagen"));
                this.propsPanel.showBar(LocaleUtil.getMessage("T\u00edtulo IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Datos IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Nota IVA"));
                this.propsPanel.showBar(LocaleUtil.getMessage("Info. IVA"));
                this.propsPanel.hideBar(LocaleUtil.getMessage("Rotulo"));
                this.propsPanel.setVisibleBar(10);
                this.ivaTableTitlePanel.addChangeListener(this);
                this.ivaTableItemsPanel.addChangeListener(this);
                this.ivaTableFootnotePanel.addChangeListener(this);
                this.ivaTablePanel.addChangeListener(this);
            }
        }
        this.posPanel.addChangeListener(this);
        this.sizePanel.addChangeListener(this);
    }

    @Override
    public final void notifySuccess() {
    }

    @Override
    public final void notifyException(Exception object) {
        Exception exception = object;
        object = this;
        object = ((DrawingArea)object).errorListeners.iterator();
        while (object.hasNext()) {
            ((BarcodeErrorListener)object.next()).notifyException(exception);
        }
    }

    @Override
    public final void shapeDrawn(UCShape uCShape) {
        this.fireDrawNotification(uCShape);
    }

    public final void addDrawListener(DrawListener drawListener) {
        this.listenerList.add(DrawListener.class, drawListener);
    }

    public final void removeDrawListener(DrawListener drawListener) {
        this.listenerList.remove(DrawListener.class, drawListener);
    }

    public final DrawListener[] getDrawListeners() {
        return (DrawListener[])this.listenerList.getListeners(DrawListener.class);
    }

    public final void setTemplate(Template template, boolean bl) {
        this.a(template, bl);
    }

    public final Template getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Template template, boolean bl) {
        Dimension dimension = new Dimension(template.getPageWidth(), template.getPageLen());
        for (Component component : this.pagesPanel.getComponents()) {
            if (!(component instanceof DrawingPanel)) continue;
            DrawingPanel exception = (DrawingPanel)component;
            exception.removeDrawListener(this);
            exception.removeErrorListener(this);
        }
        Template template2 = template;
        synchronized (template2) {
            int n2 = 0;
            this.pagesPanel.removeAll();
            for (TemplatePage templatePage : template.getPageList()) {
                try {
                    DrawingPanel drawingPanel = new DrawingPanel(this.env, templatePage, bl);
                    drawingPanel.setBackground(new Color(170, 170, 170));
                    drawingPanel.setPreferredSize(dimension);
                    drawingPanel.setMinimumSize(dimension);
                    drawingPanel.setMaximumSize(dimension);
                    drawingPanel.setName("PAGE" + String.valueOf(n2));
                    this.pagesPanel.add(drawingPanel, "PAGE" + String.valueOf(n2), n2);
                    ++n2;
                    drawingPanel.addDrawListener(this);
                    drawingPanel.addErrorListener(this);
                    if (!Template.TemplateType.TICKET.equals((Object)template.getType())) continue;
                    break;
                }
                catch (Exception exception) {
                    if (TemplateEditor.isRunInPc) continue;
                    Logger.getLogger(DrawingArea.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
            this.setSelectedIndex(n2 - 1);
            this.template = template;
            return;
        }
    }

    protected final void fireDrawNotification(UCShape uCShape) {
        DrawListener[] drawListenerArray = this.getDrawListeners();
        this.op = "CMD_SELECT";
        for (DrawListener drawListener : drawListenerArray) {
            drawListener.shapeDrawn(uCShape);
        }
    }

    public final void setFieldPanel(boolean bl) {
        this.fieldPanel = null;
        this.fieldPanel = new FieldPropPanel(this.env, bl);
        this.propsPanel.addBar(LocaleUtil.getMessage("Campo de datos"), this.fieldPanel);
    }

    public final void changeLocalePanel(Locale componentArray, Locale locale) {
        componentArray = this;
        if (componentArray.op.equals("CMD_SELECT")) {
            for (Component component : componentArray.pagesPanel.getComponents()) {
                if (!(component instanceof DrawingPanel)) continue;
                component = (DrawingPanel)component;
                ((DrawingPanel)component).deselectAll();
                component.repaint();
            }
        }
        Locale.setDefault(locale);
        ResourceBundle.clearCache();
        this.propsPanel = null;
        this.propsPanel = new PropsPanel();
        this.splitPane.setRightComponent(this.propsPanel);
        LocaleUtil.setCurrentLocale(locale);
        this.propsPanel.addBar(LocaleUtil.getMessage("Posici\u00f3n"), this.posPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Tama\u00f1o"), this.sizePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Texto"), this.fontPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Borde"), this.borderPanel);
        DrawingArea drawingArea = this;
        drawingArea.setFieldPanel(drawingArea.isTkt);
        this.propsPanel.addBar(LocaleUtil.getMessage("C\u00f3digo de barras"), this.barcodePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("C\u00f3digo QR"), this.qrPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Imagen"), this.imgPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("T\u00edtulo"), this.nutTableTitlePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Datos"), this.nutTableItemsPanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Nota"), this.nutTableFootnotePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Info. nutricional"), this.nutTablePanel);
        this.propsPanel.addBar(LocaleUtil.getMessage("Rotulo"), this.nutRotPanel);
    }

    static /* synthetic */ JFrame access$000(DrawingArea drawingArea) {
        return drawingArea.parent;
    }
}

