/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

public class BarcodeType {
    public static final int EAN13 = 0;
    public static final int CODE128 = 1;
    public static final int EAN128 = 2;
    public static final int CODE39 = 3;
    public static final int DATAMATRIX = 4;
    public static final int INT2OF5 = 5;
    public static final int ITF14 = 6;
    public static final int PDF417 = 7;
    public static final int EAN8 = 8;
    public static final int UPCA = 9;
    public static final int UPCE = 10;
    public static final int CODABAR = 11;
    public static final int GTIN = 12;
    private int a;
    private int b;
    private String c;

    public BarcodeType(int n2) {
        this.a = n2;
        switch (n2) {
            case 12: {
                this.c = "GTIN";
                this.b = 14;
                return;
            }
            case 11: {
                this.c = "Codabar";
                this.b = 1;
                return;
            }
            case 1: {
                this.c = "Code 128";
                this.b = 128;
                return;
            }
            case 2: {
                this.c = "EAN 128";
                this.b = 128;
                return;
            }
            case 3: {
                this.c = "Code 39";
                this.b = 1;
                return;
            }
            case 4: {
                this.c = "Datamatrix";
                this.b = 1;
                return;
            }
            case 5: {
                this.c = "ITF";
                this.b = 1;
                return;
            }
            case 6: {
                this.c = "DUN 14";
                this.b = 14;
                return;
            }
            case 7: {
                this.c = "PDF417";
                this.b = 1;
                return;
            }
            case 8: {
                this.c = "EAN 8";
                this.b = 8;
                return;
            }
            case 9: {
                this.c = "UPC A";
                this.b = 12;
                return;
            }
            case 10: {
                this.c = "UPC E";
                this.b = 8;
                return;
            }
        }
        this.c = "EAN 13";
        this.b = 13;
    }

    public static int decode(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = -1;
        switch (string.hashCode()) {
            case 2198226: {
                if (!string.equals("GTIN")) break;
                n2 = 0;
                break;
            }
            case -1688587926: {
                if (!string.equals("Codabar")) break;
                n2 = 1;
                break;
            }
            case -804938332: {
                if (!string.equals("Code 128")) break;
                n2 = 2;
                break;
            }
            case -1252823991: {
                if (!string.equals("EAN 128")) break;
                n2 = 3;
                break;
            }
            case -1688533671: {
                if (!string.equals("Code 39")) break;
                n2 = 4;
                break;
            }
            case -297632757: {
                if (!string.equals("Datamatrix")) break;
                n2 = 5;
                break;
            }
            case 72827: {
                if (!string.equals("ITF")) break;
                n2 = 6;
                break;
            }
            case 2027637574: {
                if (!string.equals("DUN 14")) break;
                n2 = 7;
                break;
            }
            case -1939698872: {
                if (!string.equals("PDF417")) break;
                n2 = 8;
                break;
            }
            case 65735370: {
                if (!string.equals("EAN 8")) break;
                n2 = 9;
                break;
            }
            case 80948009: {
                if (!string.equals("UPC A")) break;
                n2 = 10;
                break;
            }
            case 80948013: {
                if (!string.equals("UPC E")) break;
                n2 = 11;
                break;
            }
            case 2037796304: {
                if (!string.equals("EAN 13")) break;
                n2 = 12;
            }
        }
        switch (n2) {
            case 0: {
                return 12;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 0;
            }
        }
        return -1;
    }

    public int getId() {
        return this.a;
    }

    public String getName() {
        return this.c;
    }

    public int getLength() {
        return this.b;
    }
}

