/*
 * Decompiled with CFR 0.152.
 */
package com.systel.print;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public enum AICode {
    SEPARADOR(0, "AbmCodeBar.Separador", 1, 0),
    LOTE(10, "AbmCodeBar.Lote", 2, 20),
    ID_BALANZA(235, "AbmCodeBar.Id de balanza", 3, 28),
    FECHA_VENCIMIENTO(17, "AbmCodeBar.Fecha de vencimiento", 2, 6),
    PRECIO_UNITARIO(8005, "AbmCodeBar.Precio Unitario", 4, 6),
    PESO_NETO(3103, "AbmCodeBar.Peso Neto", 4, 6),
    IDENTIFICACION_TRANSACCION(8019, "AbmCodeBar.N\u00b0 de identificaci\u00f3n de la transacci\u00f3n.", 4, 10),
    TOTAL_VENTA(3922, "AbmCodeBar.Total de venta", 4, 15),
    PESO_BRUTO(3303, "AbmCodeBar.Peso bruto", 4, 6),
    FECHA_EMBALAJE(11, "AbmCodeBar.Fecha de embalaje", 2, 6);

    private final int id;
    private final String bundleKey;
    private final int cantCode;
    private final int cantValue;
    private static final Map<Integer, AICode> a;

    private AICode(int n3, String string2, int n4, int n5) {
        this.id = n3;
        this.bundleKey = string2;
        this.cantCode = n4;
        this.cantValue = n5;
    }

    public final int getId() {
        return this.id;
    }

    public final String getDescription() {
        return ResourceBundle.getBundle("com/systel/print/editor/Bundle").getString(this.bundleKey);
    }

    public final int getCantCharCode() {
        return this.cantCode;
    }

    public final int getCantCharVal() {
        return this.cantValue;
    }

    public final int getCantChar() {
        return this.cantCode + this.cantValue;
    }

    public static AICode getById(int n2) {
        return a.get(n2);
    }

    public static String getDescriptionById(int n2) {
        AICode aICode = AICode.getById(n2);
        if (aICode != null) {
            return aICode.getDescription();
        }
        return null;
    }

    public static Integer getCantCharById(int n2) {
        AICode aICode = AICode.getById(n2);
        if (aICode != null) {
            return aICode.getCantCharCode() + aICode.getCantCharVal();
        }
        return null;
    }

    static {
        HashMap<Integer, AICode> hashMap = new HashMap<Integer, AICode>();
        for (AICode aICode : AICode.values()) {
            hashMap.put(aICode.getId(), aICode);
        }
        a = Collections.unmodifiableMap(hashMap);
    }
}

