/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import java.util.Arrays;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int width, int height) {
        this.bytes = new byte[height][width];
        this.width = width;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int x2, int y2) {
        return this.bytes[y2][x2];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int x2, int y2, byte value) {
        this.bytes[y2][x2] = value;
    }

    public void set(int x2, int y2, int value) {
        this.bytes[y2][x2] = (byte)value;
    }

    public void set(int x2, int y2, boolean value) {
        this.bytes[y2][x2] = (byte)(value ? 1 : 0);
    }

    public void clear(byte value) {
        byte[][] byArray = this.bytes;
        int n2 = this.bytes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Arrays.fill(byArray[i2], value);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(2 * this.width * this.height + 2);
        for (int y2 = 0; y2 < this.height; ++y2) {
            byte[] bytesY = this.bytes[y2];
            block5: for (int x2 = 0; x2 < this.width; ++x2) {
                switch (bytesY[x2]) {
                    case 0: {
                        result.append(" 0");
                        continue block5;
                    }
                    case 1: {
                        result.append(" 1");
                        continue block5;
                    }
                    default: {
                        result.append("  ");
                    }
                }
            }
            result.append('\n');
        }
        return result.toString();
    }
}

